package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface NamedClusterRoleFluent<A extends NamedClusterRoleFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Boolean hasName();
    
/**
 * This method has been deprecated, please use method buildRole instead.
 * @return The buildable object.
 */
@Deprecated public ClusterRole getRole();
    public ClusterRole buildRole();
    public A withRole(ClusterRole role);
    public Boolean hasRole();
    public NamedClusterRoleFluent.RoleNested<A> withNewRole();
    public NamedClusterRoleFluent.RoleNested<A> withNewRoleLike(ClusterRole item);
    public NamedClusterRoleFluent.RoleNested<A> editRole();
    public NamedClusterRoleFluent.RoleNested<A> editOrNewRole();
    public NamedClusterRoleFluent.RoleNested<A> editOrNewRoleLike(ClusterRole item);

    public interface RoleNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleFluent<NamedClusterRoleFluent.RoleNested<N>>{

        
    public N and();    public N endRole();
}


}
