package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesSubjectBuilder extends KubernetesSubjectFluentImpl<KubernetesSubjectBuilder> implements VisitableBuilder<KubernetesSubject,KubernetesSubjectBuilder>{

    KubernetesSubjectFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesSubjectBuilder(){
            this(true);
    }
    public KubernetesSubjectBuilder(Boolean validationEnabled){
            this(new KubernetesSubject(), validationEnabled);
    }
    public KubernetesSubjectBuilder(KubernetesSubjectFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesSubjectBuilder(KubernetesSubjectFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesSubject(), validationEnabled);
    }
    public KubernetesSubjectBuilder(KubernetesSubjectFluent<?> fluent,KubernetesSubject instance){
            this(fluent, instance, true);
    }
    public KubernetesSubjectBuilder(KubernetesSubjectFluent<?> fluent,KubernetesSubject instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiGroup(instance.getApiGroup()); 
            fluent.withKind(instance.getKind()); 
            fluent.withName(instance.getName()); 
            fluent.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesSubjectBuilder(KubernetesSubject instance){
            this(instance,true);
    }
    public KubernetesSubjectBuilder(KubernetesSubject instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiGroup(instance.getApiGroup()); 
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.withNamespace(instance.getNamespace()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubernetesSubject build(){
            KubernetesSubject buildable = new KubernetesSubject(fluent.getApiGroup(),fluent.getKind(),fluent.getName(),fluent.getNamespace());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesSubjectBuilder that = (KubernetesSubjectBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
