package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesAggregationRuleBuilder extends KubernetesAggregationRuleFluentImpl<KubernetesAggregationRuleBuilder> implements VisitableBuilder<KubernetesAggregationRule,KubernetesAggregationRuleBuilder>{

    KubernetesAggregationRuleFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesAggregationRuleBuilder(){
            this(true);
    }
    public KubernetesAggregationRuleBuilder(Boolean validationEnabled){
            this(new KubernetesAggregationRule(), validationEnabled);
    }
    public KubernetesAggregationRuleBuilder(KubernetesAggregationRuleFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesAggregationRuleBuilder(KubernetesAggregationRuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesAggregationRule(), validationEnabled);
    }
    public KubernetesAggregationRuleBuilder(KubernetesAggregationRuleFluent<?> fluent,KubernetesAggregationRule instance){
            this(fluent, instance, true);
    }
    public KubernetesAggregationRuleBuilder(KubernetesAggregationRuleFluent<?> fluent,KubernetesAggregationRule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClusterRoleSelectors(instance.getClusterRoleSelectors()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesAggregationRuleBuilder(KubernetesAggregationRule instance){
            this(instance,true);
    }
    public KubernetesAggregationRuleBuilder(KubernetesAggregationRule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClusterRoleSelectors(instance.getClusterRoleSelectors()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubernetesAggregationRule build(){
            KubernetesAggregationRule buildable = new KubernetesAggregationRule(fluent.getClusterRoleSelectors());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesAggregationRuleBuilder that = (KubernetesAggregationRuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
