package io.fabric8.kubernetes.api.model.authentication;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class TokenReviewStatusFluentImpl<A extends TokenReviewStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TokenReviewStatusFluent<A>{

    private Boolean authenticated;
    private String error;
    private UserInfoBuilder user;

    public TokenReviewStatusFluentImpl(){
    }
    public TokenReviewStatusFluentImpl(TokenReviewStatus instance){
            this.withAuthenticated(instance.getAuthenticated()); 
            this.withError(instance.getError()); 
            this.withUser(instance.getUser()); 
    }

    public Boolean isAuthenticated(){
            return this.authenticated;
    }

    public A withAuthenticated(Boolean authenticated){
            this.authenticated=authenticated; return (A) this;
    }

    public Boolean hasAuthenticated(){
            return this.authenticated != null;
    }

    public String getError(){
            return this.error;
    }

    public A withError(String error){
            this.error=error; return (A) this;
    }

    public Boolean hasError(){
            return this.error != null;
    }

    
/**
 * This method has been deprecated, please use method buildUser instead.
 */
@Deprecated public UserInfo getUser(){
            return this.user!=null?this.user.build():null;
    }

    public UserInfo buildUser(){
            return this.user!=null?this.user.build():null;
    }

    public A withUser(UserInfo user){
            _visitables.remove(this.user);
            if (user!=null){ this.user= new UserInfoBuilder(user); _visitables.add(this.user);} return (A) this;
    }

    public Boolean hasUser(){
            return this.user != null;
    }

    public TokenReviewStatusFluent.UserNested<A> withNewUser(){
            return new UserNestedImpl();
    }

    public TokenReviewStatusFluent.UserNested<A> withNewUserLike(UserInfo item){
            return new UserNestedImpl(item);
    }

    public TokenReviewStatusFluent.UserNested<A> editUser(){
            return withNewUserLike(getUser());
    }

    public TokenReviewStatusFluent.UserNested<A> editOrNewUser(){
            return withNewUserLike(getUser() != null ? getUser(): new UserInfoBuilder().build());
    }

    public TokenReviewStatusFluent.UserNested<A> editOrNewUserLike(UserInfo item){
            return withNewUserLike(getUser() != null ? getUser(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TokenReviewStatusFluentImpl that = (TokenReviewStatusFluentImpl) o;
            if (authenticated != null ? !authenticated.equals(that.authenticated) :that.authenticated != null) return false;
            if (error != null ? !error.equals(that.error) :that.error != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            return true;
    }


    public class UserNestedImpl<N> extends UserInfoFluentImpl<TokenReviewStatusFluent.UserNested<N>> implements TokenReviewStatusFluent.UserNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final UserInfoBuilder builder;
    
            UserNestedImpl(UserInfo item){
                    this.builder = new UserInfoBuilder(this, item);
            }
            UserNestedImpl(){
                    this.builder = new UserInfoBuilder(this);
            }
    
    public N and(){
            return (N) TokenReviewStatusFluentImpl.this.withUser(builder.build());
    }
    public N endUser(){
            return and();
    }

}


}
