package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesClusterRoleListBuilder extends KubernetesClusterRoleListFluentImpl<KubernetesClusterRoleListBuilder> implements VisitableBuilder<KubernetesClusterRoleList,KubernetesClusterRoleListBuilder>{

    KubernetesClusterRoleListFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesClusterRoleListBuilder(){
            this(true);
    }
    public KubernetesClusterRoleListBuilder(Boolean validationEnabled){
            this(new KubernetesClusterRoleList(), validationEnabled);
    }
    public KubernetesClusterRoleListBuilder(KubernetesClusterRoleListFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesClusterRoleListBuilder(KubernetesClusterRoleListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesClusterRoleList(), validationEnabled);
    }
    public KubernetesClusterRoleListBuilder(KubernetesClusterRoleListFluent<?> fluent,KubernetesClusterRoleList instance){
            this(fluent, instance, true);
    }
    public KubernetesClusterRoleListBuilder(KubernetesClusterRoleListFluent<?> fluent,KubernetesClusterRoleList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesClusterRoleListBuilder(KubernetesClusterRoleList instance){
            this(instance,true);
    }
    public KubernetesClusterRoleListBuilder(KubernetesClusterRoleList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubernetesClusterRoleList build(){
            KubernetesClusterRoleList buildable = new KubernetesClusterRoleList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesClusterRoleListBuilder that = (KubernetesClusterRoleListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
