package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageStreamBuilder extends ImageStreamFluentImpl<ImageStreamBuilder> implements VisitableBuilder<ImageStream,ImageStreamBuilder>{

    ImageStreamFluent<?> fluent;
    Boolean validationEnabled;

    public ImageStreamBuilder(){
            this(true);
    }
    public ImageStreamBuilder(Boolean validationEnabled){
            this(new ImageStream(), validationEnabled);
    }
    public ImageStreamBuilder(ImageStreamFluent<?> fluent){
            this(fluent, true);
    }
    public ImageStreamBuilder(ImageStreamFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ImageStream(), validationEnabled);
    }
    public ImageStreamBuilder(ImageStreamFluent<?> fluent,ImageStream instance){
            this(fluent, instance, true);
    }
    public ImageStreamBuilder(ImageStreamFluent<?> fluent,ImageStream instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ImageStreamBuilder(ImageStream instance){
            this(instance,true);
    }
    public ImageStreamBuilder(ImageStream instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public ImageStream build(){
            ImageStream buildable = new ImageStream(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageStreamBuilder that = (ImageStreamBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
