package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.String;
import java.lang.Boolean;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;

public interface PersistentVolumeSpecFluent<A extends PersistentVolumeSpecFluent<A>> extends Fluent<A>{


    public A addToAccessModes(int index,String item);
    public A setToAccessModes(int index,String item);
    public A addToAccessModes(String... items);
    public A addAllToAccessModes(Collection<String> items);
    public A removeFromAccessModes(String... items);
    public A removeAllFromAccessModes(Collection<String> items);
    public List<String> getAccessModes();
    public String getAccessMode(int index);
    public String getFirstAccessMode();
    public String getLastAccessMode();
    public String getMatchingAccessMode(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withAccessModes(List<String> accessModes);
    public A withAccessModes(String... accessModes);
    public Boolean hasAccessModes();
    
/**
 * This method has been deprecated, please use method buildAwsElasticBlockStore instead.
 */
@Deprecated public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore();
    public AWSElasticBlockStoreVolumeSource buildAwsElasticBlockStore();
    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore);
    public Boolean hasAwsElasticBlockStore();
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore();
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item);
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore();
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore();
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item);
    public A withNewAwsElasticBlockStore(String fsType,Integer partition,Boolean readOnly,String volumeID);
    
/**
 * This method has been deprecated, please use method buildAzureDisk instead.
 */
@Deprecated public AzureDiskVolumeSource getAzureDisk();
    public AzureDiskVolumeSource buildAzureDisk();
    public A withAzureDisk(AzureDiskVolumeSource azureDisk);
    public Boolean hasAzureDisk();
    public PersistentVolumeSpecFluent.AzureDiskNested<A> withNewAzureDisk();
    public PersistentVolumeSpecFluent.AzureDiskNested<A> withNewAzureDiskLike(AzureDiskVolumeSource item);
    public PersistentVolumeSpecFluent.AzureDiskNested<A> editAzureDisk();
    public PersistentVolumeSpecFluent.AzureDiskNested<A> editOrNewAzureDisk();
    public PersistentVolumeSpecFluent.AzureDiskNested<A> editOrNewAzureDiskLike(AzureDiskVolumeSource item);
    
/**
 * This method has been deprecated, please use method buildAzureFile instead.
 */
@Deprecated public AzureFileVolumeSource getAzureFile();
    public AzureFileVolumeSource buildAzureFile();
    public A withAzureFile(AzureFileVolumeSource azureFile);
    public Boolean hasAzureFile();
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFile();
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item);
    public PersistentVolumeSpecFluent.AzureFileNested<A> editAzureFile();
    public PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFile();
    public PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFileLike(AzureFileVolumeSource item);
    public A withNewAzureFile(Boolean readOnly,String secretName,String shareName);
    public A addToCapacity(String key,Quantity value);
    public A addToCapacity(Map<String,Quantity> map);
    public A removeFromCapacity(String key);
    public A removeFromCapacity(Map<String,Quantity> map);
    public Map<String,Quantity> getCapacity();
    public A withCapacity(Map<String,Quantity> capacity);
    public Boolean hasCapacity();
    
/**
 * This method has been deprecated, please use method buildCephfs instead.
 */
@Deprecated public CephFSVolumeSource getCephfs();
    public CephFSVolumeSource buildCephfs();
    public A withCephfs(CephFSVolumeSource cephfs);
    public Boolean hasCephfs();
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfs();
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item);
    public PersistentVolumeSpecFluent.CephfsNested<A> editCephfs();
    public PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfs();
    public PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfsLike(CephFSVolumeSource item);
    
/**
 * This method has been deprecated, please use method buildCinder instead.
 */
@Deprecated public CinderVolumeSource getCinder();
    public CinderVolumeSource buildCinder();
    public A withCinder(CinderVolumeSource cinder);
    public Boolean hasCinder();
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinder();
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item);
    public PersistentVolumeSpecFluent.CinderNested<A> editCinder();
    public PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinder();
    public PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinderLike(CinderVolumeSource item);
    public A withNewCinder(String fsType,Boolean readOnly,String volumeID);
    
/**
 * This method has been deprecated, please use method buildClaimRef instead.
 */
@Deprecated public ObjectReference getClaimRef();
    public ObjectReference buildClaimRef();
    public A withClaimRef(ObjectReference claimRef);
    public Boolean hasClaimRef();
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRef();
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRefLike(ObjectReference item);
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editClaimRef();
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRef();
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRefLike(ObjectReference item);
    
/**
 * This method has been deprecated, please use method buildFc instead.
 */
@Deprecated public FCVolumeSource getFc();
    public FCVolumeSource buildFc();
    public A withFc(FCVolumeSource fc);
    public Boolean hasFc();
    public PersistentVolumeSpecFluent.FcNested<A> withNewFc();
    public PersistentVolumeSpecFluent.FcNested<A> withNewFcLike(FCVolumeSource item);
    public PersistentVolumeSpecFluent.FcNested<A> editFc();
    public PersistentVolumeSpecFluent.FcNested<A> editOrNewFc();
    public PersistentVolumeSpecFluent.FcNested<A> editOrNewFcLike(FCVolumeSource item);
    
/**
 * This method has been deprecated, please use method buildFlexVolume instead.
 */
@Deprecated public FlexVolumeSource getFlexVolume();
    public FlexVolumeSource buildFlexVolume();
    public A withFlexVolume(FlexVolumeSource flexVolume);
    public Boolean hasFlexVolume();
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolume();
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item);
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editFlexVolume();
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolume();
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolumeLike(FlexVolumeSource item);
    
/**
 * This method has been deprecated, please use method buildFlocker instead.
 */
@Deprecated public FlockerVolumeSource getFlocker();
    public FlockerVolumeSource buildFlocker();
    public A withFlocker(FlockerVolumeSource flocker);
    public Boolean hasFlocker();
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlocker();
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item);
    public PersistentVolumeSpecFluent.FlockerNested<A> editFlocker();
    public PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlocker();
    public PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlockerLike(FlockerVolumeSource item);
    public A withNewFlocker(String datasetName,String datasetUUID);
    
/**
 * This method has been deprecated, please use method buildGcePersistentDisk instead.
 */
@Deprecated public GCEPersistentDiskVolumeSource getGcePersistentDisk();
    public GCEPersistentDiskVolumeSource buildGcePersistentDisk();
    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk);
    public Boolean hasGcePersistentDisk();
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk();
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item);
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editGcePersistentDisk();
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDisk();
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item);
    public A withNewGcePersistentDisk(String fsType,Integer partition,String pdName,Boolean readOnly);
    
/**
 * This method has been deprecated, please use method buildGlusterfs instead.
 */
@Deprecated public GlusterfsVolumeSource getGlusterfs();
    public GlusterfsVolumeSource buildGlusterfs();
    public A withGlusterfs(GlusterfsVolumeSource glusterfs);
    public Boolean hasGlusterfs();
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfs();
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item);
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editGlusterfs();
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfs();
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfsLike(GlusterfsVolumeSource item);
    public A withNewGlusterfs(String endpoints,String path,Boolean readOnly);
    
/**
 * This method has been deprecated, please use method buildHostPath instead.
 */
@Deprecated public HostPathVolumeSource getHostPath();
    public HostPathVolumeSource buildHostPath();
    public A withHostPath(HostPathVolumeSource hostPath);
    public Boolean hasHostPath();
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPath();
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item);
    public PersistentVolumeSpecFluent.HostPathNested<A> editHostPath();
    public PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPath();
    public PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPathLike(HostPathVolumeSource item);
    public A withNewHostPath(String path);
    
/**
 * This method has been deprecated, please use method buildIscsi instead.
 */
@Deprecated public ISCSIVolumeSource getIscsi();
    public ISCSIVolumeSource buildIscsi();
    public A withIscsi(ISCSIVolumeSource iscsi);
    public Boolean hasIscsi();
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsi();
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item);
    public PersistentVolumeSpecFluent.IscsiNested<A> editIscsi();
    public PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsi();
    public PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsiLike(ISCSIVolumeSource item);
    
/**
 * This method has been deprecated, please use method buildLocal instead.
 */
@Deprecated public LocalVolumeSource getLocal();
    public LocalVolumeSource buildLocal();
    public A withLocal(LocalVolumeSource local);
    public Boolean hasLocal();
    public PersistentVolumeSpecFluent.LocalNested<A> withNewLocal();
    public PersistentVolumeSpecFluent.LocalNested<A> withNewLocalLike(LocalVolumeSource item);
    public PersistentVolumeSpecFluent.LocalNested<A> editLocal();
    public PersistentVolumeSpecFluent.LocalNested<A> editOrNewLocal();
    public PersistentVolumeSpecFluent.LocalNested<A> editOrNewLocalLike(LocalVolumeSource item);
    public A withNewLocal(String path);
    
/**
 * This method has been deprecated, please use method buildNfs instead.
 */
@Deprecated public NFSVolumeSource getNfs();
    public NFSVolumeSource buildNfs();
    public A withNfs(NFSVolumeSource nfs);
    public Boolean hasNfs();
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfs();
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item);
    public PersistentVolumeSpecFluent.NfsNested<A> editNfs();
    public PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfs();
    public PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfsLike(NFSVolumeSource item);
    public A withNewNfs(String path,Boolean readOnly,String server);
    public String getPersistentVolumeReclaimPolicy();
    public A withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy);
    public Boolean hasPersistentVolumeReclaimPolicy();
    
/**
 * This method has been deprecated, please use method buildPhotonPersistentDisk instead.
 */
@Deprecated public PhotonPersistentDiskVolumeSource getPhotonPersistentDisk();
    public PhotonPersistentDiskVolumeSource buildPhotonPersistentDisk();
    public A withPhotonPersistentDisk(PhotonPersistentDiskVolumeSource photonPersistentDisk);
    public Boolean hasPhotonPersistentDisk();
    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> withNewPhotonPersistentDisk();
    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> withNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item);
    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editPhotonPersistentDisk();
    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDisk();
    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item);
    public A withNewPhotonPersistentDisk(String fsType,String pdID);
    
/**
 * This method has been deprecated, please use method buildPortworxVolume instead.
 */
@Deprecated public PortworxVolumeSource getPortworxVolume();
    public PortworxVolumeSource buildPortworxVolume();
    public A withPortworxVolume(PortworxVolumeSource portworxVolume);
    public Boolean hasPortworxVolume();
    public PersistentVolumeSpecFluent.PortworxVolumeNested<A> withNewPortworxVolume();
    public PersistentVolumeSpecFluent.PortworxVolumeNested<A> withNewPortworxVolumeLike(PortworxVolumeSource item);
    public PersistentVolumeSpecFluent.PortworxVolumeNested<A> editPortworxVolume();
    public PersistentVolumeSpecFluent.PortworxVolumeNested<A> editOrNewPortworxVolume();
    public PersistentVolumeSpecFluent.PortworxVolumeNested<A> editOrNewPortworxVolumeLike(PortworxVolumeSource item);
    public A withNewPortworxVolume(String fsType,Boolean readOnly,String volumeID);
    
/**
 * This method has been deprecated, please use method buildQuobyte instead.
 */
@Deprecated public QuobyteVolumeSource getQuobyte();
    public QuobyteVolumeSource buildQuobyte();
    public A withQuobyte(QuobyteVolumeSource quobyte);
    public Boolean hasQuobyte();
    public PersistentVolumeSpecFluent.QuobyteNested<A> withNewQuobyte();
    public PersistentVolumeSpecFluent.QuobyteNested<A> withNewQuobyteLike(QuobyteVolumeSource item);
    public PersistentVolumeSpecFluent.QuobyteNested<A> editQuobyte();
    public PersistentVolumeSpecFluent.QuobyteNested<A> editOrNewQuobyte();
    public PersistentVolumeSpecFluent.QuobyteNested<A> editOrNewQuobyteLike(QuobyteVolumeSource item);
    public A withNewQuobyte(String group,Boolean readOnly,String registry,String user,String volume);
    
/**
 * This method has been deprecated, please use method buildRbd instead.
 */
@Deprecated public RBDVolumeSource getRbd();
    public RBDVolumeSource buildRbd();
    public A withRbd(RBDVolumeSource rbd);
    public Boolean hasRbd();
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbd();
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item);
    public PersistentVolumeSpecFluent.RbdNested<A> editRbd();
    public PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbd();
    public PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbdLike(RBDVolumeSource item);
    
/**
 * This method has been deprecated, please use method buildScaleIO instead.
 */
@Deprecated public ScaleIOVolumeSource getScaleIO();
    public ScaleIOVolumeSource buildScaleIO();
    public A withScaleIO(ScaleIOVolumeSource scaleIO);
    public Boolean hasScaleIO();
    public PersistentVolumeSpecFluent.ScaleIONested<A> withNewScaleIO();
    public PersistentVolumeSpecFluent.ScaleIONested<A> withNewScaleIOLike(ScaleIOVolumeSource item);
    public PersistentVolumeSpecFluent.ScaleIONested<A> editScaleIO();
    public PersistentVolumeSpecFluent.ScaleIONested<A> editOrNewScaleIO();
    public PersistentVolumeSpecFluent.ScaleIONested<A> editOrNewScaleIOLike(ScaleIOVolumeSource item);
    public String getStorageClassName();
    public A withStorageClassName(String storageClassName);
    public Boolean hasStorageClassName();
    
/**
 * This method has been deprecated, please use method buildStorageos instead.
 */
@Deprecated public StorageOSPersistentVolumeSource getStorageos();
    public StorageOSPersistentVolumeSource buildStorageos();
    public A withStorageos(StorageOSPersistentVolumeSource storageos);
    public Boolean hasStorageos();
    public PersistentVolumeSpecFluent.StorageosNested<A> withNewStorageos();
    public PersistentVolumeSpecFluent.StorageosNested<A> withNewStorageosLike(StorageOSPersistentVolumeSource item);
    public PersistentVolumeSpecFluent.StorageosNested<A> editStorageos();
    public PersistentVolumeSpecFluent.StorageosNested<A> editOrNewStorageos();
    public PersistentVolumeSpecFluent.StorageosNested<A> editOrNewStorageosLike(StorageOSPersistentVolumeSource item);
    
/**
 * This method has been deprecated, please use method buildVsphereVolume instead.
 */
@Deprecated public VsphereVirtualDiskVolumeSource getVsphereVolume();
    public VsphereVirtualDiskVolumeSource buildVsphereVolume();
    public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume);
    public Boolean hasVsphereVolume();
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolume();
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item);
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editVsphereVolume();
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolume();
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item);
    public A withNewVsphereVolume(String fsType,String storagePolicyID,String storagePolicyName,String volumePath);

    public interface AwsElasticBlockStoreNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AWSElasticBlockStoreVolumeSourceFluent<PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>>{

        
    public N and();    public N endAwsElasticBlockStore();
}
    public interface AzureDiskNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AzureDiskVolumeSourceFluent<PersistentVolumeSpecFluent.AzureDiskNested<N>>{

        
    public N and();    public N endAzureDisk();
}
    public interface AzureFileNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AzureFileVolumeSourceFluent<PersistentVolumeSpecFluent.AzureFileNested<N>>{

        
    public N and();    public N endAzureFile();
}
    public interface CephfsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CephFSVolumeSourceFluent<PersistentVolumeSpecFluent.CephfsNested<N>>{

        
    public N and();    public N endCephfs();
}
    public interface CinderNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CinderVolumeSourceFluent<PersistentVolumeSpecFluent.CinderNested<N>>{

        
    public N and();    public N endCinder();
}
    public interface ClaimRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<PersistentVolumeSpecFluent.ClaimRefNested<N>>{

        
    public N and();    public N endClaimRef();
}
    public interface FcNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FCVolumeSourceFluent<PersistentVolumeSpecFluent.FcNested<N>>{

        
    public N and();    public N endFc();
}
    public interface FlexVolumeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FlexVolumeSourceFluent<PersistentVolumeSpecFluent.FlexVolumeNested<N>>{

        
    public N and();    public N endFlexVolume();
}
    public interface FlockerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FlockerVolumeSourceFluent<PersistentVolumeSpecFluent.FlockerNested<N>>{

        
    public N and();    public N endFlocker();
}
    public interface GcePersistentDiskNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GCEPersistentDiskVolumeSourceFluent<PersistentVolumeSpecFluent.GcePersistentDiskNested<N>>{

        
    public N and();    public N endGcePersistentDisk();
}
    public interface GlusterfsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GlusterfsVolumeSourceFluent<PersistentVolumeSpecFluent.GlusterfsNested<N>>{

        
    public N and();    public N endGlusterfs();
}
    public interface HostPathNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HostPathVolumeSourceFluent<PersistentVolumeSpecFluent.HostPathNested<N>>{

        
    public N and();    public N endHostPath();
}
    public interface IscsiNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ISCSIVolumeSourceFluent<PersistentVolumeSpecFluent.IscsiNested<N>>{

        
    public N and();    public N endIscsi();
}
    public interface LocalNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalVolumeSourceFluent<PersistentVolumeSpecFluent.LocalNested<N>>{

        
    public N and();    public N endLocal();
}
    public interface NfsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NFSVolumeSourceFluent<PersistentVolumeSpecFluent.NfsNested<N>>{

        
    public N and();    public N endNfs();
}
    public interface PhotonPersistentDiskNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PhotonPersistentDiskVolumeSourceFluent<PersistentVolumeSpecFluent.PhotonPersistentDiskNested<N>>{

        
    public N and();    public N endPhotonPersistentDisk();
}
    public interface PortworxVolumeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PortworxVolumeSourceFluent<PersistentVolumeSpecFluent.PortworxVolumeNested<N>>{

        
    public N and();    public N endPortworxVolume();
}
    public interface QuobyteNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,QuobyteVolumeSourceFluent<PersistentVolumeSpecFluent.QuobyteNested<N>>{

        
    public N and();    public N endQuobyte();
}
    public interface RbdNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RBDVolumeSourceFluent<PersistentVolumeSpecFluent.RbdNested<N>>{

        
    public N and();    public N endRbd();
}
    public interface ScaleIONested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ScaleIOVolumeSourceFluent<PersistentVolumeSpecFluent.ScaleIONested<N>>{

        
    public N and();    public N endScaleIO();
}
    public interface StorageosNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StorageOSPersistentVolumeSourceFluent<PersistentVolumeSpecFluent.StorageosNested<N>>{

        
    public N and();    public N endStorageos();
}
    public interface VsphereVolumeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VsphereVirtualDiskVolumeSourceFluent<PersistentVolumeSpecFluent.VsphereVolumeNested<N>>{

        
    public N and();    public N endVsphereVolume();
}


}
