package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface SecurityContextConstraintsFluent<A extends SecurityContextConstraintsFluent<A>> extends Fluent<A>{


    public Boolean isAllowHostDirVolumePlugin();
    public A withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin);
    public Boolean hasAllowHostDirVolumePlugin();
    public Boolean isAllowHostIPC();
    public A withAllowHostIPC(Boolean allowHostIPC);
    public Boolean hasAllowHostIPC();
    public Boolean isAllowHostNetwork();
    public A withAllowHostNetwork(Boolean allowHostNetwork);
    public Boolean hasAllowHostNetwork();
    public Boolean isAllowHostPID();
    public A withAllowHostPID(Boolean allowHostPID);
    public Boolean hasAllowHostPID();
    public Boolean isAllowHostPorts();
    public A withAllowHostPorts(Boolean allowHostPorts);
    public Boolean hasAllowHostPorts();
    public Boolean isAllowPrivilegedContainer();
    public A withAllowPrivilegedContainer(Boolean allowPrivilegedContainer);
    public Boolean hasAllowPrivilegedContainer();
    public A addToAllowedCapabilities(int index,String item);
    public A setToAllowedCapabilities(int index,String item);
    public A addToAllowedCapabilities(String... items);
    public A addAllToAllowedCapabilities(Collection<String> items);
    public A removeFromAllowedCapabilities(String... items);
    public A removeAllFromAllowedCapabilities(Collection<String> items);
    public List<String> getAllowedCapabilities();
    public String getAllowedCapability(int index);
    public String getFirstAllowedCapability();
    public String getLastAllowedCapability();
    public String getMatchingAllowedCapability(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withAllowedCapabilities(List<String> allowedCapabilities);
    public A withAllowedCapabilities(String... allowedCapabilities);
    public Boolean hasAllowedCapabilities();
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToDefaultAddCapabilities(int index,String item);
    public A setToDefaultAddCapabilities(int index,String item);
    public A addToDefaultAddCapabilities(String... items);
    public A addAllToDefaultAddCapabilities(Collection<String> items);
    public A removeFromDefaultAddCapabilities(String... items);
    public A removeAllFromDefaultAddCapabilities(Collection<String> items);
    public List<String> getDefaultAddCapabilities();
    public String getDefaultAddCapability(int index);
    public String getFirstDefaultAddCapability();
    public String getLastDefaultAddCapability();
    public String getMatchingDefaultAddCapability(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities);
    public A withDefaultAddCapabilities(String... defaultAddCapabilities);
    public Boolean hasDefaultAddCapabilities();
    
/**
 * This method has been deprecated, please use method buildFsGroup instead.
 */
@Deprecated public io.fabric8.openshift.api.model.FSGroupStrategyOptions getFsGroup();
    public io.fabric8.openshift.api.model.FSGroupStrategyOptions buildFsGroup();
    public A withFsGroup(io.fabric8.openshift.api.model.FSGroupStrategyOptions fsGroup);
    public Boolean hasFsGroup();
    public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroup();
    public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroupLike(io.fabric8.openshift.api.model.FSGroupStrategyOptions item);
    public SecurityContextConstraintsFluent.FsGroupNested<A> editFsGroup();
    public SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroup();
    public SecurityContextConstraintsFluent.FsGroupNested<A> editOrNewFsGroupLike(io.fabric8.openshift.api.model.FSGroupStrategyOptions item);
    public A addToGroups(int index,String item);
    public A setToGroups(int index,String item);
    public A addToGroups(String... items);
    public A addAllToGroups(Collection<String> items);
    public A removeFromGroups(String... items);
    public A removeAllFromGroups(Collection<String> items);
    public List<String> getGroups();
    public String getGroup(int index);
    public String getFirstGroup();
    public String getLastGroup();
    public String getMatchingGroup(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withGroups(List<String> groups);
    public A withGroups(String... groups);
    public Boolean hasGroups();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadata();
    public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public SecurityContextConstraintsFluent.MetadataNested<A> editMetadata();
    public SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadata();
    public SecurityContextConstraintsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public Integer getPriority();
    public A withPriority(Integer priority);
    public Boolean hasPriority();
    public Boolean isReadOnlyRootFilesystem();
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
    public Boolean hasReadOnlyRootFilesystem();
    public A addToRequiredDropCapabilities(int index,String item);
    public A setToRequiredDropCapabilities(int index,String item);
    public A addToRequiredDropCapabilities(String... items);
    public A addAllToRequiredDropCapabilities(Collection<String> items);
    public A removeFromRequiredDropCapabilities(String... items);
    public A removeAllFromRequiredDropCapabilities(Collection<String> items);
    public List<String> getRequiredDropCapabilities();
    public String getRequiredDropCapability(int index);
    public String getFirstRequiredDropCapability();
    public String getLastRequiredDropCapability();
    public String getMatchingRequiredDropCapability(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities);
    public A withRequiredDropCapabilities(String... requiredDropCapabilities);
    public Boolean hasRequiredDropCapabilities();
    
/**
 * This method has been deprecated, please use method buildRunAsUser instead.
 */
@Deprecated public RunAsUserStrategyOptions getRunAsUser();
    public RunAsUserStrategyOptions buildRunAsUser();
    public A withRunAsUser(RunAsUserStrategyOptions runAsUser);
    public Boolean hasRunAsUser();
    public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUser();
    public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item);
    public SecurityContextConstraintsFluent.RunAsUserNested<A> editRunAsUser();
    public SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUser();
    public SecurityContextConstraintsFluent.RunAsUserNested<A> editOrNewRunAsUserLike(RunAsUserStrategyOptions item);
    public A withNewRunAsUser(String type,Long uid,Long uidRangeMax,Long uidRangeMin);
    
/**
 * This method has been deprecated, please use method buildSeLinuxContext instead.
 */
@Deprecated public SELinuxContextStrategyOptions getSeLinuxContext();
    public SELinuxContextStrategyOptions buildSeLinuxContext();
    public A withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext);
    public Boolean hasSeLinuxContext();
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContext();
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item);
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editSeLinuxContext();
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContext();
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editOrNewSeLinuxContextLike(SELinuxContextStrategyOptions item);
    public A addToSeccompProfiles(int index,String item);
    public A setToSeccompProfiles(int index,String item);
    public A addToSeccompProfiles(String... items);
    public A addAllToSeccompProfiles(Collection<String> items);
    public A removeFromSeccompProfiles(String... items);
    public A removeAllFromSeccompProfiles(Collection<String> items);
    public List<String> getSeccompProfiles();
    public String getSeccompProfile(int index);
    public String getFirstSeccompProfile();
    public String getLastSeccompProfile();
    public String getMatchingSeccompProfile(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withSeccompProfiles(List<String> seccompProfiles);
    public A withSeccompProfiles(String... seccompProfiles);
    public Boolean hasSeccompProfiles();
    
/**
 * This method has been deprecated, please use method buildSupplementalGroups instead.
 */
@Deprecated public io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions getSupplementalGroups();
    public io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions buildSupplementalGroups();
    public A withSupplementalGroups(io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions supplementalGroups);
    public Boolean hasSupplementalGroups();
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroups();
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions item);
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editSupplementalGroups();
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups();
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptions item);
    public A addToUsers(int index,String item);
    public A setToUsers(int index,String item);
    public A addToUsers(String... items);
    public A addAllToUsers(Collection<String> items);
    public A removeFromUsers(String... items);
    public A removeAllFromUsers(Collection<String> items);
    public List<String> getUsers();
    public String getUser(int index);
    public String getFirstUser();
    public String getLastUser();
    public String getMatchingUser(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withUsers(List<String> users);
    public A withUsers(String... users);
    public Boolean hasUsers();
    public A addToVolumes(int index,String item);
    public A setToVolumes(int index,String item);
    public A addToVolumes(String... items);
    public A addAllToVolumes(Collection<String> items);
    public A removeFromVolumes(String... items);
    public A removeAllFromVolumes(Collection<String> items);
    public List<String> getVolumes();
    public String getVolume(int index);
    public String getFirstVolume();
    public String getLastVolume();
    public String getMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withVolumes(List<String> volumes);
    public A withVolumes(String... volumes);
    public Boolean hasVolumes();

    public interface FsGroupNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.FSGroupStrategyOptionsFluent<SecurityContextConstraintsFluent.FsGroupNested<N>>{

        
    public N and();    public N endFsGroup();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<SecurityContextConstraintsFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RunAsUserNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RunAsUserStrategyOptionsFluent<SecurityContextConstraintsFluent.RunAsUserNested<N>>{

        
    public N and();    public N endRunAsUser();
}
    public interface SeLinuxContextNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SELinuxContextStrategyOptionsFluent<SecurityContextConstraintsFluent.SeLinuxContextNested<N>>{

        
    public N and();    public N endSeLinuxContext();
}
    public interface SupplementalGroupsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.openshift.api.model.SupplementalGroupsStrategyOptionsFluent<SecurityContextConstraintsFluent.SupplementalGroupsNested<N>>{

        
    public N and();    public N endSupplementalGroups();
}


}
