package io.fabric8.kubernetes.api.model.extensions;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface DaemonSetStatusFluent<A extends DaemonSetStatusFluent<A>> extends Fluent<A>{


    public Long getCollisionCount();
    public A withCollisionCount(Long collisionCount);
    public Boolean hasCollisionCount();
    public Integer getCurrentNumberScheduled();
    public A withCurrentNumberScheduled(Integer currentNumberScheduled);
    public Boolean hasCurrentNumberScheduled();
    public Integer getDesiredNumberScheduled();
    public A withDesiredNumberScheduled(Integer desiredNumberScheduled);
    public Boolean hasDesiredNumberScheduled();
    public Integer getNumberAvailable();
    public A withNumberAvailable(Integer numberAvailable);
    public Boolean hasNumberAvailable();
    public Integer getNumberMisscheduled();
    public A withNumberMisscheduled(Integer numberMisscheduled);
    public Boolean hasNumberMisscheduled();
    public Integer getNumberReady();
    public A withNumberReady(Integer numberReady);
    public Boolean hasNumberReady();
    public Integer getNumberUnavailable();
    public A withNumberUnavailable(Integer numberUnavailable);
    public Boolean hasNumberUnavailable();
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public Integer getUpdatedNumberScheduled();
    public A withUpdatedNumberScheduled(Integer updatedNumberScheduled);
    public Boolean hasUpdatedNumberScheduled();



}
