package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface DownwardAPIProjectionFluent<A extends DownwardAPIProjectionFluent<A>> extends Fluent<A>{


    public A addToItems(int index,DownwardAPIVolumeFile item);
    public A setToItems(int index,DownwardAPIVolumeFile item);
    public A addToItems(DownwardAPIVolumeFile... items);
    public A addAllToItems(Collection<DownwardAPIVolumeFile> items);
    public A removeFromItems(DownwardAPIVolumeFile... items);
    public A removeAllFromItems(Collection<DownwardAPIVolumeFile> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 */
@Deprecated public List<DownwardAPIVolumeFile> getItems();
    public List<DownwardAPIVolumeFile> buildItems();
    public DownwardAPIVolumeFile buildItem(int index);
    public DownwardAPIVolumeFile buildFirstItem();
    public DownwardAPIVolumeFile buildLastItem();
    public DownwardAPIVolumeFile buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<DownwardAPIVolumeFileBuilder> predicate);
    public A withItems(List<DownwardAPIVolumeFile> items);
    public A withItems(DownwardAPIVolumeFile... items);
    public Boolean hasItems();
    public DownwardAPIProjectionFluent.ItemsNested<A> addNewItem();
    public DownwardAPIProjectionFluent.ItemsNested<A> addNewItemLike(DownwardAPIVolumeFile item);
    public DownwardAPIProjectionFluent.ItemsNested<A> setNewItemLike(int index,DownwardAPIVolumeFile item);
    public DownwardAPIProjectionFluent.ItemsNested<A> editItem(int index);
    public DownwardAPIProjectionFluent.ItemsNested<A> editFirstItem();
    public DownwardAPIProjectionFluent.ItemsNested<A> editLastItem();
    public DownwardAPIProjectionFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<DownwardAPIVolumeFileBuilder> predicate);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DownwardAPIVolumeFileFluent<DownwardAPIProjectionFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}


}
