package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Time;
import java.lang.String;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.TimeFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface StageInfoFluent<A extends StageInfoFluent<A>> extends Fluent<A>{


    public Long getDurationMilliseconds();
    public A withDurationMilliseconds(Long durationMilliseconds);
    public Boolean hasDurationMilliseconds();
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    
/**
 * This method has been deprecated, please use method buildStartTime instead.
 */
@Deprecated public Time getStartTime();
    public Time buildStartTime();
    public A withStartTime(Time startTime);
    public Boolean hasStartTime();
    public StageInfoFluent.StartTimeNested<A> withNewStartTime();
    public StageInfoFluent.StartTimeNested<A> withNewStartTimeLike(Time item);
    public StageInfoFluent.StartTimeNested<A> editStartTime();
    public StageInfoFluent.StartTimeNested<A> editOrNewStartTime();
    public StageInfoFluent.StartTimeNested<A> editOrNewStartTimeLike(Time item);
    public A withNewStartTime(String time);
    public A addToSteps(int index,StepInfo item);
    public A setToSteps(int index,StepInfo item);
    public A addToSteps(StepInfo... items);
    public A addAllToSteps(Collection<StepInfo> items);
    public A removeFromSteps(StepInfo... items);
    public A removeAllFromSteps(Collection<StepInfo> items);
    
/**
 * This method has been deprecated, please use method buildSteps instead.
 */
@Deprecated public List<StepInfo> getSteps();
    public List<StepInfo> buildSteps();
    public StepInfo buildStep(int index);
    public StepInfo buildFirstStep();
    public StepInfo buildLastStep();
    public StepInfo buildMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<StepInfoBuilder> predicate);
    public A withSteps(List<StepInfo> steps);
    public A withSteps(StepInfo... steps);
    public Boolean hasSteps();
    public StageInfoFluent.StepsNested<A> addNewStep();
    public StageInfoFluent.StepsNested<A> addNewStepLike(StepInfo item);
    public StageInfoFluent.StepsNested<A> setNewStepLike(int index,StepInfo item);
    public StageInfoFluent.StepsNested<A> editStep(int index);
    public StageInfoFluent.StepsNested<A> editFirstStep();
    public StageInfoFluent.StepsNested<A> editLastStep();
    public StageInfoFluent.StepsNested<A> editMatchingStep(io.fabric8.kubernetes.api.builder.Predicate<StepInfoBuilder> predicate);

    public interface StartTimeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeFluent<StageInfoFluent.StartTimeNested<N>>{

        
    public N and();    public N endStartTime();
}
    public interface StepsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StepInfoFluent<StageInfoFluent.StepsNested<N>>{

        
    public N and();    public N endStep();
}


}
