package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Time;
import java.lang.String;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class StepInfoFluentImpl<A extends StepInfoFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StepInfoFluent<A>{

    private Long durationMilliseconds;
    private String name;
    private TimeBuilder startTime;

    public StepInfoFluentImpl(){
    }
    public StepInfoFluentImpl(StepInfo instance){
            this.withDurationMilliseconds(instance.getDurationMilliseconds()); 
            this.withName(instance.getName()); 
            this.withStartTime(instance.getStartTime()); 
    }

    public Long getDurationMilliseconds(){
            return this.durationMilliseconds;
    }

    public A withDurationMilliseconds(Long durationMilliseconds){
            this.durationMilliseconds=durationMilliseconds; return (A) this;
    }

    public Boolean hasDurationMilliseconds(){
            return this.durationMilliseconds!=null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name!=null;
    }

    
/**
 * This method has been deprecated, please use method buildStartTime instead.
 */
@Deprecated public Time getStartTime(){
            return this.startTime!=null?this.startTime.build():null;
    }

    public Time buildStartTime(){
            return this.startTime!=null?this.startTime.build():null;
    }

    public A withStartTime(Time startTime){
            _visitables.remove(this.startTime);
            if (startTime!=null){ this.startTime= new TimeBuilder(startTime); _visitables.add(this.startTime);} return (A) this;
    }

    public Boolean hasStartTime(){
            return this.startTime!=null;
    }

    public StepInfoFluent.StartTimeNested<A> withNewStartTime(){
            return new StartTimeNestedImpl();
    }

    public StepInfoFluent.StartTimeNested<A> withNewStartTimeLike(Time item){
            return new StartTimeNestedImpl(item);
    }

    public StepInfoFluent.StartTimeNested<A> editStartTime(){
            return withNewStartTimeLike(getStartTime());
    }

    public StepInfoFluent.StartTimeNested<A> editOrNewStartTime(){
            return withNewStartTimeLike(getStartTime() != null ? getStartTime(): new TimeBuilder().build());
    }

    public StepInfoFluent.StartTimeNested<A> editOrNewStartTimeLike(Time item){
            return withNewStartTimeLike(getStartTime() != null ? getStartTime(): item);
    }

    public A withNewStartTime(String time){
            return (A)withStartTime(new Time(time));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StepInfoFluentImpl that = (StepInfoFluentImpl) o;
            if (durationMilliseconds != null ? !durationMilliseconds.equals(that.durationMilliseconds) :that.durationMilliseconds != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
            return true;
    }


    public class StartTimeNestedImpl<N> extends TimeFluentImpl<StepInfoFluent.StartTimeNested<N>> implements StepInfoFluent.StartTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            StartTimeNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            StartTimeNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) StepInfoFluentImpl.this.withStartTime(builder.build());
    }
    public N endStartTime(){
            return and();
    }

}


}
