package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Time;
import java.lang.String;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class DeploymentConditionFluentImpl<A extends io.fabric8.openshift.api.model.DeploymentConditionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.DeploymentConditionFluent<A>{

    private TimeBuilder lastTransitionTime;
    private TimeBuilder lastUpdateTime;
    private String message;
    private String reason;
    private String status;
    private String type;

    public DeploymentConditionFluentImpl(){
    }
    public DeploymentConditionFluentImpl(io.fabric8.openshift.api.model.DeploymentCondition instance){
            this.withLastTransitionTime(instance.getLastTransitionTime()); 
            this.withLastUpdateTime(instance.getLastUpdateTime()); 
            this.withMessage(instance.getMessage()); 
            this.withReason(instance.getReason()); 
            this.withStatus(instance.getStatus()); 
            this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildLastTransitionTime instead.
 */
@Deprecated public Time getLastTransitionTime(){
            return this.lastTransitionTime!=null?this.lastTransitionTime.build():null;
    }

    public Time buildLastTransitionTime(){
            return this.lastTransitionTime!=null?this.lastTransitionTime.build():null;
    }

    public A withLastTransitionTime(Time lastTransitionTime){
            _visitables.remove(this.lastTransitionTime);
            if (lastTransitionTime!=null){ this.lastTransitionTime= new TimeBuilder(lastTransitionTime); _visitables.add(this.lastTransitionTime);} return (A) this;
    }

    public Boolean hasLastTransitionTime(){
            return this.lastTransitionTime!=null;
    }

    public DeploymentConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTime(){
            return new LastTransitionTimeNestedImpl();
    }

    public DeploymentConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTimeLike(Time item){
            return new LastTransitionTimeNestedImpl(item);
    }

    public DeploymentConditionFluent.LastTransitionTimeNested<A> editLastTransitionTime(){
            return withNewLastTransitionTimeLike(getLastTransitionTime());
    }

    public DeploymentConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTime(){
            return withNewLastTransitionTimeLike(getLastTransitionTime() != null ? getLastTransitionTime(): new TimeBuilder().build());
    }

    public DeploymentConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTimeLike(Time item){
            return withNewLastTransitionTimeLike(getLastTransitionTime() != null ? getLastTransitionTime(): item);
    }

    public A withNewLastTransitionTime(String time){
            return (A)withLastTransitionTime(new Time(time));
    }

    
/**
 * This method has been deprecated, please use method buildLastUpdateTime instead.
 */
@Deprecated public Time getLastUpdateTime(){
            return this.lastUpdateTime!=null?this.lastUpdateTime.build():null;
    }

    public Time buildLastUpdateTime(){
            return this.lastUpdateTime!=null?this.lastUpdateTime.build():null;
    }

    public A withLastUpdateTime(Time lastUpdateTime){
            _visitables.remove(this.lastUpdateTime);
            if (lastUpdateTime!=null){ this.lastUpdateTime= new TimeBuilder(lastUpdateTime); _visitables.add(this.lastUpdateTime);} return (A) this;
    }

    public Boolean hasLastUpdateTime(){
            return this.lastUpdateTime!=null;
    }

    public DeploymentConditionFluent.LastUpdateTimeNested<A> withNewLastUpdateTime(){
            return new LastUpdateTimeNestedImpl();
    }

    public DeploymentConditionFluent.LastUpdateTimeNested<A> withNewLastUpdateTimeLike(Time item){
            return new LastUpdateTimeNestedImpl(item);
    }

    public DeploymentConditionFluent.LastUpdateTimeNested<A> editLastUpdateTime(){
            return withNewLastUpdateTimeLike(getLastUpdateTime());
    }

    public DeploymentConditionFluent.LastUpdateTimeNested<A> editOrNewLastUpdateTime(){
            return withNewLastUpdateTimeLike(getLastUpdateTime() != null ? getLastUpdateTime(): new TimeBuilder().build());
    }

    public DeploymentConditionFluent.LastUpdateTimeNested<A> editOrNewLastUpdateTimeLike(Time item){
            return withNewLastUpdateTimeLike(getLastUpdateTime() != null ? getLastUpdateTime(): item);
    }

    public A withNewLastUpdateTime(String time){
            return (A)withLastUpdateTime(new Time(time));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message!=null;
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason!=null;
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.status!=null;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentConditionFluentImpl that = (DeploymentConditionFluentImpl) o;
            if (lastTransitionTime != null ? !lastTransitionTime.equals(that.lastTransitionTime) :that.lastTransitionTime != null) return false;
            if (lastUpdateTime != null ? !lastUpdateTime.equals(that.lastUpdateTime) :that.lastUpdateTime != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class LastTransitionTimeNestedImpl<N> extends TimeFluentImpl<DeploymentConditionFluent.LastTransitionTimeNested<N>> implements DeploymentConditionFluent.LastTransitionTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            LastTransitionTimeNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            LastTransitionTimeNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentConditionFluentImpl.this.withLastTransitionTime(builder.build());
    }
    public N endLastTransitionTime(){
            return and();
    }

}
    public class LastUpdateTimeNestedImpl<N> extends TimeFluentImpl<DeploymentConditionFluent.LastUpdateTimeNested<N>> implements DeploymentConditionFluent.LastUpdateTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            LastUpdateTimeNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            LastUpdateTimeNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) DeploymentConditionFluentImpl.this.withLastUpdateTime(builder.build());
    }
    public N endLastUpdateTime(){
            return and();
    }

}


}
