package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerStateTerminatedFluentImpl<A extends ContainerStateTerminatedFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ContainerStateTerminatedFluent<A>{

    private String containerID;
    private Integer exitCode;
    private TimeBuilder finishedAt;
    private String message;
    private String reason;
    private Integer signal;
    private TimeBuilder startedAt;

    public ContainerStateTerminatedFluentImpl(){
    }
    public ContainerStateTerminatedFluentImpl(ContainerStateTerminated instance){
            this.withContainerID(instance.getContainerID()); 
            this.withExitCode(instance.getExitCode()); 
            this.withFinishedAt(instance.getFinishedAt()); 
            this.withMessage(instance.getMessage()); 
            this.withReason(instance.getReason()); 
            this.withSignal(instance.getSignal()); 
            this.withStartedAt(instance.getStartedAt()); 
    }

    public String getContainerID(){
            return this.containerID;
    }

    public A withContainerID(String containerID){
            this.containerID=containerID; return (A) this;
    }

    public Boolean hasContainerID(){
            return this.containerID!=null;
    }

    public Integer getExitCode(){
            return this.exitCode;
    }

    public A withExitCode(Integer exitCode){
            this.exitCode=exitCode; return (A) this;
    }

    public Boolean hasExitCode(){
            return this.exitCode!=null;
    }

    
/**
 * This method has been deprecated, please use method buildFinishedAt instead.
 */
@Deprecated public Time getFinishedAt(){
            return this.finishedAt!=null?this.finishedAt.build():null;
    }

    public Time buildFinishedAt(){
            return this.finishedAt!=null?this.finishedAt.build():null;
    }

    public A withFinishedAt(Time finishedAt){
            _visitables.remove(this.finishedAt);
            if (finishedAt!=null){ this.finishedAt= new TimeBuilder(finishedAt); _visitables.add(this.finishedAt);} return (A) this;
    }

    public Boolean hasFinishedAt(){
            return this.finishedAt!=null;
    }

    public ContainerStateTerminatedFluent.FinishedAtNested<A> withNewFinishedAt(){
            return new FinishedAtNestedImpl();
    }

    public ContainerStateTerminatedFluent.FinishedAtNested<A> withNewFinishedAtLike(Time item){
            return new FinishedAtNestedImpl(item);
    }

    public ContainerStateTerminatedFluent.FinishedAtNested<A> editFinishedAt(){
            return withNewFinishedAtLike(getFinishedAt());
    }

    public ContainerStateTerminatedFluent.FinishedAtNested<A> editOrNewFinishedAt(){
            return withNewFinishedAtLike(getFinishedAt() != null ? getFinishedAt(): new TimeBuilder().build());
    }

    public ContainerStateTerminatedFluent.FinishedAtNested<A> editOrNewFinishedAtLike(Time item){
            return withNewFinishedAtLike(getFinishedAt() != null ? getFinishedAt(): item);
    }

    public A withNewFinishedAt(String time){
            return (A)withFinishedAt(new Time(time));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message!=null;
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason!=null;
    }

    public Integer getSignal(){
            return this.signal;
    }

    public A withSignal(Integer signal){
            this.signal=signal; return (A) this;
    }

    public Boolean hasSignal(){
            return this.signal!=null;
    }

    
/**
 * This method has been deprecated, please use method buildStartedAt instead.
 */
@Deprecated public Time getStartedAt(){
            return this.startedAt!=null?this.startedAt.build():null;
    }

    public Time buildStartedAt(){
            return this.startedAt!=null?this.startedAt.build():null;
    }

    public A withStartedAt(Time startedAt){
            _visitables.remove(this.startedAt);
            if (startedAt!=null){ this.startedAt= new TimeBuilder(startedAt); _visitables.add(this.startedAt);} return (A) this;
    }

    public Boolean hasStartedAt(){
            return this.startedAt!=null;
    }

    public ContainerStateTerminatedFluent.StartedAtNested<A> withNewStartedAt(){
            return new StartedAtNestedImpl();
    }

    public ContainerStateTerminatedFluent.StartedAtNested<A> withNewStartedAtLike(Time item){
            return new StartedAtNestedImpl(item);
    }

    public ContainerStateTerminatedFluent.StartedAtNested<A> editStartedAt(){
            return withNewStartedAtLike(getStartedAt());
    }

    public ContainerStateTerminatedFluent.StartedAtNested<A> editOrNewStartedAt(){
            return withNewStartedAtLike(getStartedAt() != null ? getStartedAt(): new TimeBuilder().build());
    }

    public ContainerStateTerminatedFluent.StartedAtNested<A> editOrNewStartedAtLike(Time item){
            return withNewStartedAtLike(getStartedAt() != null ? getStartedAt(): item);
    }

    public A withNewStartedAt(String time){
            return (A)withStartedAt(new Time(time));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ContainerStateTerminatedFluentImpl that = (ContainerStateTerminatedFluentImpl) o;
            if (containerID != null ? !containerID.equals(that.containerID) :that.containerID != null) return false;
            if (exitCode != null ? !exitCode.equals(that.exitCode) :that.exitCode != null) return false;
            if (finishedAt != null ? !finishedAt.equals(that.finishedAt) :that.finishedAt != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (signal != null ? !signal.equals(that.signal) :that.signal != null) return false;
            if (startedAt != null ? !startedAt.equals(that.startedAt) :that.startedAt != null) return false;
            return true;
    }


    public class FinishedAtNestedImpl<N> extends TimeFluentImpl<ContainerStateTerminatedFluent.FinishedAtNested<N>> implements ContainerStateTerminatedFluent.FinishedAtNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            FinishedAtNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            FinishedAtNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) ContainerStateTerminatedFluentImpl.this.withFinishedAt(builder.build());
    }
    public N endFinishedAt(){
            return and();
    }

}
    public class StartedAtNestedImpl<N> extends TimeFluentImpl<ContainerStateTerminatedFluent.StartedAtNested<N>> implements ContainerStateTerminatedFluent.StartedAtNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            StartedAtNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            StartedAtNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) ContainerStateTerminatedFluentImpl.this.withStartedAt(builder.build());
    }
    public N endStartedAt(){
            return and();
    }

}


}
