package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Time;
import java.lang.String;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class TagEventFluentImpl<A extends TagEventFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TagEventFluent<A>{

    private TimeBuilder created;
    private String dockerImageReference;
    private Long generation;
    private String image;

    public TagEventFluentImpl(){
    }
    public TagEventFluentImpl(TagEvent instance){
            this.withCreated(instance.getCreated()); 
            this.withDockerImageReference(instance.getDockerImageReference()); 
            this.withGeneration(instance.getGeneration()); 
            this.withImage(instance.getImage()); 
    }

    
/**
 * This method has been deprecated, please use method buildCreated instead.
 */
@Deprecated public Time getCreated(){
            return this.created!=null?this.created.build():null;
    }

    public Time buildCreated(){
            return this.created!=null?this.created.build():null;
    }

    public A withCreated(Time created){
            _visitables.remove(this.created);
            if (created!=null){ this.created= new TimeBuilder(created); _visitables.add(this.created);} return (A) this;
    }

    public Boolean hasCreated(){
            return this.created!=null;
    }

    public TagEventFluent.CreatedNested<A> withNewCreated(){
            return new CreatedNestedImpl();
    }

    public TagEventFluent.CreatedNested<A> withNewCreatedLike(Time item){
            return new CreatedNestedImpl(item);
    }

    public TagEventFluent.CreatedNested<A> editCreated(){
            return withNewCreatedLike(getCreated());
    }

    public TagEventFluent.CreatedNested<A> editOrNewCreated(){
            return withNewCreatedLike(getCreated() != null ? getCreated(): new TimeBuilder().build());
    }

    public TagEventFluent.CreatedNested<A> editOrNewCreatedLike(Time item){
            return withNewCreatedLike(getCreated() != null ? getCreated(): item);
    }

    public A withNewCreated(String time){
            return (A)withCreated(new Time(time));
    }

    public String getDockerImageReference(){
            return this.dockerImageReference;
    }

    public A withDockerImageReference(String dockerImageReference){
            this.dockerImageReference=dockerImageReference; return (A) this;
    }

    public Boolean hasDockerImageReference(){
            return this.dockerImageReference!=null;
    }

    public Long getGeneration(){
            return this.generation;
    }

    public A withGeneration(Long generation){
            this.generation=generation; return (A) this;
    }

    public Boolean hasGeneration(){
            return this.generation!=null;
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TagEventFluentImpl that = (TagEventFluentImpl) o;
            if (created != null ? !created.equals(that.created) :that.created != null) return false;
            if (dockerImageReference != null ? !dockerImageReference.equals(that.dockerImageReference) :that.dockerImageReference != null) return false;
            if (generation != null ? !generation.equals(that.generation) :that.generation != null) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            return true;
    }


    public class CreatedNestedImpl<N> extends TimeFluentImpl<TagEventFluent.CreatedNested<N>> implements TagEventFluent.CreatedNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            CreatedNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            CreatedNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) TagEventFluentImpl.this.withCreated(builder.build());
    }
    public N endCreated(){
            return and();
    }

}


}
