package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class NamedClusterRoleFluentImpl<A extends NamedClusterRoleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NamedClusterRoleFluent<A>{

    private String name;
    private ClusterRoleBuilder role;

    public NamedClusterRoleFluentImpl(){
    }
    public NamedClusterRoleFluentImpl(NamedClusterRole instance){
            this.withName(instance.getName()); 
            this.withRole(instance.getRole()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name!=null;
    }

    
/**
 * This method has been deprecated, please use method buildRole instead.
 */
@Deprecated public ClusterRole getRole(){
            return this.role!=null?this.role.build():null;
    }

    public ClusterRole buildRole(){
            return this.role!=null?this.role.build():null;
    }

    public A withRole(ClusterRole role){
            _visitables.remove(this.role);
            if (role!=null){ this.role= new ClusterRoleBuilder(role); _visitables.add(this.role);} return (A) this;
    }

    public Boolean hasRole(){
            return this.role!=null;
    }

    public NamedClusterRoleFluent.RoleNested<A> withNewRole(){
            return new RoleNestedImpl();
    }

    public NamedClusterRoleFluent.RoleNested<A> withNewRoleLike(ClusterRole item){
            return new RoleNestedImpl(item);
    }

    public NamedClusterRoleFluent.RoleNested<A> editRole(){
            return withNewRoleLike(getRole());
    }

    public NamedClusterRoleFluent.RoleNested<A> editOrNewRole(){
            return withNewRoleLike(getRole() != null ? getRole(): new ClusterRoleBuilder().build());
    }

    public NamedClusterRoleFluent.RoleNested<A> editOrNewRoleLike(ClusterRole item){
            return withNewRoleLike(getRole() != null ? getRole(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedClusterRoleFluentImpl that = (NamedClusterRoleFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (role != null ? !role.equals(that.role) :that.role != null) return false;
            return true;
    }


    public class RoleNestedImpl<N> extends ClusterRoleFluentImpl<NamedClusterRoleFluent.RoleNested<N>> implements NamedClusterRoleFluent.RoleNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBuilder builder;
    
            RoleNestedImpl(ClusterRole item){
                    this.builder = new ClusterRoleBuilder(this, item);
            }
            RoleNestedImpl(){
                    this.builder = new ClusterRoleBuilder(this);
            }
    
    public N and(){
            return (N) NamedClusterRoleFluentImpl.this.withRole(builder.build());
    }
    public N endRole(){
            return and();
    }

}


}
