package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface HorizontalPodAutoscalerStatusFluent<A extends HorizontalPodAutoscalerStatusFluent<A>> extends Fluent<A>{


    public Integer getCurrentCPUUtilizationPercentage();
    public A withCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage);
    public Boolean hasCurrentCPUUtilizationPercentage();
    public Integer getCurrentReplicas();
    public A withCurrentReplicas(Integer currentReplicas);
    public Boolean hasCurrentReplicas();
    public Integer getDesiredReplicas();
    public A withDesiredReplicas(Integer desiredReplicas);
    public Boolean hasDesiredReplicas();
    
/**
 * This method has been deprecated, please use method buildLastScaleTime instead.
 */
@Deprecated public Time getLastScaleTime();
    public Time buildLastScaleTime();
    public A withLastScaleTime(Time lastScaleTime);
    public Boolean hasLastScaleTime();
    public HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<A> withNewLastScaleTime();
    public HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<A> withNewLastScaleTimeLike(Time item);
    public HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<A> editLastScaleTime();
    public HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<A> editOrNewLastScaleTime();
    public HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<A> editOrNewLastScaleTimeLike(Time item);
    public A withNewLastScaleTime(String time);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();

    public interface LastScaleTimeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeFluent<HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<N>>{

        
    public N and();    public N endLastScaleTime();
}


}
