package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Time;
import java.lang.String;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import io.fabric8.kubernetes.api.model.TimeFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface TagEventConditionFluent<A extends TagEventConditionFluent<A>> extends Fluent<A>{


    public Long getGeneration();
    public A withGeneration(Long generation);
    public Boolean hasGeneration();
    
/**
 * This method has been deprecated, please use method buildLastTransitionTime instead.
 */
@Deprecated public Time getLastTransitionTime();
    public Time buildLastTransitionTime();
    public A withLastTransitionTime(Time lastTransitionTime);
    public Boolean hasLastTransitionTime();
    public TagEventConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTime();
    public TagEventConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTimeLike(Time item);
    public TagEventConditionFluent.LastTransitionTimeNested<A> editLastTransitionTime();
    public TagEventConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTime();
    public TagEventConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTimeLike(Time item);
    public A withNewLastTransitionTime(String time);
    public String getMessage();
    public A withMessage(String message);
    public Boolean hasMessage();
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    public String getStatus();
    public A withStatus(String status);
    public Boolean hasStatus();
    public String getType();
    public A withType(String type);
    public Boolean hasType();

    public interface LastTransitionTimeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeFluent<TagEventConditionFluent.LastTransitionTimeNested<N>>{

        
    public N and();    public N endLastTransitionTime();
}


}
