package io.fabric8.kubernetes.api.model.apiextensions;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Time;
import java.lang.String;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class CustomResourceDefinitionConditionFluentImpl<A extends CustomResourceDefinitionConditionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CustomResourceDefinitionConditionFluent<A>{

    private TimeBuilder lastTransitionTime;
    private String message;
    private String reason;
    private String status;
    private String type;

    public CustomResourceDefinitionConditionFluentImpl(){
    }
    public CustomResourceDefinitionConditionFluentImpl(CustomResourceDefinitionCondition instance){
            this.withLastTransitionTime(instance.getLastTransitionTime()); 
            this.withMessage(instance.getMessage()); 
            this.withReason(instance.getReason()); 
            this.withStatus(instance.getStatus()); 
            this.withType(instance.getType()); 
    }

    
/**
 * This method has been deprecated, please use method buildLastTransitionTime instead.
 */
@Deprecated public Time getLastTransitionTime(){
            return this.lastTransitionTime!=null?this.lastTransitionTime.build():null;
    }

    public Time buildLastTransitionTime(){
            return this.lastTransitionTime!=null?this.lastTransitionTime.build():null;
    }

    public A withLastTransitionTime(Time lastTransitionTime){
            _visitables.remove(this.lastTransitionTime);
            if (lastTransitionTime!=null){ this.lastTransitionTime= new TimeBuilder(lastTransitionTime); _visitables.add(this.lastTransitionTime);} return (A) this;
    }

    public Boolean hasLastTransitionTime(){
            return this.lastTransitionTime!=null;
    }

    public CustomResourceDefinitionConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTime(){
            return new LastTransitionTimeNestedImpl();
    }

    public CustomResourceDefinitionConditionFluent.LastTransitionTimeNested<A> withNewLastTransitionTimeLike(Time item){
            return new LastTransitionTimeNestedImpl(item);
    }

    public CustomResourceDefinitionConditionFluent.LastTransitionTimeNested<A> editLastTransitionTime(){
            return withNewLastTransitionTimeLike(getLastTransitionTime());
    }

    public CustomResourceDefinitionConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTime(){
            return withNewLastTransitionTimeLike(getLastTransitionTime() != null ? getLastTransitionTime(): new TimeBuilder().build());
    }

    public CustomResourceDefinitionConditionFluent.LastTransitionTimeNested<A> editOrNewLastTransitionTimeLike(Time item){
            return withNewLastTransitionTimeLike(getLastTransitionTime() != null ? getLastTransitionTime(): item);
    }

    public A withNewLastTransitionTime(String time){
            return (A)withLastTransitionTime(new Time(time));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message!=null;
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason!=null;
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.status!=null;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            CustomResourceDefinitionConditionFluentImpl that = (CustomResourceDefinitionConditionFluentImpl) o;
            if (lastTransitionTime != null ? !lastTransitionTime.equals(that.lastTransitionTime) :that.lastTransitionTime != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class LastTransitionTimeNestedImpl<N> extends TimeFluentImpl<CustomResourceDefinitionConditionFluent.LastTransitionTimeNested<N>> implements CustomResourceDefinitionConditionFluent.LastTransitionTimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TimeBuilder builder;
    
            LastTransitionTimeNestedImpl(Time item){
                    this.builder = new TimeBuilder(this, item);
            }
            LastTransitionTimeNestedImpl(){
                    this.builder = new TimeBuilder(this);
            }
    
    public N and(){
            return (N) CustomResourceDefinitionConditionFluentImpl.this.withLastTransitionTime(builder.build());
    }
    public N endLastTransitionTime(){
            return and();
    }

}


}
