package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface TaintFluent<A extends TaintFluent<A>> extends Fluent<A>{


    public String getEffect();
    public A withEffect(String effect);
    public Boolean hasEffect();
    public String getKey();
    public A withKey(String key);
    public Boolean hasKey();
    
/**
 * This method has been deprecated, please use method buildTimeAdded instead.
 */
@Deprecated public Time getTimeAdded();
    public Time buildTimeAdded();
    public A withTimeAdded(Time timeAdded);
    public Boolean hasTimeAdded();
    public TaintFluent.TimeAddedNested<A> withNewTimeAdded();
    public TaintFluent.TimeAddedNested<A> withNewTimeAddedLike(Time item);
    public TaintFluent.TimeAddedNested<A> editTimeAdded();
    public TaintFluent.TimeAddedNested<A> editOrNewTimeAdded();
    public TaintFluent.TimeAddedNested<A> editOrNewTimeAddedLike(Time item);
    public A withNewTimeAdded(String time);
    public String getValue();
    public A withValue(String value);
    public Boolean hasValue();

    public interface TimeAddedNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeFluent<TaintFluent.TimeAddedNested<N>>{

        
    public N and();    public N endTimeAdded();
}


}
