
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "cancelled",
    "completionTimestamp",
    "config",
    "duration",
    "message",
    "output",
    "outputDockerImageReference",
    "phase",
    "reason",
    "startTimestamp"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class BuildStatus implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("cancelled")
    private Boolean cancelled;
    /**
     * 
     * 
     */
    @JsonProperty("completionTimestamp")
    private String completionTimestamp;
    /**
     * 
     * 
     */
    @JsonProperty("config")
    @Valid
    private ObjectReference config;
    /**
     * 
     * 
     */
    @JsonProperty("duration")
    private Long duration;
    /**
     * 
     * 
     */
    @JsonProperty("message")
    private String message;
    /**
     * 
     * 
     */
    @JsonProperty("output")
    @Valid
    private BuildStatusOutput output;
    /**
     * 
     * 
     */
    @JsonProperty("outputDockerImageReference")
    private String outputDockerImageReference;
    /**
     * 
     * 
     */
    @JsonProperty("phase")
    private String phase;
    /**
     * 
     * 
     */
    @JsonProperty("reason")
    private String reason;
    /**
     * 
     * 
     */
    @JsonProperty("startTimestamp")
    private String startTimestamp;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public BuildStatus() {
    }

    /**
     * 
     * @param duration
     * @param output
     * @param phase
     * @param reason
     * @param completionTimestamp
     * @param cancelled
     * @param message
     * @param config
     * @param outputDockerImageReference
     * @param startTimestamp
     */
    public BuildStatus(Boolean cancelled, String completionTimestamp, ObjectReference config, Long duration, String message, BuildStatusOutput output, String outputDockerImageReference, String phase, String reason, String startTimestamp) {
        this.cancelled = cancelled;
        this.completionTimestamp = completionTimestamp;
        this.config = config;
        this.duration = duration;
        this.message = message;
        this.output = output;
        this.outputDockerImageReference = outputDockerImageReference;
        this.phase = phase;
        this.reason = reason;
        this.startTimestamp = startTimestamp;
    }

    /**
     * 
     * 
     * @return
     *     The cancelled
     */
    @JsonProperty("cancelled")
    public Boolean getCancelled() {
        return cancelled;
    }

    /**
     * 
     * 
     * @param cancelled
     *     The cancelled
     */
    @JsonProperty("cancelled")
    public void setCancelled(Boolean cancelled) {
        this.cancelled = cancelled;
    }

    /**
     * 
     * 
     * @return
     *     The completionTimestamp
     */
    @JsonProperty("completionTimestamp")
    public String getCompletionTimestamp() {
        return completionTimestamp;
    }

    /**
     * 
     * 
     * @param completionTimestamp
     *     The completionTimestamp
     */
    @JsonProperty("completionTimestamp")
    public void setCompletionTimestamp(String completionTimestamp) {
        this.completionTimestamp = completionTimestamp;
    }

    /**
     * 
     * 
     * @return
     *     The config
     */
    @JsonProperty("config")
    public ObjectReference getConfig() {
        return config;
    }

    /**
     * 
     * 
     * @param config
     *     The config
     */
    @JsonProperty("config")
    public void setConfig(ObjectReference config) {
        this.config = config;
    }

    /**
     * 
     * 
     * @return
     *     The duration
     */
    @JsonProperty("duration")
    public Long getDuration() {
        return duration;
    }

    /**
     * 
     * 
     * @param duration
     *     The duration
     */
    @JsonProperty("duration")
    public void setDuration(Long duration) {
        this.duration = duration;
    }

    /**
     * 
     * 
     * @return
     *     The message
     */
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * 
     * 
     * @param message
     *     The message
     */
    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * 
     * 
     * @return
     *     The output
     */
    @JsonProperty("output")
    public BuildStatusOutput getOutput() {
        return output;
    }

    /**
     * 
     * 
     * @param output
     *     The output
     */
    @JsonProperty("output")
    public void setOutput(BuildStatusOutput output) {
        this.output = output;
    }

    /**
     * 
     * 
     * @return
     *     The outputDockerImageReference
     */
    @JsonProperty("outputDockerImageReference")
    public String getOutputDockerImageReference() {
        return outputDockerImageReference;
    }

    /**
     * 
     * 
     * @param outputDockerImageReference
     *     The outputDockerImageReference
     */
    @JsonProperty("outputDockerImageReference")
    public void setOutputDockerImageReference(String outputDockerImageReference) {
        this.outputDockerImageReference = outputDockerImageReference;
    }

    /**
     * 
     * 
     * @return
     *     The phase
     */
    @JsonProperty("phase")
    public String getPhase() {
        return phase;
    }

    /**
     * 
     * 
     * @param phase
     *     The phase
     */
    @JsonProperty("phase")
    public void setPhase(String phase) {
        this.phase = phase;
    }

    /**
     * 
     * 
     * @return
     *     The reason
     */
    @JsonProperty("reason")
    public String getReason() {
        return reason;
    }

    /**
     * 
     * 
     * @param reason
     *     The reason
     */
    @JsonProperty("reason")
    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * 
     * 
     * @return
     *     The startTimestamp
     */
    @JsonProperty("startTimestamp")
    public String getStartTimestamp() {
        return startTimestamp;
    }

    /**
     * 
     * 
     * @param startTimestamp
     *     The startTimestamp
     */
    @JsonProperty("startTimestamp")
    public void setStartTimestamp(String startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
