package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class DeprecatedDownwardAPIVolumeSourceFluentImpl<A extends DeprecatedDownwardAPIVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DeprecatedDownwardAPIVolumeSourceFluent<A>{

    private Integer defaultMode;
    private List<DeprecatedDownwardAPIVolumeFileBuilder> items =  new ArrayList<DeprecatedDownwardAPIVolumeFileBuilder>();

    public DeprecatedDownwardAPIVolumeSourceFluentImpl(){
    }
    public DeprecatedDownwardAPIVolumeSourceFluentImpl(DeprecatedDownwardAPIVolumeSource instance){
            this.withDefaultMode(instance.getDefaultMode()); 
            this.withItems(instance.getItems()); 
    }

    public Integer getDefaultMode(){
            return this.defaultMode;
    }

    public A withDefaultMode(Integer defaultMode){
            this.defaultMode=defaultMode; return (A) this;
    }

    public Boolean hasDefaultMode(){
            return this.defaultMode!=null;
    }

    public A addToItems(int index,DeprecatedDownwardAPIVolumeFile item){
            DeprecatedDownwardAPIVolumeFileBuilder builder = new DeprecatedDownwardAPIVolumeFileBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,DeprecatedDownwardAPIVolumeFile item){
            DeprecatedDownwardAPIVolumeFileBuilder builder = new DeprecatedDownwardAPIVolumeFileBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(DeprecatedDownwardAPIVolumeFile... items){
            for (DeprecatedDownwardAPIVolumeFile item : items) {DeprecatedDownwardAPIVolumeFileBuilder builder = new DeprecatedDownwardAPIVolumeFileBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<DeprecatedDownwardAPIVolumeFile> items){
            for (DeprecatedDownwardAPIVolumeFile item : items) {DeprecatedDownwardAPIVolumeFileBuilder builder = new DeprecatedDownwardAPIVolumeFileBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(DeprecatedDownwardAPIVolumeFile... items){
            for (DeprecatedDownwardAPIVolumeFile item : items) {DeprecatedDownwardAPIVolumeFileBuilder builder = new DeprecatedDownwardAPIVolumeFileBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromItems(Collection<DeprecatedDownwardAPIVolumeFile> items){
            for (DeprecatedDownwardAPIVolumeFile item : items) {DeprecatedDownwardAPIVolumeFileBuilder builder = new DeprecatedDownwardAPIVolumeFileBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 */
@Deprecated public List<DeprecatedDownwardAPIVolumeFile> getItems(){
            return build(items);
    }

    public List<DeprecatedDownwardAPIVolumeFile> buildItems(){
            return build(items);
    }

    public DeprecatedDownwardAPIVolumeFile buildItem(int index){
            return this.items.get(index).build();
    }

    public DeprecatedDownwardAPIVolumeFile buildFirstItem(){
            return this.items.get(0).build();
    }

    public DeprecatedDownwardAPIVolumeFile buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public DeprecatedDownwardAPIVolumeFile buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<DeprecatedDownwardAPIVolumeFileBuilder> predicate){
            for (DeprecatedDownwardAPIVolumeFileBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<DeprecatedDownwardAPIVolumeFile> items){
            _visitables.removeAll(this.items);
            this.items.clear();
            if (items != null) {for (DeprecatedDownwardAPIVolumeFile item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(DeprecatedDownwardAPIVolumeFile... items){
            this.items.clear(); if (items != null) {for (DeprecatedDownwardAPIVolumeFile item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items!= null && !items.isEmpty();
    }

    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> addNewItemLike(DeprecatedDownwardAPIVolumeFile item){
            return new ItemsNestedImpl(-1, item);
    }

    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index,DeprecatedDownwardAPIVolumeFile item){
            return new ItemsNestedImpl(index, item);
    }

    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<DeprecatedDownwardAPIVolumeFileBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeprecatedDownwardAPIVolumeSourceFluentImpl that = (DeprecatedDownwardAPIVolumeSourceFluentImpl) o;
            if (defaultMode != null ? !defaultMode.equals(that.defaultMode) :that.defaultMode != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends DeprecatedDownwardAPIVolumeFileFluentImpl<DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<N>> implements DeprecatedDownwardAPIVolumeSourceFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeprecatedDownwardAPIVolumeFileBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,DeprecatedDownwardAPIVolumeFile item){
                    this.index = index;
                    this.builder = new DeprecatedDownwardAPIVolumeFileBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new DeprecatedDownwardAPIVolumeFileBuilder(this);
            }
    
    public N and(){
            return (N) DeprecatedDownwardAPIVolumeSourceFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}


}
