
package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "dockerImageRepository",
    "tags"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class ImageStreamStatus {

    /**
     * represents the effective location this stream may be accessed at
     * 
     */
    @JsonProperty("dockerImageRepository")
    private String dockerImageRepository;
    /**
     * historical record of images associated with each tag
     * 
     */
    @JsonProperty("tags")
    @Valid
    private List<NamedTagEventList> tags = new ArrayList<NamedTagEventList>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public ImageStreamStatus() {
    }

    /**
     * 
     * @param tags
     * @param dockerImageRepository
     */
    public ImageStreamStatus(String dockerImageRepository, List<NamedTagEventList> tags) {
        this.dockerImageRepository = dockerImageRepository;
        this.tags = tags;
    }

    /**
     * represents the effective location this stream may be accessed at
     * 
     * @return
     *     The dockerImageRepository
     */
    @JsonProperty("dockerImageRepository")
    public String getDockerImageRepository() {
        return dockerImageRepository;
    }

    /**
     * represents the effective location this stream may be accessed at
     * 
     * @param dockerImageRepository
     *     The dockerImageRepository
     */
    @JsonProperty("dockerImageRepository")
    public void setDockerImageRepository(String dockerImageRepository) {
        this.dockerImageRepository = dockerImageRepository;
    }

    /**
     * historical record of images associated with each tag
     * 
     * @return
     *     The tags
     */
    @JsonProperty("tags")
    public List<NamedTagEventList> getTags() {
        return tags;
    }

    /**
     * historical record of images associated with each tag
     * 
     * @param tags
     *     The tags
     */
    @JsonProperty("tags")
    public void setTags(List<NamedTagEventList> tags) {
        this.tags = tags;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
