package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class DeploymentStrategyBuilder extends DeploymentStrategyFluent<DeploymentStrategyBuilder> implements VisitableBuilder<DeploymentStrategy,DeploymentStrategyBuilder>{

     DeploymentStrategyFluent<?> fluent;
public DeploymentStrategyBuilder(){
    this(new DeploymentStrategy());
}
public DeploymentStrategyBuilder( DeploymentStrategyFluent<?> fluent ){
    this(fluent, new DeploymentStrategy());
}
public DeploymentStrategyBuilder( DeploymentStrategyFluent<?> fluent , DeploymentStrategy instance ){
    this.fluent = fluent; fluent.withCustomParams(instance.getCustomParams()); fluent.withRecreateParams(instance.getRecreateParams()); fluent.withResources(instance.getResources()); fluent.withRollingParams(instance.getRollingParams()); fluent.withType(instance.getType()); 
}
public DeploymentStrategyBuilder( DeploymentStrategy instance ){
    this.fluent = this; this.withCustomParams(instance.getCustomParams()); this.withRecreateParams(instance.getRecreateParams()); this.withResources(instance.getResources()); this.withRollingParams(instance.getRollingParams()); this.withType(instance.getType()); 
}

public EditableDeploymentStrategy build(){
    EditableDeploymentStrategy buildable = new EditableDeploymentStrategy(fluent.getCustomParams(),fluent.getRecreateParams(),fluent.getResources(),fluent.getRollingParams(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DeploymentStrategyBuilder that = (DeploymentStrategyBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    