
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "contextDir",
    "git",
    "sourceSecret",
    "type"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = true, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class BuildSource {

    /**
     * specifies sub-directory where the source code for the application exists
     * 
     */
    @JsonProperty("contextDir")
    private String contextDir;
    /**
     * 
     * 
     */
    @JsonProperty("git")
    @Valid
    private GitBuildSource git;
    /**
     * 
     * 
     */
    @JsonProperty("sourceSecret")
    @Valid
    private LocalObjectReference sourceSecret;
    /**
     * type of source control management system
     * 
     */
    @JsonProperty("type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public BuildSource() {
    }

    /**
     * 
     * @param git
     * @param sourceSecret
     * @param contextDir
     * @param type
     */
    public BuildSource(String contextDir, GitBuildSource git, LocalObjectReference sourceSecret, String type) {
        this.contextDir = contextDir;
        this.git = git;
        this.sourceSecret = sourceSecret;
        this.type = type;
    }

    /**
     * specifies sub-directory where the source code for the application exists
     * 
     * @return
     *     The contextDir
     */
    @JsonProperty("contextDir")
    public String getContextDir() {
        return contextDir;
    }

    /**
     * specifies sub-directory where the source code for the application exists
     * 
     * @param contextDir
     *     The contextDir
     */
    @JsonProperty("contextDir")
    public void setContextDir(String contextDir) {
        this.contextDir = contextDir;
    }

    /**
     * 
     * 
     * @return
     *     The git
     */
    @JsonProperty("git")
    public GitBuildSource getGit() {
        return git;
    }

    /**
     * 
     * 
     * @param git
     *     The git
     */
    @JsonProperty("git")
    public void setGit(GitBuildSource git) {
        this.git = git;
    }

    /**
     * 
     * 
     * @return
     *     The sourceSecret
     */
    @JsonProperty("sourceSecret")
    public LocalObjectReference getSourceSecret() {
        return sourceSecret;
    }

    /**
     * 
     * 
     * @param sourceSecret
     *     The sourceSecret
     */
    @JsonProperty("sourceSecret")
    public void setSourceSecret(LocalObjectReference sourceSecret) {
        this.sourceSecret = sourceSecret;
    }

    /**
     * type of source control management system
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * type of source control management system
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
