package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class PodConditionBuilder extends PodConditionFluent<PodConditionBuilder> implements VisitableBuilder<PodCondition,PodConditionBuilder>{

     PodConditionFluent<?> fluent;
public PodConditionBuilder(){
    this(new PodCondition());
}
public PodConditionBuilder( PodConditionFluent<?> fluent ){
    this(fluent, new PodCondition());
}
public PodConditionBuilder( PodConditionFluent<?> fluent , PodCondition instance ){
    this.fluent = fluent; fluent.withStatus(instance.getStatus()); fluent.withType(instance.getType()); 
}
public PodConditionBuilder( PodCondition instance ){
    this.fluent = this; this.withStatus(instance.getStatus()); this.withType(instance.getType()); 
}

public EditablePodCondition build(){
    EditablePodCondition buildable = new EditablePodCondition(fluent.getStatus(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PodConditionBuilder that = (PodConditionBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    