package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ObjectReferenceBuilder extends ObjectReferenceFluent<ObjectReferenceBuilder> implements VisitableBuilder<ObjectReference,ObjectReferenceBuilder>{

     ObjectReferenceFluent<?> fluent;
public ObjectReferenceBuilder(){
    this(new ObjectReference());
}
public ObjectReferenceBuilder( ObjectReferenceFluent<?> fluent ){
    this(fluent, new ObjectReference());
}
public ObjectReferenceBuilder( ObjectReferenceFluent<?> fluent , ObjectReference instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withFieldPath(instance.getFieldPath()); fluent.withKind(instance.getKind()); fluent.withName(instance.getName()); fluent.withNamespace(instance.getNamespace()); fluent.withResourceVersion(instance.getResourceVersion()); fluent.withUid(instance.getUid()); 
}
public ObjectReferenceBuilder( ObjectReference instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withFieldPath(instance.getFieldPath()); this.withKind(instance.getKind()); this.withName(instance.getName()); this.withNamespace(instance.getNamespace()); this.withResourceVersion(instance.getResourceVersion()); this.withUid(instance.getUid()); 
}

public EditableObjectReference build(){
    EditableObjectReference buildable = new EditableObjectReference(fluent.getApiVersion(),fluent.getFieldPath(),fluent.getKind(),fluent.getName(),fluent.getNamespace(),fluent.getResourceVersion(),fluent.getUid());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ObjectReferenceBuilder that = (ObjectReferenceBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    