package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ContainerStateFluent<T extends ContainerStateFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     VisitableBuilder<ContainerStateRunning, ?> running;     VisitableBuilder<ContainerStateTerminated, ?> terminated;     VisitableBuilder<ContainerStateWaiting, ?> waiting;     Map<String, Object> additionalProperties = new HashMap();

    public ContainerStateRunning getRunning(){
    return this.running!=null?this.running.build():null;
    }
    public T withRunning( ContainerStateRunning running){
    if (running!=null){ this.running= new ContainerStateRunningBuilder(running); _visitables.add(this.running);} return (T) this;
    }
    public RunningNested<T> withNewRunning(){
    return new RunningNested<T>();
    }
    public RunningNested<T> withNewRunningLike( ContainerStateRunning item){
    return new RunningNested<T>(item);
    }
    public RunningNested<T> editRunning(){
    return withNewRunningLike(getRunning());
    }
    public T withNewRunning( String startedAt){
    return withRunning(new ContainerStateRunning(startedAt));
    }
    public ContainerStateTerminated getTerminated(){
    return this.terminated!=null?this.terminated.build():null;
    }
    public T withTerminated( ContainerStateTerminated terminated){
    if (terminated!=null){ this.terminated= new ContainerStateTerminatedBuilder(terminated); _visitables.add(this.terminated);} return (T) this;
    }
    public TerminatedNested<T> withNewTerminated(){
    return new TerminatedNested<T>();
    }
    public TerminatedNested<T> withNewTerminatedLike( ContainerStateTerminated item){
    return new TerminatedNested<T>(item);
    }
    public TerminatedNested<T> editTerminated(){
    return withNewTerminatedLike(getTerminated());
    }
    public ContainerStateWaiting getWaiting(){
    return this.waiting!=null?this.waiting.build():null;
    }
    public T withWaiting( ContainerStateWaiting waiting){
    if (waiting!=null){ this.waiting= new ContainerStateWaitingBuilder(waiting); _visitables.add(this.waiting);} return (T) this;
    }
    public WaitingNested<T> withNewWaiting(){
    return new WaitingNested<T>();
    }
    public WaitingNested<T> withNewWaitingLike( ContainerStateWaiting item){
    return new WaitingNested<T>(item);
    }
    public WaitingNested<T> editWaiting(){
    return withNewWaitingLike(getWaiting());
    }
    public T withNewWaiting( String reason){
    return withWaiting(new ContainerStateWaiting(reason));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerStateFluent that = (ContainerStateFluent) o;
if (running != null ? !running.equals(that.running) :that.running != null) return false;
if (terminated != null ? !terminated.equals(that.terminated) :that.terminated != null) return false;
if (waiting != null ? !waiting.equals(that.waiting) :that.waiting != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class RunningNested<N> extends ContainerStateRunningFluent<RunningNested<N>> implements Nested<N>{

        private final ContainerStateRunningBuilder builder;
    
             RunningNested (){
        this.builder = new ContainerStateRunningBuilder(this);
        }
             RunningNested ( ContainerStateRunning item){
        this.builder = new ContainerStateRunningBuilder(this, item);
        }
    
            public N endRunning(){
            return and();
        }
            public N and(){
            return (N) ContainerStateFluent.this.withRunning(builder.build());
        }
    
}
    public class TerminatedNested<N> extends ContainerStateTerminatedFluent<TerminatedNested<N>> implements Nested<N>{

        private final ContainerStateTerminatedBuilder builder;
    
             TerminatedNested (){
        this.builder = new ContainerStateTerminatedBuilder(this);
        }
             TerminatedNested ( ContainerStateTerminated item){
        this.builder = new ContainerStateTerminatedBuilder(this, item);
        }
    
            public N endTerminated(){
            return and();
        }
            public N and(){
            return (N) ContainerStateFluent.this.withTerminated(builder.build());
        }
    
}
    public class WaitingNested<N> extends ContainerStateWaitingFluent<WaitingNested<N>> implements Nested<N>{

        private final ContainerStateWaitingBuilder builder;
    
             WaitingNested (){
        this.builder = new ContainerStateWaitingBuilder(this);
        }
             WaitingNested ( ContainerStateWaiting item){
        this.builder = new ContainerStateWaitingBuilder(this, item);
        }
    
            public N endWaiting(){
            return and();
        }
            public N and(){
            return (N) ContainerStateFluent.this.withWaiting(builder.build());
        }
    
}


}
