package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PolicyBindingFluent<A extends PolicyBindingFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public String getLastModified();
    public A withLastModified(String lastModified);
    public Boolean hasLastModified();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public PolicyBindingFluent.MetadataNested<A> withNewMetadata();
    public PolicyBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PolicyBindingFluent.MetadataNested<A> editMetadata();
    public PolicyBindingFluent.MetadataNested<A> editOrNewMetadata();
    public PolicyBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildPolicyRef instead.
 */
@Deprecated public ObjectReference getPolicyRef();
    public ObjectReference buildPolicyRef();
    public A withPolicyRef(ObjectReference policyRef);
    public Boolean hasPolicyRef();
    public PolicyBindingFluent.PolicyRefNested<A> withNewPolicyRef();
    public PolicyBindingFluent.PolicyRefNested<A> withNewPolicyRefLike(ObjectReference item);
    public PolicyBindingFluent.PolicyRefNested<A> editPolicyRef();
    public PolicyBindingFluent.PolicyRefNested<A> editOrNewPolicyRef();
    public PolicyBindingFluent.PolicyRefNested<A> editOrNewPolicyRefLike(ObjectReference item);
    public A addToRoleBindings(int index,NamedRoleBinding item);
    public A setToRoleBindings(int index,NamedRoleBinding item);
    public A addToRoleBindings(NamedRoleBinding... items);
    public A addAllToRoleBindings(Collection<NamedRoleBinding> items);
    public A removeFromRoleBindings(NamedRoleBinding... items);
    public A removeAllFromRoleBindings(Collection<NamedRoleBinding> items);
    
/**
 * This method has been deprecated, please use method buildRoleBindings instead.
 */
@Deprecated public List<NamedRoleBinding> getRoleBindings();
    public List<NamedRoleBinding> buildRoleBindings();
    public NamedRoleBinding buildRoleBinding(int index);
    public NamedRoleBinding buildFirstRoleBinding();
    public NamedRoleBinding buildLastRoleBinding();
    public NamedRoleBinding buildMatchingRoleBinding(io.fabric8.kubernetes.api.builder.Predicate<NamedRoleBindingBuilder> predicate);
    public A withRoleBindings(List<NamedRoleBinding> roleBindings);
    public A withRoleBindings(NamedRoleBinding... roleBindings);
    public Boolean hasRoleBindings();
    public PolicyBindingFluent.RoleBindingsNested<A> addNewRoleBinding();
    public PolicyBindingFluent.RoleBindingsNested<A> addNewRoleBindingLike(NamedRoleBinding item);
    public PolicyBindingFluent.RoleBindingsNested<A> setNewRoleBindingLike(int index,NamedRoleBinding item);
    public PolicyBindingFluent.RoleBindingsNested<A> editRoleBinding(int index);
    public PolicyBindingFluent.RoleBindingsNested<A> editFirstRoleBinding();
    public PolicyBindingFluent.RoleBindingsNested<A> editLastRoleBinding();
    public PolicyBindingFluent.RoleBindingsNested<A> editMatchingRoleBinding(io.fabric8.kubernetes.api.builder.Predicate<NamedRoleBindingBuilder> predicate);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PolicyBindingFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface PolicyRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<PolicyBindingFluent.PolicyRefNested<N>>{

        
    public N and();    public N endPolicyRef();
}
    public interface RoleBindingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedRoleBindingFluent<PolicyBindingFluent.RoleBindingsNested<N>>{

        
    public N and();    public N endRoleBinding();
}


}
