package io.fabric8.kubernetes.api.model.apiextensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface CustomResourceDefinitionSpecFluent<A extends CustomResourceDefinitionSpecFluent<A>> extends Fluent<A>{


    public String getGroup();
    public A withGroup(String group);
    public Boolean hasGroup();
    
/**
 * This method has been deprecated, please use method buildNames instead.
 */
@Deprecated public CustomResourceDefinitionNames getNames();
    public CustomResourceDefinitionNames buildNames();
    public A withNames(CustomResourceDefinitionNames names);
    public Boolean hasNames();
    public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNames();
    public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNamesLike(CustomResourceDefinitionNames item);
    public CustomResourceDefinitionSpecFluent.NamesNested<A> editNames();
    public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNames();
    public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNamesLike(CustomResourceDefinitionNames item);
    public String getScope();
    public A withScope(String scope);
    public Boolean hasScope();
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();

    public interface NamesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CustomResourceDefinitionNamesFluent<CustomResourceDefinitionSpecFluent.NamesNested<N>>{

        
    public N and();    public N endNames();
}


}
