package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import javax.validation.Valid;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class PodSpecFluentImpl<A extends PodSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodSpecFluent<A>{

    private Long activeDeadlineSeconds;
    private List<ContainerBuilder> containers =  new ArrayList<ContainerBuilder>();
    private String dnsPolicy;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private String hostname;
    private List<LocalObjectReferenceBuilder> imagePullSecrets =  new ArrayList<LocalObjectReferenceBuilder>();
    private String nodeName;
    private Map<String,String> nodeSelector = new LinkedHashMap<String,String>();
    private String restartPolicy;
    private PodSecurityContextBuilder securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private List<VolumeBuilder> volumes =  new ArrayList<VolumeBuilder>();

    public PodSpecFluentImpl(){
    }
    public PodSpecFluentImpl(PodSpec instance){
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
            this.withContainers(instance.getContainers()); 
            this.withDnsPolicy(instance.getDnsPolicy()); 
            this.withHostIPC(instance.getHostIPC()); 
            this.withHostNetwork(instance.getHostNetwork()); 
            this.withHostPID(instance.getHostPID()); 
            this.withHostname(instance.getHostname()); 
            this.withImagePullSecrets(instance.getImagePullSecrets()); 
            this.withNodeName(instance.getNodeName()); 
            this.withNodeSelector(instance.getNodeSelector()); 
            this.withRestartPolicy(instance.getRestartPolicy()); 
            this.withSecurityContext(instance.getSecurityContext()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withServiceAccountName(instance.getServiceAccountName()); 
            this.withSubdomain(instance.getSubdomain()); 
            this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds()); 
            this.withVolumes(instance.getVolumes()); 
    }

    public Long getActiveDeadlineSeconds(){
            return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds){
            this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
    }

    public Boolean hasActiveDeadlineSeconds(){
            return this.activeDeadlineSeconds!=null;
    }

    public A addToContainers(int index,Container item){
            ContainerBuilder builder = new ContainerBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
    }

    public A setToContainers(int index,Container item){
            ContainerBuilder builder = new ContainerBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
             return (A)this;
    }

    public A addToContainers(Container... items){
            for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.add(builder);this.containers.add(builder);} return (A)this;
    }

    public A addAllToContainers(Collection<Container> items){
            for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.add(builder);this.containers.add(builder);} return (A)this;
    }

    public A removeFromContainers(Container... items){
            for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.remove(builder);this.containers.remove(builder);} return (A)this;
    }

    public A removeAllFromContainers(Collection<Container> items){
            for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.remove(builder);this.containers.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildContainers instead.
 */
@Deprecated public List<Container> getContainers(){
            return build(containers);
    }

    public List<Container> buildContainers(){
            return build(containers);
    }

    public Container buildContainer(int index){
            return this.containers.get(index).build();
    }

    public Container buildFirstContainer(){
            return this.containers.get(0).build();
    }

    public Container buildLastContainer(){
            return this.containers.get(containers.size() - 1).build();
    }

    public Container buildMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate){
            for (ContainerBuilder item: containers) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withContainers(List<Container> containers){
            _visitables.removeAll(this.containers);
            this.containers.clear();
            if (containers != null) {for (Container item : containers){this.addToContainers(item);}} return (A) this;
    }

    public A withContainers(Container... containers){
            this.containers.clear(); if (containers != null) {for (Container item :containers){ this.addToContainers(item);}} return (A) this;
    }

    public Boolean hasContainers(){
            return containers!= null && !containers.isEmpty();
    }

    public PodSpecFluent.ContainersNested<A> addNewContainer(){
            return new ContainersNestedImpl();
    }

    public PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item){
            return new ContainersNestedImpl(-1, item);
    }

    public PodSpecFluent.ContainersNested<A> setNewContainerLike(int index,Container item){
            return new ContainersNestedImpl(index, item);
    }

    public PodSpecFluent.ContainersNested<A> editContainer(int index){
            if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
            return setNewContainerLike(index, buildContainer(index));
    }

    public PodSpecFluent.ContainersNested<A> editFirstContainer(){
            if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
            return setNewContainerLike(0, buildContainer(0));
    }

    public PodSpecFluent.ContainersNested<A> editLastContainer(){
            int index = containers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
            return setNewContainerLike(index, buildContainer(index));
    }

    public PodSpecFluent.ContainersNested<A> editMatchingContainer(io.fabric8.kubernetes.api.builder.Predicate<ContainerBuilder> predicate){
            int index = -1;
            for (int i=0;i<containers.size();i++) { 
            if (predicate.apply(containers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
            return setNewContainerLike(index, buildContainer(index));
    }

    public String getDnsPolicy(){
            return this.dnsPolicy;
    }

    public A withDnsPolicy(String dnsPolicy){
            this.dnsPolicy=dnsPolicy; return (A) this;
    }

    public Boolean hasDnsPolicy(){
            return this.dnsPolicy!=null;
    }

    public Boolean isHostIPC(){
            return this.hostIPC;
    }

    public A withHostIPC(Boolean hostIPC){
            this.hostIPC=hostIPC; return (A) this;
    }

    public Boolean hasHostIPC(){
            return this.hostIPC!=null;
    }

    public Boolean isHostNetwork(){
            return this.hostNetwork;
    }

    public A withHostNetwork(Boolean hostNetwork){
            this.hostNetwork=hostNetwork; return (A) this;
    }

    public Boolean hasHostNetwork(){
            return this.hostNetwork!=null;
    }

    public Boolean isHostPID(){
            return this.hostPID;
    }

    public A withHostPID(Boolean hostPID){
            this.hostPID=hostPID; return (A) this;
    }

    public Boolean hasHostPID(){
            return this.hostPID!=null;
    }

    public String getHostname(){
            return this.hostname;
    }

    public A withHostname(String hostname){
            this.hostname=hostname; return (A) this;
    }

    public Boolean hasHostname(){
            return this.hostname!=null;
    }

    public A addToImagePullSecrets(int index,LocalObjectReference item){
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.imagePullSecrets.add(index >= 0 ? index : imagePullSecrets.size(), builder); return (A)this;
    }

    public A setToImagePullSecrets(int index,LocalObjectReference item){
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= imagePullSecrets.size()) { imagePullSecrets.add(builder); } else { imagePullSecrets.set(index, builder);}
             return (A)this;
    }

    public A addToImagePullSecrets(LocalObjectReference... items){
            for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items){
            for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A removeFromImagePullSecrets(LocalObjectReference... items){
            for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.remove(builder);this.imagePullSecrets.remove(builder);} return (A)this;
    }

    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items){
            for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.remove(builder);this.imagePullSecrets.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildImagePullSecrets instead.
 */
@Deprecated public List<LocalObjectReference> getImagePullSecrets(){
            return build(imagePullSecrets);
    }

    public List<LocalObjectReference> buildImagePullSecrets(){
            return build(imagePullSecrets);
    }

    public LocalObjectReference buildImagePullSecret(int index){
            return this.imagePullSecrets.get(index).build();
    }

    public LocalObjectReference buildFirstImagePullSecret(){
            return this.imagePullSecrets.get(0).build();
    }

    public LocalObjectReference buildLastImagePullSecret(){
            return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
    }

    public LocalObjectReference buildMatchingImagePullSecret(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReferenceBuilder> predicate){
            for (LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets){
            _visitables.removeAll(this.imagePullSecrets);
            this.imagePullSecrets.clear();
            if (imagePullSecrets != null) {for (LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} return (A) this;
    }

    public A withImagePullSecrets(LocalObjectReference... imagePullSecrets){
            this.imagePullSecrets.clear(); if (imagePullSecrets != null) {for (LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
    }

    public Boolean hasImagePullSecrets(){
            return imagePullSecrets!= null && !imagePullSecrets.isEmpty();
    }

    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret(){
            return new ImagePullSecretsNestedImpl();
    }

    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item){
            return new ImagePullSecretsNestedImpl(-1, item);
    }

    public PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,LocalObjectReference item){
            return new ImagePullSecretsNestedImpl(index, item);
    }

    public PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index){
            if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
            return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret(){
            if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
            return setNewImagePullSecretLike(0, buildImagePullSecret(0));
    }

    public PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret(){
            int index = imagePullSecrets.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
            return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(io.fabric8.kubernetes.api.builder.Predicate<LocalObjectReferenceBuilder> predicate){
            int index = -1;
            for (int i=0;i<imagePullSecrets.size();i++) { 
            if (predicate.apply(imagePullSecrets.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
            return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public A addNewImagePullSecret(String name){
            return (A)addToImagePullSecrets(new LocalObjectReference(name));
    }

    public String getNodeName(){
            return this.nodeName;
    }

    public A withNodeName(String nodeName){
            this.nodeName=nodeName; return (A) this;
    }

    public Boolean hasNodeName(){
            return this.nodeName!=null;
    }

    public A addToNodeSelector(String key,String value){
            if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }

    public A addToNodeSelector(Map<String,String> map){
            if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelector(String key){
            if(key != null) {this.nodeSelector.remove(key);} return (A)this;
    }

    public A removeFromNodeSelector(Map<String,String> map){
            if(map != null) { for(Object key : map.keySet()) {this.nodeSelector.remove(key);}} return (A)this;
    }

    public Map<String,String> getNodeSelector(){
            return this.nodeSelector;
    }

    public A withNodeSelector(Map<String,String> nodeSelector){
            this.nodeSelector.clear();
            if (nodeSelector != null) {this.nodeSelector.putAll(nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector(){
            return this.nodeSelector!=null;
    }

    public String getRestartPolicy(){
            return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy){
            this.restartPolicy=restartPolicy; return (A) this;
    }

    public Boolean hasRestartPolicy(){
            return this.restartPolicy!=null;
    }

    
/**
 * This method has been deprecated, please use method buildSecurityContext instead.
 */
@Deprecated public PodSecurityContext getSecurityContext(){
            return this.securityContext!=null?this.securityContext.build():null;
    }

    public PodSecurityContext buildSecurityContext(){
            return this.securityContext!=null?this.securityContext.build():null;
    }

    public A withSecurityContext(PodSecurityContext securityContext){
            _visitables.remove(this.securityContext);
            if (securityContext!=null){ this.securityContext= new PodSecurityContextBuilder(securityContext); _visitables.add(this.securityContext);} return (A) this;
    }

    public Boolean hasSecurityContext(){
            return this.securityContext!=null;
    }

    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContext(){
            return new SecurityContextNestedImpl();
    }

    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(PodSecurityContext item){
            return new SecurityContextNestedImpl(item);
    }

    public PodSpecFluent.SecurityContextNested<A> editSecurityContext(){
            return withNewSecurityContextLike(getSecurityContext());
    }

    public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext(){
            return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): new PodSecurityContextBuilder().build());
    }

    public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(PodSecurityContext item){
            return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): item);
    }

    public String getServiceAccount(){
            return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount){
            this.serviceAccount=serviceAccount; return (A) this;
    }

    public Boolean hasServiceAccount(){
            return this.serviceAccount!=null;
    }

    public String getServiceAccountName(){
            return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName){
            this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName(){
            return this.serviceAccountName!=null;
    }

    public String getSubdomain(){
            return this.subdomain;
    }

    public A withSubdomain(String subdomain){
            this.subdomain=subdomain; return (A) this;
    }

    public Boolean hasSubdomain(){
            return this.subdomain!=null;
    }

    public Long getTerminationGracePeriodSeconds(){
            return this.terminationGracePeriodSeconds;
    }

    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds){
            this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
    }

    public Boolean hasTerminationGracePeriodSeconds(){
            return this.terminationGracePeriodSeconds!=null;
    }

    public A addToVolumes(int index,Volume item){
            VolumeBuilder builder = new VolumeBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToVolumes(int index,Volume item){
            VolumeBuilder builder = new VolumeBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
             return (A)this;
    }

    public A addToVolumes(Volume... items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(Volume... items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.remove(builder);this.volumes.remove(builder);} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items){
            for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.remove(builder);this.volumes.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 */
@Deprecated public List<Volume> getVolumes(){
            return build(volumes);
    }

    public List<Volume> buildVolumes(){
            return build(volumes);
    }

    public Volume buildVolume(int index){
            return this.volumes.get(index).build();
    }

    public Volume buildFirstVolume(){
            return this.volumes.get(0).build();
    }

    public Volume buildLastVolume(){
            return this.volumes.get(volumes.size() - 1).build();
    }

    public Volume buildMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VolumeBuilder> predicate){
            for (VolumeBuilder item: volumes) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withVolumes(List<Volume> volumes){
            _visitables.removeAll(this.volumes);
            this.volumes.clear();
            if (volumes != null) {for (Volume item : volumes){this.addToVolumes(item);}} return (A) this;
    }

    public A withVolumes(Volume... volumes){
            this.volumes.clear(); if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes(){
            return volumes!= null && !volumes.isEmpty();
    }

    public PodSpecFluent.VolumesNested<A> addNewVolume(){
            return new VolumesNestedImpl();
    }

    public PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item){
            return new VolumesNestedImpl(-1, item);
    }

    public PodSpecFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item){
            return new VolumesNestedImpl(index, item);
    }

    public PodSpecFluent.VolumesNested<A> editVolume(int index){
            if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public PodSpecFluent.VolumesNested<A> editFirstVolume(){
            if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
            return setNewVolumeLike(0, buildVolume(0));
    }

    public PodSpecFluent.VolumesNested<A> editLastVolume(){
            int index = volumes.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public PodSpecFluent.VolumesNested<A> editMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<VolumeBuilder> predicate){
            int index = -1;
            for (int i=0;i<volumes.size();i++) { 
            if (predicate.apply(volumes.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PodSpecFluentImpl that = (PodSpecFluentImpl) o;
            if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
            if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
            if (dnsPolicy != null ? !dnsPolicy.equals(that.dnsPolicy) :that.dnsPolicy != null) return false;
            if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
            if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
            if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
            if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
            if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
            if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
            if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
            if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
            if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
            if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
            if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
            if (subdomain != null ? !subdomain.equals(that.subdomain) :that.subdomain != null) return false;
            if (terminationGracePeriodSeconds != null ? !terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) :that.terminationGracePeriodSeconds != null) return false;
            if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
            return true;
    }


    public class ContainersNestedImpl<N> extends ContainerFluentImpl<PodSpecFluent.ContainersNested<N>> implements PodSpecFluent.ContainersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ContainerBuilder builder;
        private final int index;
    
            ContainersNestedImpl(int index,Container item){
                    this.index = index;
                    this.builder = new ContainerBuilder(this, item);
            }
            ContainersNestedImpl(){
                    this.index = -1;
                    this.builder = new ContainerBuilder(this);
            }
    
    public N and(){
            return (N) PodSpecFluentImpl.this.setToContainers(index, builder.build());
    }
    public N endContainer(){
            return and();
    }

}
    public class ImagePullSecretsNestedImpl<N> extends LocalObjectReferenceFluentImpl<PodSpecFluent.ImagePullSecretsNested<N>> implements PodSpecFluent.ImagePullSecretsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LocalObjectReferenceBuilder builder;
        private final int index;
    
            ImagePullSecretsNestedImpl(int index,LocalObjectReference item){
                    this.index = index;
                    this.builder = new LocalObjectReferenceBuilder(this, item);
            }
            ImagePullSecretsNestedImpl(){
                    this.index = -1;
                    this.builder = new LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) PodSpecFluentImpl.this.setToImagePullSecrets(index, builder.build());
    }
    public N endImagePullSecret(){
            return and();
    }

}
    public class SecurityContextNestedImpl<N> extends PodSecurityContextFluentImpl<PodSpecFluent.SecurityContextNested<N>> implements PodSpecFluent.SecurityContextNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodSecurityContextBuilder builder;
    
            SecurityContextNestedImpl(PodSecurityContext item){
                    this.builder = new PodSecurityContextBuilder(this, item);
            }
            SecurityContextNestedImpl(){
                    this.builder = new PodSecurityContextBuilder(this);
            }
    
    public N and(){
            return (N) PodSpecFluentImpl.this.withSecurityContext(builder.build());
    }
    public N endSecurityContext(){
            return and();
    }

}
    public class VolumesNestedImpl<N> extends VolumeFluentImpl<PodSpecFluent.VolumesNested<N>> implements PodSpecFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final VolumeBuilder builder;
        private final int index;
    
            VolumesNestedImpl(int index,Volume item){
                    this.index = index;
                    this.builder = new VolumeBuilder(this, item);
            }
            VolumesNestedImpl(){
                    this.index = -1;
                    this.builder = new VolumeBuilder(this);
            }
    
    public N and(){
            return (N) PodSpecFluentImpl.this.setToVolumes(index, builder.build());
    }
    public N endVolume(){
            return and();
    }

}


}
