package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PolicyFluent<A extends PolicyFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public String getLastModified();
    public A withLastModified(String lastModified);
    public Boolean hasLastModified();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public PolicyFluent.MetadataNested<A> withNewMetadata();
    public PolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PolicyFluent.MetadataNested<A> editMetadata();
    public PolicyFluent.MetadataNested<A> editOrNewMetadata();
    public PolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToRoles(int index,NamedRole item);
    public A setToRoles(int index,NamedRole item);
    public A addToRoles(NamedRole... items);
    public A addAllToRoles(Collection<NamedRole> items);
    public A removeFromRoles(NamedRole... items);
    public A removeAllFromRoles(Collection<NamedRole> items);
    
/**
 * This method has been deprecated, please use method buildRoles instead.
 */
@Deprecated public List<NamedRole> getRoles();
    public List<NamedRole> buildRoles();
    public NamedRole buildRole(int index);
    public NamedRole buildFirstRole();
    public NamedRole buildLastRole();
    public NamedRole buildMatchingRole(io.fabric8.kubernetes.api.builder.Predicate<NamedRoleBuilder> predicate);
    public A withRoles(List<NamedRole> roles);
    public A withRoles(NamedRole... roles);
    public Boolean hasRoles();
    public PolicyFluent.RolesNested<A> addNewRole();
    public PolicyFluent.RolesNested<A> addNewRoleLike(NamedRole item);
    public PolicyFluent.RolesNested<A> setNewRoleLike(int index,NamedRole item);
    public PolicyFluent.RolesNested<A> editRole(int index);
    public PolicyFluent.RolesNested<A> editFirstRole();
    public PolicyFluent.RolesNested<A> editLastRole();
    public PolicyFluent.RolesNested<A> editMatchingRole(io.fabric8.kubernetes.api.builder.Predicate<NamedRoleBuilder> predicate);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PolicyFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RolesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedRoleFluent<PolicyFluent.RolesNested<N>>{

        
    public N and();    public N endRole();
}


}
