package io.fabric8.kubernetes.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ISCSIVolumeSourceFluentImpl<A extends ISCSIVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ISCSIVolumeSourceFluent<A>{

    private String fsType;
    private String iqn;
    private String iscsiInterface;
    private Integer lun;
    private Boolean readOnly;
    private String targetPortal;

    public ISCSIVolumeSourceFluentImpl(){
    }
    public ISCSIVolumeSourceFluentImpl(ISCSIVolumeSource instance){
            this.withFsType(instance.getFsType()); 
            this.withIqn(instance.getIqn()); 
            this.withIscsiInterface(instance.getIscsiInterface()); 
            this.withLun(instance.getLun()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withTargetPortal(instance.getTargetPortal()); 
    }

    public String getFsType(){
            return this.fsType;
    }

    public A withFsType(String fsType){
            this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType(){
            return this.fsType!=null;
    }

    public String getIqn(){
            return this.iqn;
    }

    public A withIqn(String iqn){
            this.iqn=iqn; return (A) this;
    }

    public Boolean hasIqn(){
            return this.iqn!=null;
    }

    public String getIscsiInterface(){
            return this.iscsiInterface;
    }

    public A withIscsiInterface(String iscsiInterface){
            this.iscsiInterface=iscsiInterface; return (A) this;
    }

    public Boolean hasIscsiInterface(){
            return this.iscsiInterface!=null;
    }

    public Integer getLun(){
            return this.lun;
    }

    public A withLun(Integer lun){
            this.lun=lun; return (A) this;
    }

    public Boolean hasLun(){
            return this.lun!=null;
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly!=null;
    }

    public String getTargetPortal(){
            return this.targetPortal;
    }

    public A withTargetPortal(String targetPortal){
            this.targetPortal=targetPortal; return (A) this;
    }

    public Boolean hasTargetPortal(){
            return this.targetPortal!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ISCSIVolumeSourceFluentImpl that = (ISCSIVolumeSourceFluentImpl) o;
            if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
            if (iqn != null ? !iqn.equals(that.iqn) :that.iqn != null) return false;
            if (iscsiInterface != null ? !iscsiInterface.equals(that.iscsiInterface) :that.iscsiInterface != null) return false;
            if (lun != null ? !lun.equals(that.lun) :that.lun != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (targetPortal != null ? !targetPortal.equals(that.targetPortal) :that.targetPortal != null) return false;
            return true;
    }




}
