package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteBuilder extends RouteFluentImpl<RouteBuilder> implements VisitableBuilder<Route,RouteBuilder>{

    RouteFluent<?> fluent;
    Boolean validationEnabled;

    public RouteBuilder(){
            this(true);
    }
    public RouteBuilder(Boolean validationEnabled){
            this(new Route(), validationEnabled);
    }
    public RouteBuilder(RouteFluent<?> fluent){
            this(fluent, true);
    }
    public RouteBuilder(RouteFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Route(), validationEnabled);
    }
    public RouteBuilder(RouteFluent<?> fluent,Route instance){
            this(fluent, instance, true);
    }
    public RouteBuilder(RouteFluent<?> fluent,Route instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public RouteBuilder(Route instance){
            this(instance,true);
    }
    public RouteBuilder(Route instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public Route build(){
            Route buildable = new Route(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteBuilder that = (RouteBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
