package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class HorizontalPodAutoscalerSpecFluentImpl<A extends HorizontalPodAutoscalerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HorizontalPodAutoscalerSpecFluent<A>{

    private Integer maxReplicas;
    private Integer minReplicas;
    private CrossVersionObjectReferenceBuilder scaleTargetRef;
    private Integer targetCPUUtilizationPercentage;

    public HorizontalPodAutoscalerSpecFluentImpl(){
    }
    public HorizontalPodAutoscalerSpecFluentImpl(HorizontalPodAutoscalerSpec instance){
            this.withMaxReplicas(instance.getMaxReplicas()); 
            this.withMinReplicas(instance.getMinReplicas()); 
            this.withScaleTargetRef(instance.getScaleTargetRef()); 
            this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage()); 
    }

    public Integer getMaxReplicas(){
            return this.maxReplicas;
    }

    public A withMaxReplicas(Integer maxReplicas){
            this.maxReplicas=maxReplicas; return (A) this;
    }

    public Boolean hasMaxReplicas(){
            return this.maxReplicas!=null;
    }

    public Integer getMinReplicas(){
            return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas){
            this.minReplicas=minReplicas; return (A) this;
    }

    public Boolean hasMinReplicas(){
            return this.minReplicas!=null;
    }

    
/**
 * This method has been deprecated, please use method buildScaleTargetRef instead.
 */
@Deprecated public CrossVersionObjectReference getScaleTargetRef(){
            return this.scaleTargetRef!=null?this.scaleTargetRef.build():null;
    }

    public CrossVersionObjectReference buildScaleTargetRef(){
            return this.scaleTargetRef!=null?this.scaleTargetRef.build():null;
    }

    public A withScaleTargetRef(CrossVersionObjectReference scaleTargetRef){
            _visitables.remove(this.scaleTargetRef);
            if (scaleTargetRef!=null){ this.scaleTargetRef= new CrossVersionObjectReferenceBuilder(scaleTargetRef); _visitables.add(this.scaleTargetRef);} return (A) this;
    }

    public Boolean hasScaleTargetRef(){
            return this.scaleTargetRef!=null;
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef(){
            return new ScaleTargetRefNestedImpl();
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(CrossVersionObjectReference item){
            return new ScaleTargetRefNestedImpl(item);
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef(){
            return withNewScaleTargetRefLike(getScaleTargetRef());
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef(){
            return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): new CrossVersionObjectReferenceBuilder().build());
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(CrossVersionObjectReference item){
            return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): item);
    }

    public A withNewScaleTargetRef(String apiVersion,String kind,String name){
            return (A)withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public Integer getTargetCPUUtilizationPercentage(){
            return this.targetCPUUtilizationPercentage;
    }

    public A withTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage){
            this.targetCPUUtilizationPercentage=targetCPUUtilizationPercentage; return (A) this;
    }

    public Boolean hasTargetCPUUtilizationPercentage(){
            return this.targetCPUUtilizationPercentage!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl) o;
            if (maxReplicas != null ? !maxReplicas.equals(that.maxReplicas) :that.maxReplicas != null) return false;
            if (minReplicas != null ? !minReplicas.equals(that.minReplicas) :that.minReplicas != null) return false;
            if (scaleTargetRef != null ? !scaleTargetRef.equals(that.scaleTargetRef) :that.scaleTargetRef != null) return false;
            if (targetCPUUtilizationPercentage != null ? !targetCPUUtilizationPercentage.equals(that.targetCPUUtilizationPercentage) :that.targetCPUUtilizationPercentage != null) return false;
            return true;
    }


    public class ScaleTargetRefNestedImpl<N> extends CrossVersionObjectReferenceFluentImpl<HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>> implements HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CrossVersionObjectReferenceBuilder builder;
    
            ScaleTargetRefNestedImpl(CrossVersionObjectReference item){
                    this.builder = new CrossVersionObjectReferenceBuilder(this, item);
            }
            ScaleTargetRefNestedImpl(){
                    this.builder = new CrossVersionObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(builder.build());
    }
    public N endScaleTargetRef(){
            return and();
    }

}


}
