package io.fabric8.kubernetes.api.model;

import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.openshift.api.model.OAuthAccessTokenBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionFluentImpl;
import io.fabric8.openshift.api.model.OAuthAccessTokenFluentImpl;
import io.fabric8.openshift.api.model.UserBuilder;
import io.fabric8.openshift.api.model.ClusterRole;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.PolicyBindingBuilder;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientBuilder;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.BuildRequestFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetBuilder;
import io.fabric8.openshift.api.model.IdentityFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.openshift.api.model.BuildConfigFluentImpl;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder;
import io.fabric8.openshift.api.model.ImageSignatureBuilder;
import io.fabric8.openshift.api.model.ImageSignatureFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.IngressFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ScaleFluentImpl;
import io.fabric8.openshift.api.model.GroupBuilder;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.List;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteFluentImpl;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.ProjectRequestFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyBindingFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceFluentImpl;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.ImageFluentImpl;
import io.fabric8.openshift.api.model.ProjectBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.openshift.api.model.ProjectFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetFluentImpl;
import javax.validation.constraints.NotNull;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.openshift.api.model.ImageStreamTagBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBindingFluentImpl;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.RoleBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBuilder;
import io.fabric8.openshift.api.model.UserFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyFluentImpl;
import io.fabric8.openshift.api.model.ProjectRequestBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.openshift.api.model.ClusterRoleFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.BuildRequestBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.Identity;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.ClusterRoleBuilder;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetFluentImpl;
import io.fabric8.openshift.api.model.RoleBindingRestrictionBuilder;
import io.fabric8.openshift.api.model.BuildBuilder;
import javax.validation.Valid;
import io.fabric8.openshift.api.model.ProjectRequest;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.extensions.DeploymentBuilder;
import io.fabric8.openshift.api.model.ImageStreamTagFluentImpl;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.openshift.api.model.PolicyBindingFluentImpl;
import io.fabric8.openshift.api.model.TemplateFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigFluentImpl;
import io.fabric8.openshift.api.model.RoleBindingRestrictionFluentImpl;
import io.fabric8.openshift.api.model.RoleBindingRestriction;
import io.fabric8.openshift.api.model.ClusterPolicyBuilder;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.openshift.api.model.RoleFluentImpl;
import io.fabric8.openshift.api.model.ImageSignature;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinitionBuilder;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluentImpl;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.GroupFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.TemplateBuilder;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.kubernetes.api.model.extensions.DeploymentFluentImpl;
import io.fabric8.openshift.api.model.BuildConfigBuilder;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceBuilder;
import io.fabric8.openshift.api.model.PolicyBuilder;
import io.fabric8.kubernetes.api.model.extensions.ScaleBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyBindingBuilder;
import io.fabric8.openshift.api.model.RoleBindingBuilder;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.openshift.api.model.BuildFluentImpl;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.OAuthClientFluentImpl;
import io.fabric8.openshift.api.model.IdentityBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.extensions.StatefulSet;
import io.fabric8.openshift.api.model.ImageStreamFluentImpl;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetBuilder;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetFluentImpl;
import io.fabric8.kubernetes.api.model.apiextensions.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.extensions.Scale;
import io.fabric8.openshift.api.model.RoleBindingFluentImpl;
import io.fabric8.openshift.api.model.PolicyFluentImpl;

public class BaseKubernetesListFluentImpl<A extends BaseKubernetesListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BaseKubernetesListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends HasMetadata,?>> items =  new ArrayList<VisitableBuilder<? extends HasMetadata,?>>();
    private String kind;
    private ListMetaBuilder metadata;

    public BaseKubernetesListFluentImpl(){
    }
    public BaseKubernetesListFluentImpl(BaseKubernetesList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion!=null;
    }

    public A addToItems(int index,HasMetadata item){
            if (item instanceof LimitRange){addToLimitRangeItems(index, (LimitRange)item);}
 else if (item instanceof Job){addToJobItems(index, (Job)item);}
 else if (item instanceof ThirdPartyResource){addToThirdPartyResourceItems(index, (ThirdPartyResource)item);}
 else if (item instanceof Project){addToProjectItems(index, (Project)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsItems(index, (SecurityContextConstraints)item);}
 else if (item instanceof BuildConfig){addToBuildConfigItems(index, (BuildConfig)item);}
 else if (item instanceof Route){addToRouteItems(index, (Route)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenItems(index, (OAuthAuthorizeToken)item);}
 else if (item instanceof Namespace){addToNamespaceItems(index, (Namespace)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingItems(index, (ClusterRoleBinding)item);}
 else if (item instanceof Service){addToServiceItems(index, (Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems(index, (ReplicationController)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestItems(index, (ProjectRequest)item);}
 else if (item instanceof Template){addToTemplateItems(index, (Template)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationItems(index, (OAuthClientAuthorization)item);}
 else if (item instanceof PolicyBinding){addToPolicyBindingItems(index, (PolicyBinding)item);}
 else if (item instanceof ClusterRole){addToClusterRoleItems(index, (ClusterRole)item);}
 else if (item instanceof HorizontalPodAutoscaler){addToHorizontalPodAutoscalerItems(index, (HorizontalPodAutoscaler)item);}
 else if (item instanceof Scale){addToScaleItems(index, (Scale)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems(index, (PodTemplate)item);}
 else if (item instanceof Event){addToEventItems(index, (Event)item);}
 else if (item instanceof Ingress){addToIngressItems(index, (Ingress)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenItems(index, (OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigItems(index, (DeploymentConfig)item);}
 else if (item instanceof RoleBinding){addToRoleBindingItems(index, (RoleBinding)item);}
 else if (item instanceof Image){addToImageItems(index, (Image)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems(index, (PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems(index, (PersistentVolumeClaim)item);}
 else if (item instanceof ReplicaSet){addToReplicaSetItems(index, (ReplicaSet)item);}
 else if (item instanceof CronJob){addToCronJobItems(index, (CronJob)item);}
 else if (item instanceof Role){addToRoleItems(index, (Role)item);}
 else if (item instanceof Endpoints){addToEndpointsItems(index, (Endpoints)item);}
 else if (item instanceof Pod){addToPodItems(index, (Pod)item);}
 else if (item instanceof CustomResourceDefinition){addToCustomResourceDefinitionItems(index, (CustomResourceDefinition)item);}
 else if (item instanceof ClusterPolicy){addToClusterPolicyItems(index, (ClusterPolicy)item);}
 else if (item instanceof DaemonSet){addToDaemonSetItems(index, (DaemonSet)item);}
 else if (item instanceof Deployment){addToDeploymentItems(index, (Deployment)item);}
 else if (item instanceof User){addToUserItems(index, (User)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems(index, (ComponentStatus)item);}
 else if (item instanceof Build){addToBuildItems(index, (Build)item);}
 else if (item instanceof RoleBindingRestriction){addToRoleBindingRestrictionItems(index, (RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){addToImageStreamTagItems(index, (ImageStreamTag)item);}
 else if (item instanceof Group){addToGroupItems(index, (Group)item);}
 else if (item instanceof Policy){addToPolicyItems(index, (Policy)item);}
 else if (item instanceof ImageSignature){addToImageSignatureItems(index, (ImageSignature)item);}
 else if (item instanceof Binding){addToBindingItems(index, (Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems(index, (ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems(index, (Secret)item);}
 else if (item instanceof BuildRequest){addToBuildRequestItems(index, (BuildRequest)item);}
 else if (item instanceof ClusterPolicyBinding){addToClusterPolicyBindingItems(index, (ClusterPolicyBinding)item);}
 else if (item instanceof Node){addToNodeItems(index, (Node)item);}
 else if (item instanceof ImageStream){addToImageStreamItems(index, (ImageStream)item);}
 else if (item instanceof StatefulSet){addToStatefulSetItems(index, (StatefulSet)item);}
 else if (item instanceof OAuthClient){addToOAuthClientItems(index, (OAuthClient)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems(index, (ServiceAccount)item);}
 else if (item instanceof Identity){addToIdentityItems(index, (Identity)item);}

            return (A)this;
    }

    public A setToItems(int index,HasMetadata item){
            if (item instanceof LimitRange){setToLimitRangeItems(index, (LimitRange)item);}
 else if (item instanceof Job){setToJobItems(index, (Job)item);}
 else if (item instanceof ThirdPartyResource){setToThirdPartyResourceItems(index, (ThirdPartyResource)item);}
 else if (item instanceof Project){setToProjectItems(index, (Project)item);}
 else if (item instanceof SecurityContextConstraints){setToSecurityContextConstraintsItems(index, (SecurityContextConstraints)item);}
 else if (item instanceof BuildConfig){setToBuildConfigItems(index, (BuildConfig)item);}
 else if (item instanceof Route){setToRouteItems(index, (Route)item);}
 else if (item instanceof OAuthAuthorizeToken){setToOAuthAuthorizeTokenItems(index, (OAuthAuthorizeToken)item);}
 else if (item instanceof Namespace){setToNamespaceItems(index, (Namespace)item);}
 else if (item instanceof ClusterRoleBinding){setToClusterRoleBindingItems(index, (ClusterRoleBinding)item);}
 else if (item instanceof Service){setToServiceItems(index, (Service)item);}
 else if (item instanceof ReplicationController){setToReplicationControllerItems(index, (ReplicationController)item);}
 else if (item instanceof ProjectRequest){setToProjectRequestItems(index, (ProjectRequest)item);}
 else if (item instanceof Template){setToTemplateItems(index, (Template)item);}
 else if (item instanceof OAuthClientAuthorization){setToOAuthClientAuthorizationItems(index, (OAuthClientAuthorization)item);}
 else if (item instanceof PolicyBinding){setToPolicyBindingItems(index, (PolicyBinding)item);}
 else if (item instanceof ClusterRole){setToClusterRoleItems(index, (ClusterRole)item);}
 else if (item instanceof HorizontalPodAutoscaler){setToHorizontalPodAutoscalerItems(index, (HorizontalPodAutoscaler)item);}
 else if (item instanceof Scale){setToScaleItems(index, (Scale)item);}
 else if (item instanceof PodTemplate){setToPodTemplateItems(index, (PodTemplate)item);}
 else if (item instanceof Event){setToEventItems(index, (Event)item);}
 else if (item instanceof Ingress){setToIngressItems(index, (Ingress)item);}
 else if (item instanceof OAuthAccessToken){setToOAuthAccessTokenItems(index, (OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){setToDeploymentConfigItems(index, (DeploymentConfig)item);}
 else if (item instanceof RoleBinding){setToRoleBindingItems(index, (RoleBinding)item);}
 else if (item instanceof Image){setToImageItems(index, (Image)item);}
 else if (item instanceof PersistentVolume){setToPersistentVolumeItems(index, (PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){setToPersistentVolumeClaimItems(index, (PersistentVolumeClaim)item);}
 else if (item instanceof ReplicaSet){setToReplicaSetItems(index, (ReplicaSet)item);}
 else if (item instanceof CronJob){setToCronJobItems(index, (CronJob)item);}
 else if (item instanceof Role){setToRoleItems(index, (Role)item);}
 else if (item instanceof Endpoints){setToEndpointsItems(index, (Endpoints)item);}
 else if (item instanceof Pod){setToPodItems(index, (Pod)item);}
 else if (item instanceof CustomResourceDefinition){setToCustomResourceDefinitionItems(index, (CustomResourceDefinition)item);}
 else if (item instanceof ClusterPolicy){setToClusterPolicyItems(index, (ClusterPolicy)item);}
 else if (item instanceof DaemonSet){setToDaemonSetItems(index, (DaemonSet)item);}
 else if (item instanceof Deployment){setToDeploymentItems(index, (Deployment)item);}
 else if (item instanceof User){setToUserItems(index, (User)item);}
 else if (item instanceof ComponentStatus){setToComponentStatusItems(index, (ComponentStatus)item);}
 else if (item instanceof Build){setToBuildItems(index, (Build)item);}
 else if (item instanceof RoleBindingRestriction){setToRoleBindingRestrictionItems(index, (RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){setToImageStreamTagItems(index, (ImageStreamTag)item);}
 else if (item instanceof Group){setToGroupItems(index, (Group)item);}
 else if (item instanceof Policy){setToPolicyItems(index, (Policy)item);}
 else if (item instanceof ImageSignature){setToImageSignatureItems(index, (ImageSignature)item);}
 else if (item instanceof Binding){setToBindingItems(index, (Binding)item);}
 else if (item instanceof ResourceQuota){setToResourceQuotaItems(index, (ResourceQuota)item);}
 else if (item instanceof Secret){setToSecretItems(index, (Secret)item);}
 else if (item instanceof BuildRequest){setToBuildRequestItems(index, (BuildRequest)item);}
 else if (item instanceof ClusterPolicyBinding){setToClusterPolicyBindingItems(index, (ClusterPolicyBinding)item);}
 else if (item instanceof Node){setToNodeItems(index, (Node)item);}
 else if (item instanceof ImageStream){setToImageStreamItems(index, (ImageStream)item);}
 else if (item instanceof StatefulSet){setToStatefulSetItems(index, (StatefulSet)item);}
 else if (item instanceof OAuthClient){setToOAuthClientItems(index, (OAuthClient)item);}
 else if (item instanceof ServiceAccount){setToServiceAccountItems(index, (ServiceAccount)item);}
 else if (item instanceof Identity){setToIdentityItems(index, (Identity)item);}

            return (A)this;
    }

    public A addToItems(HasMetadata... items){
            for (HasMetadata item : items) { 
            if (item instanceof LimitRange){addToLimitRangeItems((LimitRange)item);}
 else if (item instanceof Job){addToJobItems((Job)item);}
 else if (item instanceof ThirdPartyResource){addToThirdPartyResourceItems((ThirdPartyResource)item);}
 else if (item instanceof Project){addToProjectItems((Project)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsItems((SecurityContextConstraints)item);}
 else if (item instanceof BuildConfig){addToBuildConfigItems((BuildConfig)item);}
 else if (item instanceof Route){addToRouteItems((Route)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingItems((ClusterRoleBinding)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestItems((ProjectRequest)item);}
 else if (item instanceof Template){addToTemplateItems((Template)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationItems((OAuthClientAuthorization)item);}
 else if (item instanceof PolicyBinding){addToPolicyBindingItems((PolicyBinding)item);}
 else if (item instanceof ClusterRole){addToClusterRoleItems((ClusterRole)item);}
 else if (item instanceof HorizontalPodAutoscaler){addToHorizontalPodAutoscalerItems((HorizontalPodAutoscaler)item);}
 else if (item instanceof Scale){addToScaleItems((Scale)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
 else if (item instanceof Ingress){addToIngressItems((Ingress)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenItems((OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigItems((DeploymentConfig)item);}
 else if (item instanceof RoleBinding){addToRoleBindingItems((RoleBinding)item);}
 else if (item instanceof Image){addToImageItems((Image)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof ReplicaSet){addToReplicaSetItems((ReplicaSet)item);}
 else if (item instanceof CronJob){addToCronJobItems((CronJob)item);}
 else if (item instanceof Role){addToRoleItems((Role)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof CustomResourceDefinition){addToCustomResourceDefinitionItems((CustomResourceDefinition)item);}
 else if (item instanceof ClusterPolicy){addToClusterPolicyItems((ClusterPolicy)item);}
 else if (item instanceof DaemonSet){addToDaemonSetItems((DaemonSet)item);}
 else if (item instanceof Deployment){addToDeploymentItems((Deployment)item);}
 else if (item instanceof User){addToUserItems((User)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Build){addToBuildItems((Build)item);}
 else if (item instanceof RoleBindingRestriction){addToRoleBindingRestrictionItems((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){addToImageStreamTagItems((ImageStreamTag)item);}
 else if (item instanceof Group){addToGroupItems((Group)item);}
 else if (item instanceof Policy){addToPolicyItems((Policy)item);}
 else if (item instanceof ImageSignature){addToImageSignatureItems((ImageSignature)item);}
 else if (item instanceof Binding){addToBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof BuildRequest){addToBuildRequestItems((BuildRequest)item);}
 else if (item instanceof ClusterPolicyBinding){addToClusterPolicyBindingItems((ClusterPolicyBinding)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof ImageStream){addToImageStreamItems((ImageStream)item);}
 else if (item instanceof StatefulSet){addToStatefulSetItems((StatefulSet)item);}
 else if (item instanceof OAuthClient){addToOAuthClientItems((OAuthClient)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}
 else if (item instanceof Identity){addToIdentityItems((Identity)item);}

            } return (A)this;
    }

    public A addAllToItems(Collection<HasMetadata> items){
            for (HasMetadata item : items) { 
            if (item instanceof LimitRange){addToLimitRangeItems((LimitRange)item);}
 else if (item instanceof Job){addToJobItems((Job)item);}
 else if (item instanceof ThirdPartyResource){addToThirdPartyResourceItems((ThirdPartyResource)item);}
 else if (item instanceof Project){addToProjectItems((Project)item);}
 else if (item instanceof SecurityContextConstraints){addToSecurityContextConstraintsItems((SecurityContextConstraints)item);}
 else if (item instanceof BuildConfig){addToBuildConfigItems((BuildConfig)item);}
 else if (item instanceof Route){addToRouteItems((Route)item);}
 else if (item instanceof OAuthAuthorizeToken){addToOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);}
 else if (item instanceof Namespace){addToNamespaceItems((Namespace)item);}
 else if (item instanceof ClusterRoleBinding){addToClusterRoleBindingItems((ClusterRoleBinding)item);}
 else if (item instanceof Service){addToServiceItems((Service)item);}
 else if (item instanceof ReplicationController){addToReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof ProjectRequest){addToProjectRequestItems((ProjectRequest)item);}
 else if (item instanceof Template){addToTemplateItems((Template)item);}
 else if (item instanceof OAuthClientAuthorization){addToOAuthClientAuthorizationItems((OAuthClientAuthorization)item);}
 else if (item instanceof PolicyBinding){addToPolicyBindingItems((PolicyBinding)item);}
 else if (item instanceof ClusterRole){addToClusterRoleItems((ClusterRole)item);}
 else if (item instanceof HorizontalPodAutoscaler){addToHorizontalPodAutoscalerItems((HorizontalPodAutoscaler)item);}
 else if (item instanceof Scale){addToScaleItems((Scale)item);}
 else if (item instanceof PodTemplate){addToPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){addToEventItems((Event)item);}
 else if (item instanceof Ingress){addToIngressItems((Ingress)item);}
 else if (item instanceof OAuthAccessToken){addToOAuthAccessTokenItems((OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){addToDeploymentConfigItems((DeploymentConfig)item);}
 else if (item instanceof RoleBinding){addToRoleBindingItems((RoleBinding)item);}
 else if (item instanceof Image){addToImageItems((Image)item);}
 else if (item instanceof PersistentVolume){addToPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){addToPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof ReplicaSet){addToReplicaSetItems((ReplicaSet)item);}
 else if (item instanceof CronJob){addToCronJobItems((CronJob)item);}
 else if (item instanceof Role){addToRoleItems((Role)item);}
 else if (item instanceof Endpoints){addToEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){addToPodItems((Pod)item);}
 else if (item instanceof CustomResourceDefinition){addToCustomResourceDefinitionItems((CustomResourceDefinition)item);}
 else if (item instanceof ClusterPolicy){addToClusterPolicyItems((ClusterPolicy)item);}
 else if (item instanceof DaemonSet){addToDaemonSetItems((DaemonSet)item);}
 else if (item instanceof Deployment){addToDeploymentItems((Deployment)item);}
 else if (item instanceof User){addToUserItems((User)item);}
 else if (item instanceof ComponentStatus){addToComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Build){addToBuildItems((Build)item);}
 else if (item instanceof RoleBindingRestriction){addToRoleBindingRestrictionItems((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){addToImageStreamTagItems((ImageStreamTag)item);}
 else if (item instanceof Group){addToGroupItems((Group)item);}
 else if (item instanceof Policy){addToPolicyItems((Policy)item);}
 else if (item instanceof ImageSignature){addToImageSignatureItems((ImageSignature)item);}
 else if (item instanceof Binding){addToBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){addToResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){addToSecretItems((Secret)item);}
 else if (item instanceof BuildRequest){addToBuildRequestItems((BuildRequest)item);}
 else if (item instanceof ClusterPolicyBinding){addToClusterPolicyBindingItems((ClusterPolicyBinding)item);}
 else if (item instanceof Node){addToNodeItems((Node)item);}
 else if (item instanceof ImageStream){addToImageStreamItems((ImageStream)item);}
 else if (item instanceof StatefulSet){addToStatefulSetItems((StatefulSet)item);}
 else if (item instanceof OAuthClient){addToOAuthClientItems((OAuthClient)item);}
 else if (item instanceof ServiceAccount){addToServiceAccountItems((ServiceAccount)item);}
 else if (item instanceof Identity){addToIdentityItems((Identity)item);}

            } return (A)this;
    }

    public A removeFromItems(HasMetadata... items){
            for (HasMetadata item : items) {if (item instanceof LimitRange){removeFromLimitRangeItems((LimitRange)item);}
 else if (item instanceof Job){removeFromJobItems((Job)item);}
 else if (item instanceof ThirdPartyResource){removeFromThirdPartyResourceItems((ThirdPartyResource)item);}
 else if (item instanceof Project){removeFromProjectItems((Project)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsItems((SecurityContextConstraints)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigItems((BuildConfig)item);}
 else if (item instanceof Route){removeFromRouteItems((Route)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);}
 else if (item instanceof Namespace){removeFromNamespaceItems((Namespace)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingItems((ClusterRoleBinding)item);}
 else if (item instanceof Service){removeFromServiceItems((Service)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof ProjectRequest){removeFromProjectRequestItems((ProjectRequest)item);}
 else if (item instanceof Template){removeFromTemplateItems((Template)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationItems((OAuthClientAuthorization)item);}
 else if (item instanceof PolicyBinding){removeFromPolicyBindingItems((PolicyBinding)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleItems((ClusterRole)item);}
 else if (item instanceof HorizontalPodAutoscaler){removeFromHorizontalPodAutoscalerItems((HorizontalPodAutoscaler)item);}
 else if (item instanceof Scale){removeFromScaleItems((Scale)item);}
 else if (item instanceof PodTemplate){removeFromPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){removeFromEventItems((Event)item);}
 else if (item instanceof Ingress){removeFromIngressItems((Ingress)item);}
 else if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenItems((OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigItems((DeploymentConfig)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingItems((RoleBinding)item);}
 else if (item instanceof Image){removeFromImageItems((Image)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof ReplicaSet){removeFromReplicaSetItems((ReplicaSet)item);}
 else if (item instanceof CronJob){removeFromCronJobItems((CronJob)item);}
 else if (item instanceof Role){removeFromRoleItems((Role)item);}
 else if (item instanceof Endpoints){removeFromEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){removeFromPodItems((Pod)item);}
 else if (item instanceof CustomResourceDefinition){removeFromCustomResourceDefinitionItems((CustomResourceDefinition)item);}
 else if (item instanceof ClusterPolicy){removeFromClusterPolicyItems((ClusterPolicy)item);}
 else if (item instanceof DaemonSet){removeFromDaemonSetItems((DaemonSet)item);}
 else if (item instanceof Deployment){removeFromDeploymentItems((Deployment)item);}
 else if (item instanceof User){removeFromUserItems((User)item);}
 else if (item instanceof ComponentStatus){removeFromComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Build){removeFromBuildItems((Build)item);}
 else if (item instanceof RoleBindingRestriction){removeFromRoleBindingRestrictionItems((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){removeFromImageStreamTagItems((ImageStreamTag)item);}
 else if (item instanceof Group){removeFromGroupItems((Group)item);}
 else if (item instanceof Policy){removeFromPolicyItems((Policy)item);}
 else if (item instanceof ImageSignature){removeFromImageSignatureItems((ImageSignature)item);}
 else if (item instanceof Binding){removeFromBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){removeFromSecretItems((Secret)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestItems((BuildRequest)item);}
 else if (item instanceof ClusterPolicyBinding){removeFromClusterPolicyBindingItems((ClusterPolicyBinding)item);}
 else if (item instanceof Node){removeFromNodeItems((Node)item);}
 else if (item instanceof ImageStream){removeFromImageStreamItems((ImageStream)item);}
 else if (item instanceof StatefulSet){removeFromStatefulSetItems((StatefulSet)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientItems((OAuthClient)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountItems((ServiceAccount)item);}
 else if (item instanceof Identity){removeFromIdentityItems((Identity)item);}
} return (A)this;
    }

    public A removeAllFromItems(Collection<HasMetadata> items){
            for (HasMetadata item : items) {if (item instanceof LimitRange){removeFromLimitRangeItems((LimitRange)item);}
 else if (item instanceof Job){removeFromJobItems((Job)item);}
 else if (item instanceof ThirdPartyResource){removeFromThirdPartyResourceItems((ThirdPartyResource)item);}
 else if (item instanceof Project){removeFromProjectItems((Project)item);}
 else if (item instanceof SecurityContextConstraints){removeFromSecurityContextConstraintsItems((SecurityContextConstraints)item);}
 else if (item instanceof BuildConfig){removeFromBuildConfigItems((BuildConfig)item);}
 else if (item instanceof Route){removeFromRouteItems((Route)item);}
 else if (item instanceof OAuthAuthorizeToken){removeFromOAuthAuthorizeTokenItems((OAuthAuthorizeToken)item);}
 else if (item instanceof Namespace){removeFromNamespaceItems((Namespace)item);}
 else if (item instanceof ClusterRoleBinding){removeFromClusterRoleBindingItems((ClusterRoleBinding)item);}
 else if (item instanceof Service){removeFromServiceItems((Service)item);}
 else if (item instanceof ReplicationController){removeFromReplicationControllerItems((ReplicationController)item);}
 else if (item instanceof ProjectRequest){removeFromProjectRequestItems((ProjectRequest)item);}
 else if (item instanceof Template){removeFromTemplateItems((Template)item);}
 else if (item instanceof OAuthClientAuthorization){removeFromOAuthClientAuthorizationItems((OAuthClientAuthorization)item);}
 else if (item instanceof PolicyBinding){removeFromPolicyBindingItems((PolicyBinding)item);}
 else if (item instanceof ClusterRole){removeFromClusterRoleItems((ClusterRole)item);}
 else if (item instanceof HorizontalPodAutoscaler){removeFromHorizontalPodAutoscalerItems((HorizontalPodAutoscaler)item);}
 else if (item instanceof Scale){removeFromScaleItems((Scale)item);}
 else if (item instanceof PodTemplate){removeFromPodTemplateItems((PodTemplate)item);}
 else if (item instanceof Event){removeFromEventItems((Event)item);}
 else if (item instanceof Ingress){removeFromIngressItems((Ingress)item);}
 else if (item instanceof OAuthAccessToken){removeFromOAuthAccessTokenItems((OAuthAccessToken)item);}
 else if (item instanceof DeploymentConfig){removeFromDeploymentConfigItems((DeploymentConfig)item);}
 else if (item instanceof RoleBinding){removeFromRoleBindingItems((RoleBinding)item);}
 else if (item instanceof Image){removeFromImageItems((Image)item);}
 else if (item instanceof PersistentVolume){removeFromPersistentVolumeItems((PersistentVolume)item);}
 else if (item instanceof PersistentVolumeClaim){removeFromPersistentVolumeClaimItems((PersistentVolumeClaim)item);}
 else if (item instanceof ReplicaSet){removeFromReplicaSetItems((ReplicaSet)item);}
 else if (item instanceof CronJob){removeFromCronJobItems((CronJob)item);}
 else if (item instanceof Role){removeFromRoleItems((Role)item);}
 else if (item instanceof Endpoints){removeFromEndpointsItems((Endpoints)item);}
 else if (item instanceof Pod){removeFromPodItems((Pod)item);}
 else if (item instanceof CustomResourceDefinition){removeFromCustomResourceDefinitionItems((CustomResourceDefinition)item);}
 else if (item instanceof ClusterPolicy){removeFromClusterPolicyItems((ClusterPolicy)item);}
 else if (item instanceof DaemonSet){removeFromDaemonSetItems((DaemonSet)item);}
 else if (item instanceof Deployment){removeFromDeploymentItems((Deployment)item);}
 else if (item instanceof User){removeFromUserItems((User)item);}
 else if (item instanceof ComponentStatus){removeFromComponentStatusItems((ComponentStatus)item);}
 else if (item instanceof Build){removeFromBuildItems((Build)item);}
 else if (item instanceof RoleBindingRestriction){removeFromRoleBindingRestrictionItems((RoleBindingRestriction)item);}
 else if (item instanceof ImageStreamTag){removeFromImageStreamTagItems((ImageStreamTag)item);}
 else if (item instanceof Group){removeFromGroupItems((Group)item);}
 else if (item instanceof Policy){removeFromPolicyItems((Policy)item);}
 else if (item instanceof ImageSignature){removeFromImageSignatureItems((ImageSignature)item);}
 else if (item instanceof Binding){removeFromBindingItems((Binding)item);}
 else if (item instanceof ResourceQuota){removeFromResourceQuotaItems((ResourceQuota)item);}
 else if (item instanceof Secret){removeFromSecretItems((Secret)item);}
 else if (item instanceof BuildRequest){removeFromBuildRequestItems((BuildRequest)item);}
 else if (item instanceof ClusterPolicyBinding){removeFromClusterPolicyBindingItems((ClusterPolicyBinding)item);}
 else if (item instanceof Node){removeFromNodeItems((Node)item);}
 else if (item instanceof ImageStream){removeFromImageStreamItems((ImageStream)item);}
 else if (item instanceof StatefulSet){removeFromStatefulSetItems((StatefulSet)item);}
 else if (item instanceof OAuthClient){removeFromOAuthClientItems((OAuthClient)item);}
 else if (item instanceof ServiceAccount){removeFromServiceAccountItems((ServiceAccount)item);}
 else if (item instanceof Identity){removeFromIdentityItems((Identity)item);}
} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 */
@Deprecated public List<HasMetadata> getItems(){
            return build(items);
    }

    public List<HasMetadata> buildItems(){
            return build(items);
    }

    public HasMetadata buildItem(int index){
            return this.items.get(index).build();
    }

    public HasMetadata buildFirstItem(){
            return this.items.get(0).build();
    }

    public HasMetadata buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public HasMetadata buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends HasMetadata,?>> predicate){
            for (VisitableBuilder<? extends HasMetadata,?> item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<HasMetadata> items){
            this.items.clear();
            if (items != null) {for (HasMetadata item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(HasMetadata... items){
            this.items.clear(); if (items != null) {for (HasMetadata item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items!= null && !items.isEmpty();
    }

    public A addToLimitRangeItems(int index,LimitRange item){
            LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToLimitRangeItems(int index,LimitRange item){
            LimitRangeBuilder builder = new LimitRangeBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToLimitRangeItems(LimitRange... items){
            for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToLimitRangeItems(Collection<LimitRange> items){
            for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromLimitRangeItems(LimitRange... items){
            for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromLimitRangeItems(Collection<LimitRange> items){
            for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItem(){
            return new LimitRangeItemsNestedImpl();
    }

    public BaseKubernetesListFluent.LimitRangeItemsNested<A> addNewLimitRangeItemLike(LimitRange item){
            return new LimitRangeItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.LimitRangeItemsNested<A> setNewLimitRangeItemLike(int index,LimitRange item){
            return new LimitRangeItemsNestedImpl(index, item);
    }

    public A addToJobItems(int index,Job item){
            JobBuilder builder = new JobBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToJobItems(int index,Job item){
            JobBuilder builder = new JobBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToJobItems(Job... items){
            for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToJobItems(Collection<Job> items){
            for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromJobItems(Job... items){
            for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromJobItems(Collection<Job> items){
            for (Job item : items) {JobBuilder builder = new JobBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.JobItemsNested<A> addNewJobItem(){
            return new JobItemsNestedImpl();
    }

    public BaseKubernetesListFluent.JobItemsNested<A> addNewJobItemLike(Job item){
            return new JobItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.JobItemsNested<A> setNewJobItemLike(int index,Job item){
            return new JobItemsNestedImpl(index, item);
    }

    public A addToThirdPartyResourceItems(int index,ThirdPartyResource item){
            ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToThirdPartyResourceItems(int index,ThirdPartyResource item){
            ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToThirdPartyResourceItems(ThirdPartyResource... items){
            for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToThirdPartyResourceItems(Collection<ThirdPartyResource> items){
            for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromThirdPartyResourceItems(ThirdPartyResource... items){
            for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromThirdPartyResourceItems(Collection<ThirdPartyResource> items){
            for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ThirdPartyResourceItemsNested<A> addNewThirdPartyResourceItem(){
            return new ThirdPartyResourceItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ThirdPartyResourceItemsNested<A> addNewThirdPartyResourceItemLike(ThirdPartyResource item){
            return new ThirdPartyResourceItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ThirdPartyResourceItemsNested<A> setNewThirdPartyResourceItemLike(int index,ThirdPartyResource item){
            return new ThirdPartyResourceItemsNestedImpl(index, item);
    }

    public A addToProjectItems(int index,Project item){
            ProjectBuilder builder = new ProjectBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToProjectItems(int index,Project item){
            ProjectBuilder builder = new ProjectBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToProjectItems(Project... items){
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToProjectItems(Collection<Project> items){
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromProjectItems(Project... items){
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromProjectItems(Collection<Project> items){
            for (Project item : items) {ProjectBuilder builder = new ProjectBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ProjectItemsNested<A> addNewProjectItem(){
            return new ProjectItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ProjectItemsNested<A> addNewProjectItemLike(Project item){
            return new ProjectItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ProjectItemsNested<A> setNewProjectItemLike(int index,Project item){
            return new ProjectItemsNestedImpl(index, item);
    }

    public A addToSecurityContextConstraintsItems(int index,SecurityContextConstraints item){
            SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToSecurityContextConstraintsItems(int index,SecurityContextConstraints item){
            SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToSecurityContextConstraintsItems(SecurityContextConstraints... items){
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToSecurityContextConstraintsItems(Collection<SecurityContextConstraints> items){
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromSecurityContextConstraintsItems(SecurityContextConstraints... items){
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromSecurityContextConstraintsItems(Collection<SecurityContextConstraints> items){
            for (SecurityContextConstraints item : items) {SecurityContextConstraintsBuilder builder = new SecurityContextConstraintsBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<A> addNewSecurityContextConstraintsItem(){
            return new SecurityContextConstraintsItemsNestedImpl();
    }

    public BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<A> addNewSecurityContextConstraintsItemLike(SecurityContextConstraints item){
            return new SecurityContextConstraintsItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<A> setNewSecurityContextConstraintsItemLike(int index,SecurityContextConstraints item){
            return new SecurityContextConstraintsItemsNestedImpl(index, item);
    }

    public A addToBuildConfigItems(int index,BuildConfig item){
            BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToBuildConfigItems(int index,BuildConfig item){
            BuildConfigBuilder builder = new BuildConfigBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToBuildConfigItems(BuildConfig... items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToBuildConfigItems(Collection<BuildConfig> items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromBuildConfigItems(BuildConfig... items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromBuildConfigItems(Collection<BuildConfig> items){
            for (BuildConfig item : items) {BuildConfigBuilder builder = new BuildConfigBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.BuildConfigItemsNested<A> addNewBuildConfigItem(){
            return new BuildConfigItemsNestedImpl();
    }

    public BaseKubernetesListFluent.BuildConfigItemsNested<A> addNewBuildConfigItemLike(BuildConfig item){
            return new BuildConfigItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.BuildConfigItemsNested<A> setNewBuildConfigItemLike(int index,BuildConfig item){
            return new BuildConfigItemsNestedImpl(index, item);
    }

    public A addToRouteItems(int index,Route item){
            RouteBuilder builder = new RouteBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToRouteItems(int index,Route item){
            RouteBuilder builder = new RouteBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToRouteItems(Route... items){
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToRouteItems(Collection<Route> items){
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromRouteItems(Route... items){
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromRouteItems(Collection<Route> items){
            for (Route item : items) {RouteBuilder builder = new RouteBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.RouteItemsNested<A> addNewRouteItem(){
            return new RouteItemsNestedImpl();
    }

    public BaseKubernetesListFluent.RouteItemsNested<A> addNewRouteItemLike(Route item){
            return new RouteItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.RouteItemsNested<A> setNewRouteItemLike(int index,Route item){
            return new RouteItemsNestedImpl(index, item);
    }

    public A addToOAuthAuthorizeTokenItems(int index,OAuthAuthorizeToken item){
            OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToOAuthAuthorizeTokenItems(int index,OAuthAuthorizeToken item){
            OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToOAuthAuthorizeTokenItems(OAuthAuthorizeToken... items){
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToOAuthAuthorizeTokenItems(Collection<OAuthAuthorizeToken> items){
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromOAuthAuthorizeTokenItems(OAuthAuthorizeToken... items){
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromOAuthAuthorizeTokenItems(Collection<OAuthAuthorizeToken> items){
            for (OAuthAuthorizeToken item : items) {OAuthAuthorizeTokenBuilder builder = new OAuthAuthorizeTokenBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<A> addNewOAuthAuthorizeTokenItem(){
            return new OAuthAuthorizeTokenItemsNestedImpl();
    }

    public BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<A> addNewOAuthAuthorizeTokenItemLike(OAuthAuthorizeToken item){
            return new OAuthAuthorizeTokenItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<A> setNewOAuthAuthorizeTokenItemLike(int index,OAuthAuthorizeToken item){
            return new OAuthAuthorizeTokenItemsNestedImpl(index, item);
    }

    public A addToNamespaceItems(int index,Namespace item){
            NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToNamespaceItems(int index,Namespace item){
            NamespaceBuilder builder = new NamespaceBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToNamespaceItems(Namespace... items){
            for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToNamespaceItems(Collection<Namespace> items){
            for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromNamespaceItems(Namespace... items){
            for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromNamespaceItems(Collection<Namespace> items){
            for (Namespace item : items) {NamespaceBuilder builder = new NamespaceBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItem(){
            return new NamespaceItemsNestedImpl();
    }

    public BaseKubernetesListFluent.NamespaceItemsNested<A> addNewNamespaceItemLike(Namespace item){
            return new NamespaceItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.NamespaceItemsNested<A> setNewNamespaceItemLike(int index,Namespace item){
            return new NamespaceItemsNestedImpl(index, item);
    }

    public A addToClusterRoleBindingItems(int index,ClusterRoleBinding item){
            ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToClusterRoleBindingItems(int index,ClusterRoleBinding item){
            ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToClusterRoleBindingItems(ClusterRoleBinding... items){
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToClusterRoleBindingItems(Collection<ClusterRoleBinding> items){
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromClusterRoleBindingItems(ClusterRoleBinding... items){
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromClusterRoleBindingItems(Collection<ClusterRoleBinding> items){
            for (ClusterRoleBinding item : items) {ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ClusterRoleBindingItemsNested<A> addNewClusterRoleBindingItem(){
            return new ClusterRoleBindingItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ClusterRoleBindingItemsNested<A> addNewClusterRoleBindingItemLike(ClusterRoleBinding item){
            return new ClusterRoleBindingItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ClusterRoleBindingItemsNested<A> setNewClusterRoleBindingItemLike(int index,ClusterRoleBinding item){
            return new ClusterRoleBindingItemsNestedImpl(index, item);
    }

    public A addToServiceItems(int index,Service item){
            ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToServiceItems(int index,Service item){
            ServiceBuilder builder = new ServiceBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToServiceItems(Service... items){
            for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToServiceItems(Collection<Service> items){
            for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromServiceItems(Service... items){
            for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromServiceItems(Collection<Service> items){
            for (Service item : items) {ServiceBuilder builder = new ServiceBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItem(){
            return new ServiceItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ServiceItemsNested<A> addNewServiceItemLike(Service item){
            return new ServiceItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ServiceItemsNested<A> setNewServiceItemLike(int index,Service item){
            return new ServiceItemsNestedImpl(index, item);
    }

    public A addToReplicationControllerItems(int index,ReplicationController item){
            ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToReplicationControllerItems(int index,ReplicationController item){
            ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToReplicationControllerItems(ReplicationController... items){
            for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToReplicationControllerItems(Collection<ReplicationController> items){
            for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromReplicationControllerItems(ReplicationController... items){
            for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromReplicationControllerItems(Collection<ReplicationController> items){
            for (ReplicationController item : items) {ReplicationControllerBuilder builder = new ReplicationControllerBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItem(){
            return new ReplicationControllerItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> addNewReplicationControllerItemLike(ReplicationController item){
            return new ReplicationControllerItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ReplicationControllerItemsNested<A> setNewReplicationControllerItemLike(int index,ReplicationController item){
            return new ReplicationControllerItemsNestedImpl(index, item);
    }

    public A addToProjectRequestItems(int index,ProjectRequest item){
            ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToProjectRequestItems(int index,ProjectRequest item){
            ProjectRequestBuilder builder = new ProjectRequestBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToProjectRequestItems(ProjectRequest... items){
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToProjectRequestItems(Collection<ProjectRequest> items){
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromProjectRequestItems(ProjectRequest... items){
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromProjectRequestItems(Collection<ProjectRequest> items){
            for (ProjectRequest item : items) {ProjectRequestBuilder builder = new ProjectRequestBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ProjectRequestItemsNested<A> addNewProjectRequestItem(){
            return new ProjectRequestItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ProjectRequestItemsNested<A> addNewProjectRequestItemLike(ProjectRequest item){
            return new ProjectRequestItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ProjectRequestItemsNested<A> setNewProjectRequestItemLike(int index,ProjectRequest item){
            return new ProjectRequestItemsNestedImpl(index, item);
    }

    public A addToTemplateItems(int index,Template item){
            TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToTemplateItems(int index,Template item){
            TemplateBuilder builder = new TemplateBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToTemplateItems(Template... items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToTemplateItems(Collection<Template> items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromTemplateItems(Template... items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromTemplateItems(Collection<Template> items){
            for (Template item : items) {TemplateBuilder builder = new TemplateBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.TemplateItemsNested<A> addNewTemplateItem(){
            return new TemplateItemsNestedImpl();
    }

    public BaseKubernetesListFluent.TemplateItemsNested<A> addNewTemplateItemLike(Template item){
            return new TemplateItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.TemplateItemsNested<A> setNewTemplateItemLike(int index,Template item){
            return new TemplateItemsNestedImpl(index, item);
    }

    public A addToOAuthClientAuthorizationItems(int index,OAuthClientAuthorization item){
            OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToOAuthClientAuthorizationItems(int index,OAuthClientAuthorization item){
            OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToOAuthClientAuthorizationItems(OAuthClientAuthorization... items){
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToOAuthClientAuthorizationItems(Collection<OAuthClientAuthorization> items){
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromOAuthClientAuthorizationItems(OAuthClientAuthorization... items){
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromOAuthClientAuthorizationItems(Collection<OAuthClientAuthorization> items){
            for (OAuthClientAuthorization item : items) {OAuthClientAuthorizationBuilder builder = new OAuthClientAuthorizationBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<A> addNewOAuthClientAuthorizationItem(){
            return new OAuthClientAuthorizationItemsNestedImpl();
    }

    public BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<A> addNewOAuthClientAuthorizationItemLike(OAuthClientAuthorization item){
            return new OAuthClientAuthorizationItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<A> setNewOAuthClientAuthorizationItemLike(int index,OAuthClientAuthorization item){
            return new OAuthClientAuthorizationItemsNestedImpl(index, item);
    }

    public A addToPolicyBindingItems(int index,PolicyBinding item){
            PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToPolicyBindingItems(int index,PolicyBinding item){
            PolicyBindingBuilder builder = new PolicyBindingBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToPolicyBindingItems(PolicyBinding... items){
            for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToPolicyBindingItems(Collection<PolicyBinding> items){
            for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPolicyBindingItems(PolicyBinding... items){
            for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromPolicyBindingItems(Collection<PolicyBinding> items){
            for (PolicyBinding item : items) {PolicyBindingBuilder builder = new PolicyBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PolicyBindingItemsNested<A> addNewPolicyBindingItem(){
            return new PolicyBindingItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PolicyBindingItemsNested<A> addNewPolicyBindingItemLike(PolicyBinding item){
            return new PolicyBindingItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.PolicyBindingItemsNested<A> setNewPolicyBindingItemLike(int index,PolicyBinding item){
            return new PolicyBindingItemsNestedImpl(index, item);
    }

    public A addToClusterRoleItems(int index,ClusterRole item){
            ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToClusterRoleItems(int index,ClusterRole item){
            ClusterRoleBuilder builder = new ClusterRoleBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToClusterRoleItems(ClusterRole... items){
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToClusterRoleItems(Collection<ClusterRole> items){
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromClusterRoleItems(ClusterRole... items){
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromClusterRoleItems(Collection<ClusterRole> items){
            for (ClusterRole item : items) {ClusterRoleBuilder builder = new ClusterRoleBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ClusterRoleItemsNested<A> addNewClusterRoleItem(){
            return new ClusterRoleItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ClusterRoleItemsNested<A> addNewClusterRoleItemLike(ClusterRole item){
            return new ClusterRoleItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ClusterRoleItemsNested<A> setNewClusterRoleItemLike(int index,ClusterRole item){
            return new ClusterRoleItemsNestedImpl(index, item);
    }

    public A addToHorizontalPodAutoscalerItems(int index,HorizontalPodAutoscaler item){
            HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToHorizontalPodAutoscalerItems(int index,HorizontalPodAutoscaler item){
            HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToHorizontalPodAutoscalerItems(HorizontalPodAutoscaler... items){
            for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToHorizontalPodAutoscalerItems(Collection<HorizontalPodAutoscaler> items){
            for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromHorizontalPodAutoscalerItems(HorizontalPodAutoscaler... items){
            for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromHorizontalPodAutoscalerItems(Collection<HorizontalPodAutoscaler> items){
            for (HorizontalPodAutoscaler item : items) {HorizontalPodAutoscalerBuilder builder = new HorizontalPodAutoscalerBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<A> addNewHorizontalPodAutoscalerItem(){
            return new HorizontalPodAutoscalerItemsNestedImpl();
    }

    public BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<A> addNewHorizontalPodAutoscalerItemLike(HorizontalPodAutoscaler item){
            return new HorizontalPodAutoscalerItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<A> setNewHorizontalPodAutoscalerItemLike(int index,HorizontalPodAutoscaler item){
            return new HorizontalPodAutoscalerItemsNestedImpl(index, item);
    }

    public A addToScaleItems(int index,Scale item){
            ScaleBuilder builder = new ScaleBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToScaleItems(int index,Scale item){
            ScaleBuilder builder = new ScaleBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToScaleItems(Scale... items){
            for (Scale item : items) {ScaleBuilder builder = new ScaleBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToScaleItems(Collection<Scale> items){
            for (Scale item : items) {ScaleBuilder builder = new ScaleBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromScaleItems(Scale... items){
            for (Scale item : items) {ScaleBuilder builder = new ScaleBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromScaleItems(Collection<Scale> items){
            for (Scale item : items) {ScaleBuilder builder = new ScaleBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ScaleItemsNested<A> addNewScaleItem(){
            return new ScaleItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ScaleItemsNested<A> addNewScaleItemLike(Scale item){
            return new ScaleItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ScaleItemsNested<A> setNewScaleItemLike(int index,Scale item){
            return new ScaleItemsNestedImpl(index, item);
    }

    public A addToPodTemplateItems(int index,PodTemplate item){
            PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToPodTemplateItems(int index,PodTemplate item){
            PodTemplateBuilder builder = new PodTemplateBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToPodTemplateItems(PodTemplate... items){
            for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToPodTemplateItems(Collection<PodTemplate> items){
            for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPodTemplateItems(PodTemplate... items){
            for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromPodTemplateItems(Collection<PodTemplate> items){
            for (PodTemplate item : items) {PodTemplateBuilder builder = new PodTemplateBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItem(){
            return new PodTemplateItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PodTemplateItemsNested<A> addNewPodTemplateItemLike(PodTemplate item){
            return new PodTemplateItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.PodTemplateItemsNested<A> setNewPodTemplateItemLike(int index,PodTemplate item){
            return new PodTemplateItemsNestedImpl(index, item);
    }

    public A addToEventItems(int index,Event item){
            EventBuilder builder = new EventBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToEventItems(int index,Event item){
            EventBuilder builder = new EventBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToEventItems(Event... items){
            for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToEventItems(Collection<Event> items){
            for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromEventItems(Event... items){
            for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromEventItems(Collection<Event> items){
            for (Event item : items) {EventBuilder builder = new EventBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.EventItemsNested<A> addNewEventItem(){
            return new EventItemsNestedImpl();
    }

    public BaseKubernetesListFluent.EventItemsNested<A> addNewEventItemLike(Event item){
            return new EventItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.EventItemsNested<A> setNewEventItemLike(int index,Event item){
            return new EventItemsNestedImpl(index, item);
    }

    public A addToIngressItems(int index,Ingress item){
            IngressBuilder builder = new IngressBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToIngressItems(int index,Ingress item){
            IngressBuilder builder = new IngressBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToIngressItems(Ingress... items){
            for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToIngressItems(Collection<Ingress> items){
            for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromIngressItems(Ingress... items){
            for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromIngressItems(Collection<Ingress> items){
            for (Ingress item : items) {IngressBuilder builder = new IngressBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.IngressItemsNested<A> addNewIngressItem(){
            return new IngressItemsNestedImpl();
    }

    public BaseKubernetesListFluent.IngressItemsNested<A> addNewIngressItemLike(Ingress item){
            return new IngressItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.IngressItemsNested<A> setNewIngressItemLike(int index,Ingress item){
            return new IngressItemsNestedImpl(index, item);
    }

    public A addToOAuthAccessTokenItems(int index,OAuthAccessToken item){
            OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToOAuthAccessTokenItems(int index,OAuthAccessToken item){
            OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToOAuthAccessTokenItems(OAuthAccessToken... items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToOAuthAccessTokenItems(Collection<OAuthAccessToken> items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromOAuthAccessTokenItems(OAuthAccessToken... items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromOAuthAccessTokenItems(Collection<OAuthAccessToken> items){
            for (OAuthAccessToken item : items) {OAuthAccessTokenBuilder builder = new OAuthAccessTokenBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.OAuthAccessTokenItemsNested<A> addNewOAuthAccessTokenItem(){
            return new OAuthAccessTokenItemsNestedImpl();
    }

    public BaseKubernetesListFluent.OAuthAccessTokenItemsNested<A> addNewOAuthAccessTokenItemLike(OAuthAccessToken item){
            return new OAuthAccessTokenItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.OAuthAccessTokenItemsNested<A> setNewOAuthAccessTokenItemLike(int index,OAuthAccessToken item){
            return new OAuthAccessTokenItemsNestedImpl(index, item);
    }

    public A addToDeploymentConfigItems(int index,DeploymentConfig item){
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToDeploymentConfigItems(int index,DeploymentConfig item){
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToDeploymentConfigItems(DeploymentConfig... items){
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToDeploymentConfigItems(Collection<DeploymentConfig> items){
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromDeploymentConfigItems(DeploymentConfig... items){
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromDeploymentConfigItems(Collection<DeploymentConfig> items){
            for (DeploymentConfig item : items) {DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.DeploymentConfigItemsNested<A> addNewDeploymentConfigItem(){
            return new DeploymentConfigItemsNestedImpl();
    }

    public BaseKubernetesListFluent.DeploymentConfigItemsNested<A> addNewDeploymentConfigItemLike(DeploymentConfig item){
            return new DeploymentConfigItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.DeploymentConfigItemsNested<A> setNewDeploymentConfigItemLike(int index,DeploymentConfig item){
            return new DeploymentConfigItemsNestedImpl(index, item);
    }

    public A addToRoleBindingItems(int index,RoleBinding item){
            RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToRoleBindingItems(int index,RoleBinding item){
            RoleBindingBuilder builder = new RoleBindingBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToRoleBindingItems(RoleBinding... items){
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToRoleBindingItems(Collection<RoleBinding> items){
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromRoleBindingItems(RoleBinding... items){
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromRoleBindingItems(Collection<RoleBinding> items){
            for (RoleBinding item : items) {RoleBindingBuilder builder = new RoleBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.RoleBindingItemsNested<A> addNewRoleBindingItem(){
            return new RoleBindingItemsNestedImpl();
    }

    public BaseKubernetesListFluent.RoleBindingItemsNested<A> addNewRoleBindingItemLike(RoleBinding item){
            return new RoleBindingItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.RoleBindingItemsNested<A> setNewRoleBindingItemLike(int index,RoleBinding item){
            return new RoleBindingItemsNestedImpl(index, item);
    }

    public A addToImageItems(int index,Image item){
            ImageBuilder builder = new ImageBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToImageItems(int index,Image item){
            ImageBuilder builder = new ImageBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToImageItems(Image... items){
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToImageItems(Collection<Image> items){
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromImageItems(Image... items){
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromImageItems(Collection<Image> items){
            for (Image item : items) {ImageBuilder builder = new ImageBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ImageItemsNested<A> addNewImageItem(){
            return new ImageItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ImageItemsNested<A> addNewImageItemLike(Image item){
            return new ImageItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ImageItemsNested<A> setNewImageItemLike(int index,Image item){
            return new ImageItemsNestedImpl(index, item);
    }

    public A addToPersistentVolumeItems(int index,PersistentVolume item){
            PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToPersistentVolumeItems(int index,PersistentVolume item){
            PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToPersistentVolumeItems(PersistentVolume... items){
            for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToPersistentVolumeItems(Collection<PersistentVolume> items){
            for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPersistentVolumeItems(PersistentVolume... items){
            for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromPersistentVolumeItems(Collection<PersistentVolume> items){
            for (PersistentVolume item : items) {PersistentVolumeBuilder builder = new PersistentVolumeBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItem(){
            return new PersistentVolumeItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> addNewPersistentVolumeItemLike(PersistentVolume item){
            return new PersistentVolumeItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.PersistentVolumeItemsNested<A> setNewPersistentVolumeItemLike(int index,PersistentVolume item){
            return new PersistentVolumeItemsNestedImpl(index, item);
    }

    public A addToPersistentVolumeClaimItems(int index,PersistentVolumeClaim item){
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToPersistentVolumeClaimItems(int index,PersistentVolumeClaim item){
            PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToPersistentVolumeClaimItems(PersistentVolumeClaim... items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPersistentVolumeClaimItems(PersistentVolumeClaim... items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromPersistentVolumeClaimItems(Collection<PersistentVolumeClaim> items){
            for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItem(){
            return new PersistentVolumeClaimItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> addNewPersistentVolumeClaimItemLike(PersistentVolumeClaim item){
            return new PersistentVolumeClaimItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<A> setNewPersistentVolumeClaimItemLike(int index,PersistentVolumeClaim item){
            return new PersistentVolumeClaimItemsNestedImpl(index, item);
    }

    public A addToReplicaSetItems(int index,ReplicaSet item){
            ReplicaSetBuilder builder = new ReplicaSetBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToReplicaSetItems(int index,ReplicaSet item){
            ReplicaSetBuilder builder = new ReplicaSetBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToReplicaSetItems(ReplicaSet... items){
            for (ReplicaSet item : items) {ReplicaSetBuilder builder = new ReplicaSetBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToReplicaSetItems(Collection<ReplicaSet> items){
            for (ReplicaSet item : items) {ReplicaSetBuilder builder = new ReplicaSetBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromReplicaSetItems(ReplicaSet... items){
            for (ReplicaSet item : items) {ReplicaSetBuilder builder = new ReplicaSetBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromReplicaSetItems(Collection<ReplicaSet> items){
            for (ReplicaSet item : items) {ReplicaSetBuilder builder = new ReplicaSetBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ReplicaSetItemsNested<A> addNewReplicaSetItem(){
            return new ReplicaSetItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ReplicaSetItemsNested<A> addNewReplicaSetItemLike(ReplicaSet item){
            return new ReplicaSetItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ReplicaSetItemsNested<A> setNewReplicaSetItemLike(int index,ReplicaSet item){
            return new ReplicaSetItemsNestedImpl(index, item);
    }

    public A addToCronJobItems(int index,CronJob item){
            CronJobBuilder builder = new CronJobBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToCronJobItems(int index,CronJob item){
            CronJobBuilder builder = new CronJobBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToCronJobItems(CronJob... items){
            for (CronJob item : items) {CronJobBuilder builder = new CronJobBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToCronJobItems(Collection<CronJob> items){
            for (CronJob item : items) {CronJobBuilder builder = new CronJobBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromCronJobItems(CronJob... items){
            for (CronJob item : items) {CronJobBuilder builder = new CronJobBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromCronJobItems(Collection<CronJob> items){
            for (CronJob item : items) {CronJobBuilder builder = new CronJobBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.CronJobItemsNested<A> addNewCronJobItem(){
            return new CronJobItemsNestedImpl();
    }

    public BaseKubernetesListFluent.CronJobItemsNested<A> addNewCronJobItemLike(CronJob item){
            return new CronJobItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.CronJobItemsNested<A> setNewCronJobItemLike(int index,CronJob item){
            return new CronJobItemsNestedImpl(index, item);
    }

    public A addToRoleItems(int index,Role item){
            RoleBuilder builder = new RoleBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToRoleItems(int index,Role item){
            RoleBuilder builder = new RoleBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToRoleItems(Role... items){
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToRoleItems(Collection<Role> items){
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromRoleItems(Role... items){
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromRoleItems(Collection<Role> items){
            for (Role item : items) {RoleBuilder builder = new RoleBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.RoleItemsNested<A> addNewRoleItem(){
            return new RoleItemsNestedImpl();
    }

    public BaseKubernetesListFluent.RoleItemsNested<A> addNewRoleItemLike(Role item){
            return new RoleItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.RoleItemsNested<A> setNewRoleItemLike(int index,Role item){
            return new RoleItemsNestedImpl(index, item);
    }

    public A addToEndpointsItems(int index,Endpoints item){
            EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToEndpointsItems(int index,Endpoints item){
            EndpointsBuilder builder = new EndpointsBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToEndpointsItems(Endpoints... items){
            for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToEndpointsItems(Collection<Endpoints> items){
            for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromEndpointsItems(Endpoints... items){
            for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromEndpointsItems(Collection<Endpoints> items){
            for (Endpoints item : items) {EndpointsBuilder builder = new EndpointsBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItem(){
            return new EndpointsItemsNestedImpl();
    }

    public BaseKubernetesListFluent.EndpointsItemsNested<A> addNewEndpointsItemLike(Endpoints item){
            return new EndpointsItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.EndpointsItemsNested<A> setNewEndpointsItemLike(int index,Endpoints item){
            return new EndpointsItemsNestedImpl(index, item);
    }

    public A addToPodItems(int index,Pod item){
            PodBuilder builder = new PodBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToPodItems(int index,Pod item){
            PodBuilder builder = new PodBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToPodItems(Pod... items){
            for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToPodItems(Collection<Pod> items){
            for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPodItems(Pod... items){
            for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromPodItems(Collection<Pod> items){
            for (Pod item : items) {PodBuilder builder = new PodBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItem(){
            return new PodItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PodItemsNested<A> addNewPodItemLike(Pod item){
            return new PodItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.PodItemsNested<A> setNewPodItemLike(int index,Pod item){
            return new PodItemsNestedImpl(index, item);
    }

    public A addToCustomResourceDefinitionItems(int index,CustomResourceDefinition item){
            CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToCustomResourceDefinitionItems(int index,CustomResourceDefinition item){
            CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToCustomResourceDefinitionItems(CustomResourceDefinition... items){
            for (CustomResourceDefinition item : items) {CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToCustomResourceDefinitionItems(Collection<CustomResourceDefinition> items){
            for (CustomResourceDefinition item : items) {CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromCustomResourceDefinitionItems(CustomResourceDefinition... items){
            for (CustomResourceDefinition item : items) {CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromCustomResourceDefinitionItems(Collection<CustomResourceDefinition> items){
            for (CustomResourceDefinition item : items) {CustomResourceDefinitionBuilder builder = new CustomResourceDefinitionBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.CustomResourceDefinitionItemsNested<A> addNewCustomResourceDefinitionItem(){
            return new CustomResourceDefinitionItemsNestedImpl();
    }

    public BaseKubernetesListFluent.CustomResourceDefinitionItemsNested<A> addNewCustomResourceDefinitionItemLike(CustomResourceDefinition item){
            return new CustomResourceDefinitionItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.CustomResourceDefinitionItemsNested<A> setNewCustomResourceDefinitionItemLike(int index,CustomResourceDefinition item){
            return new CustomResourceDefinitionItemsNestedImpl(index, item);
    }

    public A addToClusterPolicyItems(int index,ClusterPolicy item){
            ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToClusterPolicyItems(int index,ClusterPolicy item){
            ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToClusterPolicyItems(ClusterPolicy... items){
            for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToClusterPolicyItems(Collection<ClusterPolicy> items){
            for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromClusterPolicyItems(ClusterPolicy... items){
            for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromClusterPolicyItems(Collection<ClusterPolicy> items){
            for (ClusterPolicy item : items) {ClusterPolicyBuilder builder = new ClusterPolicyBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ClusterPolicyItemsNested<A> addNewClusterPolicyItem(){
            return new ClusterPolicyItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ClusterPolicyItemsNested<A> addNewClusterPolicyItemLike(ClusterPolicy item){
            return new ClusterPolicyItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ClusterPolicyItemsNested<A> setNewClusterPolicyItemLike(int index,ClusterPolicy item){
            return new ClusterPolicyItemsNestedImpl(index, item);
    }

    public A addToDaemonSetItems(int index,DaemonSet item){
            DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToDaemonSetItems(int index,DaemonSet item){
            DaemonSetBuilder builder = new DaemonSetBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToDaemonSetItems(DaemonSet... items){
            for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToDaemonSetItems(Collection<DaemonSet> items){
            for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromDaemonSetItems(DaemonSet... items){
            for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromDaemonSetItems(Collection<DaemonSet> items){
            for (DaemonSet item : items) {DaemonSetBuilder builder = new DaemonSetBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.DaemonSetItemsNested<A> addNewDaemonSetItem(){
            return new DaemonSetItemsNestedImpl();
    }

    public BaseKubernetesListFluent.DaemonSetItemsNested<A> addNewDaemonSetItemLike(DaemonSet item){
            return new DaemonSetItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.DaemonSetItemsNested<A> setNewDaemonSetItemLike(int index,DaemonSet item){
            return new DaemonSetItemsNestedImpl(index, item);
    }

    public A addToDeploymentItems(int index,Deployment item){
            DeploymentBuilder builder = new DeploymentBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToDeploymentItems(int index,Deployment item){
            DeploymentBuilder builder = new DeploymentBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToDeploymentItems(Deployment... items){
            for (Deployment item : items) {DeploymentBuilder builder = new DeploymentBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToDeploymentItems(Collection<Deployment> items){
            for (Deployment item : items) {DeploymentBuilder builder = new DeploymentBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromDeploymentItems(Deployment... items){
            for (Deployment item : items) {DeploymentBuilder builder = new DeploymentBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromDeploymentItems(Collection<Deployment> items){
            for (Deployment item : items) {DeploymentBuilder builder = new DeploymentBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.DeploymentItemsNested<A> addNewDeploymentItem(){
            return new DeploymentItemsNestedImpl();
    }

    public BaseKubernetesListFluent.DeploymentItemsNested<A> addNewDeploymentItemLike(Deployment item){
            return new DeploymentItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.DeploymentItemsNested<A> setNewDeploymentItemLike(int index,Deployment item){
            return new DeploymentItemsNestedImpl(index, item);
    }

    public A addToUserItems(int index,User item){
            UserBuilder builder = new UserBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToUserItems(int index,User item){
            UserBuilder builder = new UserBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToUserItems(User... items){
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToUserItems(Collection<User> items){
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromUserItems(User... items){
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromUserItems(Collection<User> items){
            for (User item : items) {UserBuilder builder = new UserBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.UserItemsNested<A> addNewUserItem(){
            return new UserItemsNestedImpl();
    }

    public BaseKubernetesListFluent.UserItemsNested<A> addNewUserItemLike(User item){
            return new UserItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.UserItemsNested<A> setNewUserItemLike(int index,User item){
            return new UserItemsNestedImpl(index, item);
    }

    public A addToComponentStatusItems(int index,ComponentStatus item){
            ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToComponentStatusItems(int index,ComponentStatus item){
            ComponentStatusBuilder builder = new ComponentStatusBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToComponentStatusItems(ComponentStatus... items){
            for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToComponentStatusItems(Collection<ComponentStatus> items){
            for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromComponentStatusItems(ComponentStatus... items){
            for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromComponentStatusItems(Collection<ComponentStatus> items){
            for (ComponentStatus item : items) {ComponentStatusBuilder builder = new ComponentStatusBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItem(){
            return new ComponentStatusItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> addNewComponentStatusItemLike(ComponentStatus item){
            return new ComponentStatusItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ComponentStatusItemsNested<A> setNewComponentStatusItemLike(int index,ComponentStatus item){
            return new ComponentStatusItemsNestedImpl(index, item);
    }

    public A addToBuildItems(int index,Build item){
            BuildBuilder builder = new BuildBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToBuildItems(int index,Build item){
            BuildBuilder builder = new BuildBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToBuildItems(Build... items){
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToBuildItems(Collection<Build> items){
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromBuildItems(Build... items){
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromBuildItems(Collection<Build> items){
            for (Build item : items) {BuildBuilder builder = new BuildBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.BuildItemsNested<A> addNewBuildItem(){
            return new BuildItemsNestedImpl();
    }

    public BaseKubernetesListFluent.BuildItemsNested<A> addNewBuildItemLike(Build item){
            return new BuildItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.BuildItemsNested<A> setNewBuildItemLike(int index,Build item){
            return new BuildItemsNestedImpl(index, item);
    }

    public A addToRoleBindingRestrictionItems(int index,RoleBindingRestriction item){
            RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToRoleBindingRestrictionItems(int index,RoleBindingRestriction item){
            RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToRoleBindingRestrictionItems(RoleBindingRestriction... items){
            for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToRoleBindingRestrictionItems(Collection<RoleBindingRestriction> items){
            for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromRoleBindingRestrictionItems(RoleBindingRestriction... items){
            for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromRoleBindingRestrictionItems(Collection<RoleBindingRestriction> items){
            for (RoleBindingRestriction item : items) {RoleBindingRestrictionBuilder builder = new RoleBindingRestrictionBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.RoleBindingRestrictionItemsNested<A> addNewRoleBindingRestrictionItem(){
            return new RoleBindingRestrictionItemsNestedImpl();
    }

    public BaseKubernetesListFluent.RoleBindingRestrictionItemsNested<A> addNewRoleBindingRestrictionItemLike(RoleBindingRestriction item){
            return new RoleBindingRestrictionItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.RoleBindingRestrictionItemsNested<A> setNewRoleBindingRestrictionItemLike(int index,RoleBindingRestriction item){
            return new RoleBindingRestrictionItemsNestedImpl(index, item);
    }

    public A addToImageStreamTagItems(int index,ImageStreamTag item){
            ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToImageStreamTagItems(int index,ImageStreamTag item){
            ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToImageStreamTagItems(ImageStreamTag... items){
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToImageStreamTagItems(Collection<ImageStreamTag> items){
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromImageStreamTagItems(ImageStreamTag... items){
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromImageStreamTagItems(Collection<ImageStreamTag> items){
            for (ImageStreamTag item : items) {ImageStreamTagBuilder builder = new ImageStreamTagBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ImageStreamTagItemsNested<A> addNewImageStreamTagItem(){
            return new ImageStreamTagItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ImageStreamTagItemsNested<A> addNewImageStreamTagItemLike(ImageStreamTag item){
            return new ImageStreamTagItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ImageStreamTagItemsNested<A> setNewImageStreamTagItemLike(int index,ImageStreamTag item){
            return new ImageStreamTagItemsNestedImpl(index, item);
    }

    public A addToGroupItems(int index,Group item){
            GroupBuilder builder = new GroupBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToGroupItems(int index,Group item){
            GroupBuilder builder = new GroupBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToGroupItems(Group... items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToGroupItems(Collection<Group> items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromGroupItems(Group... items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromGroupItems(Collection<Group> items){
            for (Group item : items) {GroupBuilder builder = new GroupBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.GroupItemsNested<A> addNewGroupItem(){
            return new GroupItemsNestedImpl();
    }

    public BaseKubernetesListFluent.GroupItemsNested<A> addNewGroupItemLike(Group item){
            return new GroupItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.GroupItemsNested<A> setNewGroupItemLike(int index,Group item){
            return new GroupItemsNestedImpl(index, item);
    }

    public A addToPolicyItems(int index,Policy item){
            PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToPolicyItems(int index,Policy item){
            PolicyBuilder builder = new PolicyBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToPolicyItems(Policy... items){
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToPolicyItems(Collection<Policy> items){
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromPolicyItems(Policy... items){
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromPolicyItems(Collection<Policy> items){
            for (Policy item : items) {PolicyBuilder builder = new PolicyBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.PolicyItemsNested<A> addNewPolicyItem(){
            return new PolicyItemsNestedImpl();
    }

    public BaseKubernetesListFluent.PolicyItemsNested<A> addNewPolicyItemLike(Policy item){
            return new PolicyItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.PolicyItemsNested<A> setNewPolicyItemLike(int index,Policy item){
            return new PolicyItemsNestedImpl(index, item);
    }

    public A addToImageSignatureItems(int index,ImageSignature item){
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToImageSignatureItems(int index,ImageSignature item){
            ImageSignatureBuilder builder = new ImageSignatureBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToImageSignatureItems(ImageSignature... items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToImageSignatureItems(Collection<ImageSignature> items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromImageSignatureItems(ImageSignature... items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromImageSignatureItems(Collection<ImageSignature> items){
            for (ImageSignature item : items) {ImageSignatureBuilder builder = new ImageSignatureBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ImageSignatureItemsNested<A> addNewImageSignatureItem(){
            return new ImageSignatureItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ImageSignatureItemsNested<A> addNewImageSignatureItemLike(ImageSignature item){
            return new ImageSignatureItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ImageSignatureItemsNested<A> setNewImageSignatureItemLike(int index,ImageSignature item){
            return new ImageSignatureItemsNestedImpl(index, item);
    }

    public A addToBindingItems(int index,Binding item){
            BindingBuilder builder = new BindingBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToBindingItems(int index,Binding item){
            BindingBuilder builder = new BindingBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToBindingItems(Binding... items){
            for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToBindingItems(Collection<Binding> items){
            for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromBindingItems(Binding... items){
            for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromBindingItems(Collection<Binding> items){
            for (Binding item : items) {BindingBuilder builder = new BindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItem(){
            return new BindingItemsNestedImpl();
    }

    public BaseKubernetesListFluent.BindingItemsNested<A> addNewBindingItemLike(Binding item){
            return new BindingItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.BindingItemsNested<A> setNewBindingItemLike(int index,Binding item){
            return new BindingItemsNestedImpl(index, item);
    }

    public A addToResourceQuotaItems(int index,ResourceQuota item){
            ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToResourceQuotaItems(int index,ResourceQuota item){
            ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToResourceQuotaItems(ResourceQuota... items){
            for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToResourceQuotaItems(Collection<ResourceQuota> items){
            for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromResourceQuotaItems(ResourceQuota... items){
            for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromResourceQuotaItems(Collection<ResourceQuota> items){
            for (ResourceQuota item : items) {ResourceQuotaBuilder builder = new ResourceQuotaBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItem(){
            return new ResourceQuotaItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> addNewResourceQuotaItemLike(ResourceQuota item){
            return new ResourceQuotaItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ResourceQuotaItemsNested<A> setNewResourceQuotaItemLike(int index,ResourceQuota item){
            return new ResourceQuotaItemsNestedImpl(index, item);
    }

    public A addToSecretItems(int index,Secret item){
            SecretBuilder builder = new SecretBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToSecretItems(int index,Secret item){
            SecretBuilder builder = new SecretBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToSecretItems(Secret... items){
            for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToSecretItems(Collection<Secret> items){
            for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromSecretItems(Secret... items){
            for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromSecretItems(Collection<Secret> items){
            for (Secret item : items) {SecretBuilder builder = new SecretBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItem(){
            return new SecretItemsNestedImpl();
    }

    public BaseKubernetesListFluent.SecretItemsNested<A> addNewSecretItemLike(Secret item){
            return new SecretItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.SecretItemsNested<A> setNewSecretItemLike(int index,Secret item){
            return new SecretItemsNestedImpl(index, item);
    }

    public A addToBuildRequestItems(int index,BuildRequest item){
            BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToBuildRequestItems(int index,BuildRequest item){
            BuildRequestBuilder builder = new BuildRequestBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToBuildRequestItems(BuildRequest... items){
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToBuildRequestItems(Collection<BuildRequest> items){
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromBuildRequestItems(BuildRequest... items){
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromBuildRequestItems(Collection<BuildRequest> items){
            for (BuildRequest item : items) {BuildRequestBuilder builder = new BuildRequestBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.BuildRequestItemsNested<A> addNewBuildRequestItem(){
            return new BuildRequestItemsNestedImpl();
    }

    public BaseKubernetesListFluent.BuildRequestItemsNested<A> addNewBuildRequestItemLike(BuildRequest item){
            return new BuildRequestItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.BuildRequestItemsNested<A> setNewBuildRequestItemLike(int index,BuildRequest item){
            return new BuildRequestItemsNestedImpl(index, item);
    }

    public A addToClusterPolicyBindingItems(int index,ClusterPolicyBinding item){
            ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToClusterPolicyBindingItems(int index,ClusterPolicyBinding item){
            ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToClusterPolicyBindingItems(ClusterPolicyBinding... items){
            for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToClusterPolicyBindingItems(Collection<ClusterPolicyBinding> items){
            for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromClusterPolicyBindingItems(ClusterPolicyBinding... items){
            for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromClusterPolicyBindingItems(Collection<ClusterPolicyBinding> items){
            for (ClusterPolicyBinding item : items) {ClusterPolicyBindingBuilder builder = new ClusterPolicyBindingBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<A> addNewClusterPolicyBindingItem(){
            return new ClusterPolicyBindingItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<A> addNewClusterPolicyBindingItemLike(ClusterPolicyBinding item){
            return new ClusterPolicyBindingItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<A> setNewClusterPolicyBindingItemLike(int index,ClusterPolicyBinding item){
            return new ClusterPolicyBindingItemsNestedImpl(index, item);
    }

    public A addToNodeItems(int index,Node item){
            NodeBuilder builder = new NodeBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToNodeItems(int index,Node item){
            NodeBuilder builder = new NodeBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToNodeItems(Node... items){
            for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToNodeItems(Collection<Node> items){
            for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromNodeItems(Node... items){
            for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromNodeItems(Collection<Node> items){
            for (Node item : items) {NodeBuilder builder = new NodeBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItem(){
            return new NodeItemsNestedImpl();
    }

    public BaseKubernetesListFluent.NodeItemsNested<A> addNewNodeItemLike(Node item){
            return new NodeItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.NodeItemsNested<A> setNewNodeItemLike(int index,Node item){
            return new NodeItemsNestedImpl(index, item);
    }

    public A addToImageStreamItems(int index,ImageStream item){
            ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToImageStreamItems(int index,ImageStream item){
            ImageStreamBuilder builder = new ImageStreamBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToImageStreamItems(ImageStream... items){
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToImageStreamItems(Collection<ImageStream> items){
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromImageStreamItems(ImageStream... items){
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromImageStreamItems(Collection<ImageStream> items){
            for (ImageStream item : items) {ImageStreamBuilder builder = new ImageStreamBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ImageStreamItemsNested<A> addNewImageStreamItem(){
            return new ImageStreamItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ImageStreamItemsNested<A> addNewImageStreamItemLike(ImageStream item){
            return new ImageStreamItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ImageStreamItemsNested<A> setNewImageStreamItemLike(int index,ImageStream item){
            return new ImageStreamItemsNestedImpl(index, item);
    }

    public A addToStatefulSetItems(int index,StatefulSet item){
            StatefulSetBuilder builder = new StatefulSetBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToStatefulSetItems(int index,StatefulSet item){
            StatefulSetBuilder builder = new StatefulSetBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToStatefulSetItems(StatefulSet... items){
            for (StatefulSet item : items) {StatefulSetBuilder builder = new StatefulSetBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToStatefulSetItems(Collection<StatefulSet> items){
            for (StatefulSet item : items) {StatefulSetBuilder builder = new StatefulSetBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromStatefulSetItems(StatefulSet... items){
            for (StatefulSet item : items) {StatefulSetBuilder builder = new StatefulSetBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromStatefulSetItems(Collection<StatefulSet> items){
            for (StatefulSet item : items) {StatefulSetBuilder builder = new StatefulSetBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.StatefulSetItemsNested<A> addNewStatefulSetItem(){
            return new StatefulSetItemsNestedImpl();
    }

    public BaseKubernetesListFluent.StatefulSetItemsNested<A> addNewStatefulSetItemLike(StatefulSet item){
            return new StatefulSetItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.StatefulSetItemsNested<A> setNewStatefulSetItemLike(int index,StatefulSet item){
            return new StatefulSetItemsNestedImpl(index, item);
    }

    public A addToOAuthClientItems(int index,OAuthClient item){
            OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToOAuthClientItems(int index,OAuthClient item){
            OAuthClientBuilder builder = new OAuthClientBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToOAuthClientItems(OAuthClient... items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToOAuthClientItems(Collection<OAuthClient> items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromOAuthClientItems(OAuthClient... items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromOAuthClientItems(Collection<OAuthClient> items){
            for (OAuthClient item : items) {OAuthClientBuilder builder = new OAuthClientBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.OAuthClientItemsNested<A> addNewOAuthClientItem(){
            return new OAuthClientItemsNestedImpl();
    }

    public BaseKubernetesListFluent.OAuthClientItemsNested<A> addNewOAuthClientItemLike(OAuthClient item){
            return new OAuthClientItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.OAuthClientItemsNested<A> setNewOAuthClientItemLike(int index,OAuthClient item){
            return new OAuthClientItemsNestedImpl(index, item);
    }

    public A addToServiceAccountItems(int index,ServiceAccount item){
            ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToServiceAccountItems(int index,ServiceAccount item){
            ServiceAccountBuilder builder = new ServiceAccountBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToServiceAccountItems(ServiceAccount... items){
            for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToServiceAccountItems(Collection<ServiceAccount> items){
            for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromServiceAccountItems(ServiceAccount... items){
            for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromServiceAccountItems(Collection<ServiceAccount> items){
            for (ServiceAccount item : items) {ServiceAccountBuilder builder = new ServiceAccountBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItem(){
            return new ServiceAccountItemsNestedImpl();
    }

    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> addNewServiceAccountItemLike(ServiceAccount item){
            return new ServiceAccountItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.ServiceAccountItemsNested<A> setNewServiceAccountItemLike(int index,ServiceAccount item){
            return new ServiceAccountItemsNestedImpl(index, item);
    }

    public A addToIdentityItems(int index,Identity item){
            IdentityBuilder builder = new IdentityBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToIdentityItems(int index,Identity item){
            IdentityBuilder builder = new IdentityBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToIdentityItems(Identity... items){
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToIdentityItems(Collection<Identity> items){
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromIdentityItems(Identity... items){
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public A removeAllFromIdentityItems(Collection<Identity> items){
            for (Identity item : items) {IdentityBuilder builder = new IdentityBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public BaseKubernetesListFluent.IdentityItemsNested<A> addNewIdentityItem(){
            return new IdentityItemsNestedImpl();
    }

    public BaseKubernetesListFluent.IdentityItemsNested<A> addNewIdentityItemLike(Identity item){
            return new IdentityItemsNestedImpl(-1, item);
    }

    public BaseKubernetesListFluent.IdentityItemsNested<A> setNewIdentityItemLike(int index,Identity item){
            return new IdentityItemsNestedImpl(index, item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind!=null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ListMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata!=null;
    }

    public BaseKubernetesListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public BaseKubernetesListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public BaseKubernetesListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ListMetaBuilder().build());
    }

    public BaseKubernetesListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BaseKubernetesListFluentImpl that = (BaseKubernetesListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class LimitRangeItemsNestedImpl<N> extends LimitRangeFluentImpl<BaseKubernetesListFluent.LimitRangeItemsNested<N>> implements BaseKubernetesListFluent.LimitRangeItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LimitRangeBuilder builder;
        private final int index;
    
            LimitRangeItemsNestedImpl(int index,LimitRange item){
                    this.index = index;
                    this.builder = new LimitRangeBuilder(this, item);
            }
            LimitRangeItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new LimitRangeBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToLimitRangeItems(index, builder.build());
    }
    public N endLimitRangeItem(){
            return and();
    }

}
    public class JobItemsNestedImpl<N> extends JobFluentImpl<BaseKubernetesListFluent.JobItemsNested<N>> implements BaseKubernetesListFluent.JobItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JobBuilder builder;
        private final int index;
    
            JobItemsNestedImpl(int index,Job item){
                    this.index = index;
                    this.builder = new JobBuilder(this, item);
            }
            JobItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new JobBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToJobItems(index, builder.build());
    }
    public N endJobItem(){
            return and();
    }

}
    public class ThirdPartyResourceItemsNestedImpl<N> extends ThirdPartyResourceFluentImpl<BaseKubernetesListFluent.ThirdPartyResourceItemsNested<N>> implements BaseKubernetesListFluent.ThirdPartyResourceItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ThirdPartyResourceBuilder builder;
        private final int index;
    
            ThirdPartyResourceItemsNestedImpl(int index,ThirdPartyResource item){
                    this.index = index;
                    this.builder = new ThirdPartyResourceBuilder(this, item);
            }
            ThirdPartyResourceItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ThirdPartyResourceBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToThirdPartyResourceItems(index, builder.build());
    }
    public N endThirdPartyResourceItem(){
            return and();
    }

}
    public class ProjectItemsNestedImpl<N> extends ProjectFluentImpl<BaseKubernetesListFluent.ProjectItemsNested<N>> implements BaseKubernetesListFluent.ProjectItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProjectBuilder builder;
        private final int index;
    
            ProjectItemsNestedImpl(int index,Project item){
                    this.index = index;
                    this.builder = new ProjectBuilder(this, item);
            }
            ProjectItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ProjectBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToProjectItems(index, builder.build());
    }
    public N endProjectItem(){
            return and();
    }

}
    public class SecurityContextConstraintsItemsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<N>> implements BaseKubernetesListFluent.SecurityContextConstraintsItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecurityContextConstraintsBuilder builder;
        private final int index;
    
            SecurityContextConstraintsItemsNestedImpl(int index,SecurityContextConstraints item){
                    this.index = index;
                    this.builder = new SecurityContextConstraintsBuilder(this, item);
            }
            SecurityContextConstraintsItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new SecurityContextConstraintsBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToSecurityContextConstraintsItems(index, builder.build());
    }
    public N endSecurityContextConstraintsItem(){
            return and();
    }

}
    public class BuildConfigItemsNestedImpl<N> extends BuildConfigFluentImpl<BaseKubernetesListFluent.BuildConfigItemsNested<N>> implements BaseKubernetesListFluent.BuildConfigItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildConfigBuilder builder;
        private final int index;
    
            BuildConfigItemsNestedImpl(int index,BuildConfig item){
                    this.index = index;
                    this.builder = new BuildConfigBuilder(this, item);
            }
            BuildConfigItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new BuildConfigBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToBuildConfigItems(index, builder.build());
    }
    public N endBuildConfigItem(){
            return and();
    }

}
    public class RouteItemsNestedImpl<N> extends RouteFluentImpl<BaseKubernetesListFluent.RouteItemsNested<N>> implements BaseKubernetesListFluent.RouteItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RouteBuilder builder;
        private final int index;
    
            RouteItemsNestedImpl(int index,Route item){
                    this.index = index;
                    this.builder = new RouteBuilder(this, item);
            }
            RouteItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new RouteBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToRouteItems(index, builder.build());
    }
    public N endRouteItem(){
            return and();
    }

}
    public class OAuthAuthorizeTokenItemsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<N>> implements BaseKubernetesListFluent.OAuthAuthorizeTokenItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthAuthorizeTokenBuilder builder;
        private final int index;
    
            OAuthAuthorizeTokenItemsNestedImpl(int index,OAuthAuthorizeToken item){
                    this.index = index;
                    this.builder = new OAuthAuthorizeTokenBuilder(this, item);
            }
            OAuthAuthorizeTokenItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new OAuthAuthorizeTokenBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToOAuthAuthorizeTokenItems(index, builder.build());
    }
    public N endOAuthAuthorizeTokenItem(){
            return and();
    }

}
    public class NamespaceItemsNestedImpl<N> extends NamespaceFluentImpl<BaseKubernetesListFluent.NamespaceItemsNested<N>> implements BaseKubernetesListFluent.NamespaceItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NamespaceBuilder builder;
        private final int index;
    
            NamespaceItemsNestedImpl(int index,Namespace item){
                    this.index = index;
                    this.builder = new NamespaceBuilder(this, item);
            }
            NamespaceItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new NamespaceBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToNamespaceItems(index, builder.build());
    }
    public N endNamespaceItem(){
            return and();
    }

}
    public class ClusterRoleBindingItemsNestedImpl<N> extends ClusterRoleBindingFluentImpl<BaseKubernetesListFluent.ClusterRoleBindingItemsNested<N>> implements BaseKubernetesListFluent.ClusterRoleBindingItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBindingBuilder builder;
        private final int index;
    
            ClusterRoleBindingItemsNestedImpl(int index,ClusterRoleBinding item){
                    this.index = index;
                    this.builder = new ClusterRoleBindingBuilder(this, item);
            }
            ClusterRoleBindingItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ClusterRoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToClusterRoleBindingItems(index, builder.build());
    }
    public N endClusterRoleBindingItem(){
            return and();
    }

}
    public class ServiceItemsNestedImpl<N> extends ServiceFluentImpl<BaseKubernetesListFluent.ServiceItemsNested<N>> implements BaseKubernetesListFluent.ServiceItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServiceBuilder builder;
        private final int index;
    
            ServiceItemsNestedImpl(int index,Service item){
                    this.index = index;
                    this.builder = new ServiceBuilder(this, item);
            }
            ServiceItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ServiceBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToServiceItems(index, builder.build());
    }
    public N endServiceItem(){
            return and();
    }

}
    public class ReplicationControllerItemsNestedImpl<N> extends ReplicationControllerFluentImpl<BaseKubernetesListFluent.ReplicationControllerItemsNested<N>> implements BaseKubernetesListFluent.ReplicationControllerItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ReplicationControllerBuilder builder;
        private final int index;
    
            ReplicationControllerItemsNestedImpl(int index,ReplicationController item){
                    this.index = index;
                    this.builder = new ReplicationControllerBuilder(this, item);
            }
            ReplicationControllerItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ReplicationControllerBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToReplicationControllerItems(index, builder.build());
    }
    public N endReplicationControllerItem(){
            return and();
    }

}
    public class ProjectRequestItemsNestedImpl<N> extends ProjectRequestFluentImpl<BaseKubernetesListFluent.ProjectRequestItemsNested<N>> implements BaseKubernetesListFluent.ProjectRequestItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProjectRequestBuilder builder;
        private final int index;
    
            ProjectRequestItemsNestedImpl(int index,ProjectRequest item){
                    this.index = index;
                    this.builder = new ProjectRequestBuilder(this, item);
            }
            ProjectRequestItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ProjectRequestBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToProjectRequestItems(index, builder.build());
    }
    public N endProjectRequestItem(){
            return and();
    }

}
    public class TemplateItemsNestedImpl<N> extends TemplateFluentImpl<BaseKubernetesListFluent.TemplateItemsNested<N>> implements BaseKubernetesListFluent.TemplateItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TemplateBuilder builder;
        private final int index;
    
            TemplateItemsNestedImpl(int index,Template item){
                    this.index = index;
                    this.builder = new TemplateBuilder(this, item);
            }
            TemplateItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new TemplateBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToTemplateItems(index, builder.build());
    }
    public N endTemplateItem(){
            return and();
    }

}
    public class OAuthClientAuthorizationItemsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<N>> implements BaseKubernetesListFluent.OAuthClientAuthorizationItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthClientAuthorizationBuilder builder;
        private final int index;
    
            OAuthClientAuthorizationItemsNestedImpl(int index,OAuthClientAuthorization item){
                    this.index = index;
                    this.builder = new OAuthClientAuthorizationBuilder(this, item);
            }
            OAuthClientAuthorizationItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new OAuthClientAuthorizationBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToOAuthClientAuthorizationItems(index, builder.build());
    }
    public N endOAuthClientAuthorizationItem(){
            return and();
    }

}
    public class PolicyBindingItemsNestedImpl<N> extends PolicyBindingFluentImpl<BaseKubernetesListFluent.PolicyBindingItemsNested<N>> implements BaseKubernetesListFluent.PolicyBindingItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PolicyBindingBuilder builder;
        private final int index;
    
            PolicyBindingItemsNestedImpl(int index,PolicyBinding item){
                    this.index = index;
                    this.builder = new PolicyBindingBuilder(this, item);
            }
            PolicyBindingItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new PolicyBindingBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToPolicyBindingItems(index, builder.build());
    }
    public N endPolicyBindingItem(){
            return and();
    }

}
    public class ClusterRoleItemsNestedImpl<N> extends ClusterRoleFluentImpl<BaseKubernetesListFluent.ClusterRoleItemsNested<N>> implements BaseKubernetesListFluent.ClusterRoleItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterRoleBuilder builder;
        private final int index;
    
            ClusterRoleItemsNestedImpl(int index,ClusterRole item){
                    this.index = index;
                    this.builder = new ClusterRoleBuilder(this, item);
            }
            ClusterRoleItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ClusterRoleBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToClusterRoleItems(index, builder.build());
    }
    public N endClusterRoleItem(){
            return and();
    }

}
    public class HorizontalPodAutoscalerItemsNestedImpl<N> extends HorizontalPodAutoscalerFluentImpl<BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<N>> implements BaseKubernetesListFluent.HorizontalPodAutoscalerItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HorizontalPodAutoscalerBuilder builder;
        private final int index;
    
            HorizontalPodAutoscalerItemsNestedImpl(int index,HorizontalPodAutoscaler item){
                    this.index = index;
                    this.builder = new HorizontalPodAutoscalerBuilder(this, item);
            }
            HorizontalPodAutoscalerItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new HorizontalPodAutoscalerBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToHorizontalPodAutoscalerItems(index, builder.build());
    }
    public N endHorizontalPodAutoscalerItem(){
            return and();
    }

}
    public class ScaleItemsNestedImpl<N> extends ScaleFluentImpl<BaseKubernetesListFluent.ScaleItemsNested<N>> implements BaseKubernetesListFluent.ScaleItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ScaleBuilder builder;
        private final int index;
    
            ScaleItemsNestedImpl(int index,Scale item){
                    this.index = index;
                    this.builder = new ScaleBuilder(this, item);
            }
            ScaleItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ScaleBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToScaleItems(index, builder.build());
    }
    public N endScaleItem(){
            return and();
    }

}
    public class PodTemplateItemsNestedImpl<N> extends PodTemplateFluentImpl<BaseKubernetesListFluent.PodTemplateItemsNested<N>> implements BaseKubernetesListFluent.PodTemplateItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodTemplateBuilder builder;
        private final int index;
    
            PodTemplateItemsNestedImpl(int index,PodTemplate item){
                    this.index = index;
                    this.builder = new PodTemplateBuilder(this, item);
            }
            PodTemplateItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new PodTemplateBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToPodTemplateItems(index, builder.build());
    }
    public N endPodTemplateItem(){
            return and();
    }

}
    public class EventItemsNestedImpl<N> extends EventFluentImpl<BaseKubernetesListFluent.EventItemsNested<N>> implements BaseKubernetesListFluent.EventItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EventBuilder builder;
        private final int index;
    
            EventItemsNestedImpl(int index,Event item){
                    this.index = index;
                    this.builder = new EventBuilder(this, item);
            }
            EventItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new EventBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToEventItems(index, builder.build());
    }
    public N endEventItem(){
            return and();
    }

}
    public class IngressItemsNestedImpl<N> extends IngressFluentImpl<BaseKubernetesListFluent.IngressItemsNested<N>> implements BaseKubernetesListFluent.IngressItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IngressBuilder builder;
        private final int index;
    
            IngressItemsNestedImpl(int index,Ingress item){
                    this.index = index;
                    this.builder = new IngressBuilder(this, item);
            }
            IngressItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new IngressBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToIngressItems(index, builder.build());
    }
    public N endIngressItem(){
            return and();
    }

}
    public class OAuthAccessTokenItemsNestedImpl<N> extends OAuthAccessTokenFluentImpl<BaseKubernetesListFluent.OAuthAccessTokenItemsNested<N>> implements BaseKubernetesListFluent.OAuthAccessTokenItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthAccessTokenBuilder builder;
        private final int index;
    
            OAuthAccessTokenItemsNestedImpl(int index,OAuthAccessToken item){
                    this.index = index;
                    this.builder = new OAuthAccessTokenBuilder(this, item);
            }
            OAuthAccessTokenItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new OAuthAccessTokenBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToOAuthAccessTokenItems(index, builder.build());
    }
    public N endOAuthAccessTokenItem(){
            return and();
    }

}
    public class DeploymentConfigItemsNestedImpl<N> extends DeploymentConfigFluentImpl<BaseKubernetesListFluent.DeploymentConfigItemsNested<N>> implements BaseKubernetesListFluent.DeploymentConfigItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentConfigBuilder builder;
        private final int index;
    
            DeploymentConfigItemsNestedImpl(int index,DeploymentConfig item){
                    this.index = index;
                    this.builder = new DeploymentConfigBuilder(this, item);
            }
            DeploymentConfigItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new DeploymentConfigBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToDeploymentConfigItems(index, builder.build());
    }
    public N endDeploymentConfigItem(){
            return and();
    }

}
    public class RoleBindingItemsNestedImpl<N> extends RoleBindingFluentImpl<BaseKubernetesListFluent.RoleBindingItemsNested<N>> implements BaseKubernetesListFluent.RoleBindingItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBindingBuilder builder;
        private final int index;
    
            RoleBindingItemsNestedImpl(int index,RoleBinding item){
                    this.index = index;
                    this.builder = new RoleBindingBuilder(this, item);
            }
            RoleBindingItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new RoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToRoleBindingItems(index, builder.build());
    }
    public N endRoleBindingItem(){
            return and();
    }

}
    public class ImageItemsNestedImpl<N> extends ImageFluentImpl<BaseKubernetesListFluent.ImageItemsNested<N>> implements BaseKubernetesListFluent.ImageItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageBuilder builder;
        private final int index;
    
            ImageItemsNestedImpl(int index,Image item){
                    this.index = index;
                    this.builder = new ImageBuilder(this, item);
            }
            ImageItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ImageBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToImageItems(index, builder.build());
    }
    public N endImageItem(){
            return and();
    }

}
    public class PersistentVolumeItemsNestedImpl<N> extends PersistentVolumeFluentImpl<BaseKubernetesListFluent.PersistentVolumeItemsNested<N>> implements BaseKubernetesListFluent.PersistentVolumeItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentVolumeBuilder builder;
        private final int index;
    
            PersistentVolumeItemsNestedImpl(int index,PersistentVolume item){
                    this.index = index;
                    this.builder = new PersistentVolumeBuilder(this, item);
            }
            PersistentVolumeItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new PersistentVolumeBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToPersistentVolumeItems(index, builder.build());
    }
    public N endPersistentVolumeItem(){
            return and();
    }

}
    public class PersistentVolumeClaimItemsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>> implements BaseKubernetesListFluent.PersistentVolumeClaimItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PersistentVolumeClaimBuilder builder;
        private final int index;
    
            PersistentVolumeClaimItemsNestedImpl(int index,PersistentVolumeClaim item){
                    this.index = index;
                    this.builder = new PersistentVolumeClaimBuilder(this, item);
            }
            PersistentVolumeClaimItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new PersistentVolumeClaimBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToPersistentVolumeClaimItems(index, builder.build());
    }
    public N endPersistentVolumeClaimItem(){
            return and();
    }

}
    public class ReplicaSetItemsNestedImpl<N> extends ReplicaSetFluentImpl<BaseKubernetesListFluent.ReplicaSetItemsNested<N>> implements BaseKubernetesListFluent.ReplicaSetItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ReplicaSetBuilder builder;
        private final int index;
    
            ReplicaSetItemsNestedImpl(int index,ReplicaSet item){
                    this.index = index;
                    this.builder = new ReplicaSetBuilder(this, item);
            }
            ReplicaSetItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ReplicaSetBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToReplicaSetItems(index, builder.build());
    }
    public N endReplicaSetItem(){
            return and();
    }

}
    public class CronJobItemsNestedImpl<N> extends CronJobFluentImpl<BaseKubernetesListFluent.CronJobItemsNested<N>> implements BaseKubernetesListFluent.CronJobItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CronJobBuilder builder;
        private final int index;
    
            CronJobItemsNestedImpl(int index,CronJob item){
                    this.index = index;
                    this.builder = new CronJobBuilder(this, item);
            }
            CronJobItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new CronJobBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToCronJobItems(index, builder.build());
    }
    public N endCronJobItem(){
            return and();
    }

}
    public class RoleItemsNestedImpl<N> extends RoleFluentImpl<BaseKubernetesListFluent.RoleItemsNested<N>> implements BaseKubernetesListFluent.RoleItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBuilder builder;
        private final int index;
    
            RoleItemsNestedImpl(int index,Role item){
                    this.index = index;
                    this.builder = new RoleBuilder(this, item);
            }
            RoleItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new RoleBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToRoleItems(index, builder.build());
    }
    public N endRoleItem(){
            return and();
    }

}
    public class EndpointsItemsNestedImpl<N> extends EndpointsFluentImpl<BaseKubernetesListFluent.EndpointsItemsNested<N>> implements BaseKubernetesListFluent.EndpointsItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final EndpointsBuilder builder;
        private final int index;
    
            EndpointsItemsNestedImpl(int index,Endpoints item){
                    this.index = index;
                    this.builder = new EndpointsBuilder(this, item);
            }
            EndpointsItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new EndpointsBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToEndpointsItems(index, builder.build());
    }
    public N endEndpointsItem(){
            return and();
    }

}
    public class PodItemsNestedImpl<N> extends PodFluentImpl<BaseKubernetesListFluent.PodItemsNested<N>> implements BaseKubernetesListFluent.PodItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PodBuilder builder;
        private final int index;
    
            PodItemsNestedImpl(int index,Pod item){
                    this.index = index;
                    this.builder = new PodBuilder(this, item);
            }
            PodItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new PodBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToPodItems(index, builder.build());
    }
    public N endPodItem(){
            return and();
    }

}
    public class CustomResourceDefinitionItemsNestedImpl<N> extends CustomResourceDefinitionFluentImpl<BaseKubernetesListFluent.CustomResourceDefinitionItemsNested<N>> implements BaseKubernetesListFluent.CustomResourceDefinitionItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CustomResourceDefinitionBuilder builder;
        private final int index;
    
            CustomResourceDefinitionItemsNestedImpl(int index,CustomResourceDefinition item){
                    this.index = index;
                    this.builder = new CustomResourceDefinitionBuilder(this, item);
            }
            CustomResourceDefinitionItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new CustomResourceDefinitionBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToCustomResourceDefinitionItems(index, builder.build());
    }
    public N endCustomResourceDefinitionItem(){
            return and();
    }

}
    public class ClusterPolicyItemsNestedImpl<N> extends ClusterPolicyFluentImpl<BaseKubernetesListFluent.ClusterPolicyItemsNested<N>> implements BaseKubernetesListFluent.ClusterPolicyItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterPolicyBuilder builder;
        private final int index;
    
            ClusterPolicyItemsNestedImpl(int index,ClusterPolicy item){
                    this.index = index;
                    this.builder = new ClusterPolicyBuilder(this, item);
            }
            ClusterPolicyItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ClusterPolicyBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToClusterPolicyItems(index, builder.build());
    }
    public N endClusterPolicyItem(){
            return and();
    }

}
    public class DaemonSetItemsNestedImpl<N> extends DaemonSetFluentImpl<BaseKubernetesListFluent.DaemonSetItemsNested<N>> implements BaseKubernetesListFluent.DaemonSetItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DaemonSetBuilder builder;
        private final int index;
    
            DaemonSetItemsNestedImpl(int index,DaemonSet item){
                    this.index = index;
                    this.builder = new DaemonSetBuilder(this, item);
            }
            DaemonSetItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new DaemonSetBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToDaemonSetItems(index, builder.build());
    }
    public N endDaemonSetItem(){
            return and();
    }

}
    public class DeploymentItemsNestedImpl<N> extends DeploymentFluentImpl<BaseKubernetesListFluent.DeploymentItemsNested<N>> implements BaseKubernetesListFluent.DeploymentItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final DeploymentBuilder builder;
        private final int index;
    
            DeploymentItemsNestedImpl(int index,Deployment item){
                    this.index = index;
                    this.builder = new DeploymentBuilder(this, item);
            }
            DeploymentItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new DeploymentBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToDeploymentItems(index, builder.build());
    }
    public N endDeploymentItem(){
            return and();
    }

}
    public class UserItemsNestedImpl<N> extends UserFluentImpl<BaseKubernetesListFluent.UserItemsNested<N>> implements BaseKubernetesListFluent.UserItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final UserBuilder builder;
        private final int index;
    
            UserItemsNestedImpl(int index,User item){
                    this.index = index;
                    this.builder = new UserBuilder(this, item);
            }
            UserItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new UserBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToUserItems(index, builder.build());
    }
    public N endUserItem(){
            return and();
    }

}
    public class ComponentStatusItemsNestedImpl<N> extends ComponentStatusFluentImpl<BaseKubernetesListFluent.ComponentStatusItemsNested<N>> implements BaseKubernetesListFluent.ComponentStatusItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ComponentStatusBuilder builder;
        private final int index;
    
            ComponentStatusItemsNestedImpl(int index,ComponentStatus item){
                    this.index = index;
                    this.builder = new ComponentStatusBuilder(this, item);
            }
            ComponentStatusItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ComponentStatusBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToComponentStatusItems(index, builder.build());
    }
    public N endComponentStatusItem(){
            return and();
    }

}
    public class BuildItemsNestedImpl<N> extends BuildFluentImpl<BaseKubernetesListFluent.BuildItemsNested<N>> implements BaseKubernetesListFluent.BuildItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildBuilder builder;
        private final int index;
    
            BuildItemsNestedImpl(int index,Build item){
                    this.index = index;
                    this.builder = new BuildBuilder(this, item);
            }
            BuildItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new BuildBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToBuildItems(index, builder.build());
    }
    public N endBuildItem(){
            return and();
    }

}
    public class RoleBindingRestrictionItemsNestedImpl<N> extends RoleBindingRestrictionFluentImpl<BaseKubernetesListFluent.RoleBindingRestrictionItemsNested<N>> implements BaseKubernetesListFluent.RoleBindingRestrictionItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBindingRestrictionBuilder builder;
        private final int index;
    
            RoleBindingRestrictionItemsNestedImpl(int index,RoleBindingRestriction item){
                    this.index = index;
                    this.builder = new RoleBindingRestrictionBuilder(this, item);
            }
            RoleBindingRestrictionItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new RoleBindingRestrictionBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToRoleBindingRestrictionItems(index, builder.build());
    }
    public N endRoleBindingRestrictionItem(){
            return and();
    }

}
    public class ImageStreamTagItemsNestedImpl<N> extends ImageStreamTagFluentImpl<BaseKubernetesListFluent.ImageStreamTagItemsNested<N>> implements BaseKubernetesListFluent.ImageStreamTagItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamTagBuilder builder;
        private final int index;
    
            ImageStreamTagItemsNestedImpl(int index,ImageStreamTag item){
                    this.index = index;
                    this.builder = new ImageStreamTagBuilder(this, item);
            }
            ImageStreamTagItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ImageStreamTagBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToImageStreamTagItems(index, builder.build());
    }
    public N endImageStreamTagItem(){
            return and();
    }

}
    public class GroupItemsNestedImpl<N> extends GroupFluentImpl<BaseKubernetesListFluent.GroupItemsNested<N>> implements BaseKubernetesListFluent.GroupItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GroupBuilder builder;
        private final int index;
    
            GroupItemsNestedImpl(int index,Group item){
                    this.index = index;
                    this.builder = new GroupBuilder(this, item);
            }
            GroupItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new GroupBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToGroupItems(index, builder.build());
    }
    public N endGroupItem(){
            return and();
    }

}
    public class PolicyItemsNestedImpl<N> extends PolicyFluentImpl<BaseKubernetesListFluent.PolicyItemsNested<N>> implements BaseKubernetesListFluent.PolicyItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PolicyBuilder builder;
        private final int index;
    
            PolicyItemsNestedImpl(int index,Policy item){
                    this.index = index;
                    this.builder = new PolicyBuilder(this, item);
            }
            PolicyItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new PolicyBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToPolicyItems(index, builder.build());
    }
    public N endPolicyItem(){
            return and();
    }

}
    public class ImageSignatureItemsNestedImpl<N> extends ImageSignatureFluentImpl<BaseKubernetesListFluent.ImageSignatureItemsNested<N>> implements BaseKubernetesListFluent.ImageSignatureItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageSignatureBuilder builder;
        private final int index;
    
            ImageSignatureItemsNestedImpl(int index,ImageSignature item){
                    this.index = index;
                    this.builder = new ImageSignatureBuilder(this, item);
            }
            ImageSignatureItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ImageSignatureBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToImageSignatureItems(index, builder.build());
    }
    public N endImageSignatureItem(){
            return and();
    }

}
    public class BindingItemsNestedImpl<N> extends BindingFluentImpl<BaseKubernetesListFluent.BindingItemsNested<N>> implements BaseKubernetesListFluent.BindingItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BindingBuilder builder;
        private final int index;
    
            BindingItemsNestedImpl(int index,Binding item){
                    this.index = index;
                    this.builder = new BindingBuilder(this, item);
            }
            BindingItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new BindingBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToBindingItems(index, builder.build());
    }
    public N endBindingItem(){
            return and();
    }

}
    public class ResourceQuotaItemsNestedImpl<N> extends ResourceQuotaFluentImpl<BaseKubernetesListFluent.ResourceQuotaItemsNested<N>> implements BaseKubernetesListFluent.ResourceQuotaItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ResourceQuotaBuilder builder;
        private final int index;
    
            ResourceQuotaItemsNestedImpl(int index,ResourceQuota item){
                    this.index = index;
                    this.builder = new ResourceQuotaBuilder(this, item);
            }
            ResourceQuotaItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ResourceQuotaBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToResourceQuotaItems(index, builder.build());
    }
    public N endResourceQuotaItem(){
            return and();
    }

}
    public class SecretItemsNestedImpl<N> extends SecretFluentImpl<BaseKubernetesListFluent.SecretItemsNested<N>> implements BaseKubernetesListFluent.SecretItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SecretBuilder builder;
        private final int index;
    
            SecretItemsNestedImpl(int index,Secret item){
                    this.index = index;
                    this.builder = new SecretBuilder(this, item);
            }
            SecretItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new SecretBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToSecretItems(index, builder.build());
    }
    public N endSecretItem(){
            return and();
    }

}
    public class BuildRequestItemsNestedImpl<N> extends BuildRequestFluentImpl<BaseKubernetesListFluent.BuildRequestItemsNested<N>> implements BaseKubernetesListFluent.BuildRequestItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final BuildRequestBuilder builder;
        private final int index;
    
            BuildRequestItemsNestedImpl(int index,BuildRequest item){
                    this.index = index;
                    this.builder = new BuildRequestBuilder(this, item);
            }
            BuildRequestItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new BuildRequestBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToBuildRequestItems(index, builder.build());
    }
    public N endBuildRequestItem(){
            return and();
    }

}
    public class ClusterPolicyBindingItemsNestedImpl<N> extends ClusterPolicyBindingFluentImpl<BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<N>> implements BaseKubernetesListFluent.ClusterPolicyBindingItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ClusterPolicyBindingBuilder builder;
        private final int index;
    
            ClusterPolicyBindingItemsNestedImpl(int index,ClusterPolicyBinding item){
                    this.index = index;
                    this.builder = new ClusterPolicyBindingBuilder(this, item);
            }
            ClusterPolicyBindingItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ClusterPolicyBindingBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToClusterPolicyBindingItems(index, builder.build());
    }
    public N endClusterPolicyBindingItem(){
            return and();
    }

}
    public class NodeItemsNestedImpl<N> extends NodeFluentImpl<BaseKubernetesListFluent.NodeItemsNested<N>> implements BaseKubernetesListFluent.NodeItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NodeBuilder builder;
        private final int index;
    
            NodeItemsNestedImpl(int index,Node item){
                    this.index = index;
                    this.builder = new NodeBuilder(this, item);
            }
            NodeItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new NodeBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToNodeItems(index, builder.build());
    }
    public N endNodeItem(){
            return and();
    }

}
    public class ImageStreamItemsNestedImpl<N> extends ImageStreamFluentImpl<BaseKubernetesListFluent.ImageStreamItemsNested<N>> implements BaseKubernetesListFluent.ImageStreamItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ImageStreamBuilder builder;
        private final int index;
    
            ImageStreamItemsNestedImpl(int index,ImageStream item){
                    this.index = index;
                    this.builder = new ImageStreamBuilder(this, item);
            }
            ImageStreamItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ImageStreamBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToImageStreamItems(index, builder.build());
    }
    public N endImageStreamItem(){
            return and();
    }

}
    public class StatefulSetItemsNestedImpl<N> extends StatefulSetFluentImpl<BaseKubernetesListFluent.StatefulSetItemsNested<N>> implements BaseKubernetesListFluent.StatefulSetItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final StatefulSetBuilder builder;
        private final int index;
    
            StatefulSetItemsNestedImpl(int index,StatefulSet item){
                    this.index = index;
                    this.builder = new StatefulSetBuilder(this, item);
            }
            StatefulSetItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new StatefulSetBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToStatefulSetItems(index, builder.build());
    }
    public N endStatefulSetItem(){
            return and();
    }

}
    public class OAuthClientItemsNestedImpl<N> extends OAuthClientFluentImpl<BaseKubernetesListFluent.OAuthClientItemsNested<N>> implements BaseKubernetesListFluent.OAuthClientItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final OAuthClientBuilder builder;
        private final int index;
    
            OAuthClientItemsNestedImpl(int index,OAuthClient item){
                    this.index = index;
                    this.builder = new OAuthClientBuilder(this, item);
            }
            OAuthClientItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new OAuthClientBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToOAuthClientItems(index, builder.build());
    }
    public N endOAuthClientItem(){
            return and();
    }

}
    public class ServiceAccountItemsNestedImpl<N> extends ServiceAccountFluentImpl<BaseKubernetesListFluent.ServiceAccountItemsNested<N>> implements BaseKubernetesListFluent.ServiceAccountItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ServiceAccountBuilder builder;
        private final int index;
    
            ServiceAccountItemsNestedImpl(int index,ServiceAccount item){
                    this.index = index;
                    this.builder = new ServiceAccountBuilder(this, item);
            }
            ServiceAccountItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new ServiceAccountBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToServiceAccountItems(index, builder.build());
    }
    public N endServiceAccountItem(){
            return and();
    }

}
    public class IdentityItemsNestedImpl<N> extends IdentityFluentImpl<BaseKubernetesListFluent.IdentityItemsNested<N>> implements BaseKubernetesListFluent.IdentityItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IdentityBuilder builder;
        private final int index;
    
            IdentityItemsNestedImpl(int index,Identity item){
                    this.index = index;
                    this.builder = new IdentityBuilder(this, item);
            }
            IdentityItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new IdentityBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.setToIdentityItems(index, builder.build());
    }
    public N endIdentityItem(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<BaseKubernetesListFluent.MetadataNested<N>> implements BaseKubernetesListFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
    
    public N and(){
            return (N) BaseKubernetesListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
