package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;

public class PersistentVolumeSpecFluentImpl<A extends PersistentVolumeSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PersistentVolumeSpecFluent<A>{

    private List<String> accessModes = new ArrayList<String>();
    private AWSElasticBlockStoreVolumeSourceBuilder awsElasticBlockStore;
    private AzureDiskVolumeSourceBuilder azureDisk;
    private AzureFileVolumeSourceBuilder azureFile;
    private Map<String,Quantity> capacity = new LinkedHashMap<String,Quantity>();
    private CephFSVolumeSourceBuilder cephfs;
    private CinderVolumeSourceBuilder cinder;
    private ObjectReferenceBuilder claimRef;
    private FCVolumeSourceBuilder fc;
    private FlexVolumeSourceBuilder flexVolume;
    private FlockerVolumeSourceBuilder flocker;
    private GCEPersistentDiskVolumeSourceBuilder gcePersistentDisk;
    private GlusterfsVolumeSourceBuilder glusterfs;
    private HostPathVolumeSourceBuilder hostPath;
    private ISCSIVolumeSourceBuilder iscsi;
    private NFSVolumeSourceBuilder nfs;
    private String persistentVolumeReclaimPolicy;
    private PhotonPersistentDiskVolumeSourceBuilder photonPersistentDisk;
    private QuobyteVolumeSourceBuilder quobyte;
    private RBDVolumeSourceBuilder rbd;
    private VsphereVirtualDiskVolumeSourceBuilder vsphereVolume;

    public PersistentVolumeSpecFluentImpl(){
    }
    public PersistentVolumeSpecFluentImpl(PersistentVolumeSpec instance){
            this.withAccessModes(instance.getAccessModes()); 
            this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); 
            this.withAzureDisk(instance.getAzureDisk()); 
            this.withAzureFile(instance.getAzureFile()); 
            this.withCapacity(instance.getCapacity()); 
            this.withCephfs(instance.getCephfs()); 
            this.withCinder(instance.getCinder()); 
            this.withClaimRef(instance.getClaimRef()); 
            this.withFc(instance.getFc()); 
            this.withFlexVolume(instance.getFlexVolume()); 
            this.withFlocker(instance.getFlocker()); 
            this.withGcePersistentDisk(instance.getGcePersistentDisk()); 
            this.withGlusterfs(instance.getGlusterfs()); 
            this.withHostPath(instance.getHostPath()); 
            this.withIscsi(instance.getIscsi()); 
            this.withNfs(instance.getNfs()); 
            this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy()); 
            this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk()); 
            this.withQuobyte(instance.getQuobyte()); 
            this.withRbd(instance.getRbd()); 
            this.withVsphereVolume(instance.getVsphereVolume()); 
    }

    public A addToAccessModes(int index,String item){
            this.accessModes.add(index, item); return (A)this;
    }

    public A setToAccessModes(int index,String item){
            this.accessModes.set(index, item); return (A)this;
    }

    public A addToAccessModes(String... items){
            for (String item : items) {this.accessModes.add(item);} return (A)this;
    }

    public A addAllToAccessModes(Collection<String> items){
            for (String item : items) {this.accessModes.add(item);} return (A)this;
    }

    public A removeFromAccessModes(String... items){
            for (String item : items) {this.accessModes.remove(item);} return (A)this;
    }

    public A removeAllFromAccessModes(Collection<String> items){
            for (String item : items) {this.accessModes.remove(item);} return (A)this;
    }

    public List<String> getAccessModes(){
            return this.accessModes;
    }

    public String getAccessMode(int index){
            return this.accessModes.get(index);
    }

    public String getFirstAccessMode(){
            return this.accessModes.get(0);
    }

    public String getLastAccessMode(){
            return this.accessModes.get(accessModes.size() - 1);
    }

    public String getMatchingAccessMode(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: accessModes) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withAccessModes(List<String> accessModes){
            this.accessModes.clear();
            if (accessModes != null) {for (String item : accessModes){this.addToAccessModes(item);}} return (A) this;
    }

    public A withAccessModes(String... accessModes){
            this.accessModes.clear(); if (accessModes != null) {for (String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
    }

    public Boolean hasAccessModes(){
            return accessModes!= null && !accessModes.isEmpty();
    }

    
/**
 * This method has been deprecated, please use method buildAwsElasticBlockStore instead.
 */
@Deprecated public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore(){
            return this.awsElasticBlockStore!=null?this.awsElasticBlockStore.build():null;
    }

    public AWSElasticBlockStoreVolumeSource buildAwsElasticBlockStore(){
            return this.awsElasticBlockStore!=null?this.awsElasticBlockStore.build():null;
    }

    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore){
            _visitables.remove(this.awsElasticBlockStore);
            if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.add(this.awsElasticBlockStore);} return (A) this;
    }

    public Boolean hasAwsElasticBlockStore(){
            return this.awsElasticBlockStore!=null;
    }

    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore(){
            return new AwsElasticBlockStoreNestedImpl();
    }

    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item){
            return new AwsElasticBlockStoreNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore(){
            return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore());
    }

    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore(){
            return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore() != null ? getAwsElasticBlockStore(): new AWSElasticBlockStoreVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item){
            return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore() != null ? getAwsElasticBlockStore(): item);
    }

    public A withNewAwsElasticBlockStore(String fsType,Integer partition,Boolean readOnly,String volumeID){
            return (A)withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
    }

    
/**
 * This method has been deprecated, please use method buildAzureDisk instead.
 */
@Deprecated public AzureDiskVolumeSource getAzureDisk(){
            return this.azureDisk!=null?this.azureDisk.build():null;
    }

    public AzureDiskVolumeSource buildAzureDisk(){
            return this.azureDisk!=null?this.azureDisk.build():null;
    }

    public A withAzureDisk(AzureDiskVolumeSource azureDisk){
            _visitables.remove(this.azureDisk);
            if (azureDisk!=null){ this.azureDisk= new AzureDiskVolumeSourceBuilder(azureDisk); _visitables.add(this.azureDisk);} return (A) this;
    }

    public Boolean hasAzureDisk(){
            return this.azureDisk!=null;
    }

    public PersistentVolumeSpecFluent.AzureDiskNested<A> withNewAzureDisk(){
            return new AzureDiskNestedImpl();
    }

    public PersistentVolumeSpecFluent.AzureDiskNested<A> withNewAzureDiskLike(AzureDiskVolumeSource item){
            return new AzureDiskNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.AzureDiskNested<A> editAzureDisk(){
            return withNewAzureDiskLike(getAzureDisk());
    }

    public PersistentVolumeSpecFluent.AzureDiskNested<A> editOrNewAzureDisk(){
            return withNewAzureDiskLike(getAzureDisk() != null ? getAzureDisk(): new AzureDiskVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.AzureDiskNested<A> editOrNewAzureDiskLike(AzureDiskVolumeSource item){
            return withNewAzureDiskLike(getAzureDisk() != null ? getAzureDisk(): item);
    }

    public A withNewAzureDisk(String cachingMode,String diskName,String diskURI,String fsType,Boolean readOnly){
            return (A)withAzureDisk(new AzureDiskVolumeSource(cachingMode, diskName, diskURI, fsType, readOnly));
    }

    
/**
 * This method has been deprecated, please use method buildAzureFile instead.
 */
@Deprecated public AzureFileVolumeSource getAzureFile(){
            return this.azureFile!=null?this.azureFile.build():null;
    }

    public AzureFileVolumeSource buildAzureFile(){
            return this.azureFile!=null?this.azureFile.build():null;
    }

    public A withAzureFile(AzureFileVolumeSource azureFile){
            _visitables.remove(this.azureFile);
            if (azureFile!=null){ this.azureFile= new AzureFileVolumeSourceBuilder(azureFile); _visitables.add(this.azureFile);} return (A) this;
    }

    public Boolean hasAzureFile(){
            return this.azureFile!=null;
    }

    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFile(){
            return new AzureFileNestedImpl();
    }

    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item){
            return new AzureFileNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.AzureFileNested<A> editAzureFile(){
            return withNewAzureFileLike(getAzureFile());
    }

    public PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFile(){
            return withNewAzureFileLike(getAzureFile() != null ? getAzureFile(): new AzureFileVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.AzureFileNested<A> editOrNewAzureFileLike(AzureFileVolumeSource item){
            return withNewAzureFileLike(getAzureFile() != null ? getAzureFile(): item);
    }

    public A withNewAzureFile(Boolean readOnly,String secretName,String shareName){
            return (A)withAzureFile(new AzureFileVolumeSource(readOnly, secretName, shareName));
    }

    public A addToCapacity(String key,Quantity value){
            if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
    }

    public A addToCapacity(Map<String,Quantity> map){
            if(map != null) { this.capacity.putAll(map);} return (A)this;
    }

    public A removeFromCapacity(String key){
            if(key != null) {this.capacity.remove(key);} return (A)this;
    }

    public A removeFromCapacity(Map<String,Quantity> map){
            if(map != null) { for(Object key : map.keySet()) {this.capacity.remove(key);}} return (A)this;
    }

    public Map<String,Quantity> getCapacity(){
            return this.capacity;
    }

    public A withCapacity(Map<String,Quantity> capacity){
            this.capacity.clear();
            if (capacity != null) {this.capacity.putAll(capacity);} return (A) this;
    }

    public Boolean hasCapacity(){
            return this.capacity!=null;
    }

    
/**
 * This method has been deprecated, please use method buildCephfs instead.
 */
@Deprecated public CephFSVolumeSource getCephfs(){
            return this.cephfs!=null?this.cephfs.build():null;
    }

    public CephFSVolumeSource buildCephfs(){
            return this.cephfs!=null?this.cephfs.build():null;
    }

    public A withCephfs(CephFSVolumeSource cephfs){
            _visitables.remove(this.cephfs);
            if (cephfs!=null){ this.cephfs= new CephFSVolumeSourceBuilder(cephfs); _visitables.add(this.cephfs);} return (A) this;
    }

    public Boolean hasCephfs(){
            return this.cephfs!=null;
    }

    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfs(){
            return new CephfsNestedImpl();
    }

    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item){
            return new CephfsNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.CephfsNested<A> editCephfs(){
            return withNewCephfsLike(getCephfs());
    }

    public PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfs(){
            return withNewCephfsLike(getCephfs() != null ? getCephfs(): new CephFSVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.CephfsNested<A> editOrNewCephfsLike(CephFSVolumeSource item){
            return withNewCephfsLike(getCephfs() != null ? getCephfs(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCinder instead.
 */
@Deprecated public CinderVolumeSource getCinder(){
            return this.cinder!=null?this.cinder.build():null;
    }

    public CinderVolumeSource buildCinder(){
            return this.cinder!=null?this.cinder.build():null;
    }

    public A withCinder(CinderVolumeSource cinder){
            _visitables.remove(this.cinder);
            if (cinder!=null){ this.cinder= new CinderVolumeSourceBuilder(cinder); _visitables.add(this.cinder);} return (A) this;
    }

    public Boolean hasCinder(){
            return this.cinder!=null;
    }

    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinder(){
            return new CinderNestedImpl();
    }

    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item){
            return new CinderNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.CinderNested<A> editCinder(){
            return withNewCinderLike(getCinder());
    }

    public PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinder(){
            return withNewCinderLike(getCinder() != null ? getCinder(): new CinderVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.CinderNested<A> editOrNewCinderLike(CinderVolumeSource item){
            return withNewCinderLike(getCinder() != null ? getCinder(): item);
    }

    public A withNewCinder(String fsType,Boolean readOnly,String volumeID){
            return (A)withCinder(new CinderVolumeSource(fsType, readOnly, volumeID));
    }

    
/**
 * This method has been deprecated, please use method buildClaimRef instead.
 */
@Deprecated public ObjectReference getClaimRef(){
            return this.claimRef!=null?this.claimRef.build():null;
    }

    public ObjectReference buildClaimRef(){
            return this.claimRef!=null?this.claimRef.build():null;
    }

    public A withClaimRef(ObjectReference claimRef){
            _visitables.remove(this.claimRef);
            if (claimRef!=null){ this.claimRef= new ObjectReferenceBuilder(claimRef); _visitables.add(this.claimRef);} return (A) this;
    }

    public Boolean hasClaimRef(){
            return this.claimRef!=null;
    }

    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRef(){
            return new ClaimRefNestedImpl();
    }

    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRefLike(ObjectReference item){
            return new ClaimRefNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.ClaimRefNested<A> editClaimRef(){
            return withNewClaimRefLike(getClaimRef());
    }

    public PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRef(){
            return withNewClaimRefLike(getClaimRef() != null ? getClaimRef(): new ObjectReferenceBuilder().build());
    }

    public PersistentVolumeSpecFluent.ClaimRefNested<A> editOrNewClaimRefLike(ObjectReference item){
            return withNewClaimRefLike(getClaimRef() != null ? getClaimRef(): item);
    }

    
/**
 * This method has been deprecated, please use method buildFc instead.
 */
@Deprecated public FCVolumeSource getFc(){
            return this.fc!=null?this.fc.build():null;
    }

    public FCVolumeSource buildFc(){
            return this.fc!=null?this.fc.build():null;
    }

    public A withFc(FCVolumeSource fc){
            _visitables.remove(this.fc);
            if (fc!=null){ this.fc= new FCVolumeSourceBuilder(fc); _visitables.add(this.fc);} return (A) this;
    }

    public Boolean hasFc(){
            return this.fc!=null;
    }

    public PersistentVolumeSpecFluent.FcNested<A> withNewFc(){
            return new FcNestedImpl();
    }

    public PersistentVolumeSpecFluent.FcNested<A> withNewFcLike(FCVolumeSource item){
            return new FcNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.FcNested<A> editFc(){
            return withNewFcLike(getFc());
    }

    public PersistentVolumeSpecFluent.FcNested<A> editOrNewFc(){
            return withNewFcLike(getFc() != null ? getFc(): new FCVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.FcNested<A> editOrNewFcLike(FCVolumeSource item){
            return withNewFcLike(getFc() != null ? getFc(): item);
    }

    
/**
 * This method has been deprecated, please use method buildFlexVolume instead.
 */
@Deprecated public FlexVolumeSource getFlexVolume(){
            return this.flexVolume!=null?this.flexVolume.build():null;
    }

    public FlexVolumeSource buildFlexVolume(){
            return this.flexVolume!=null?this.flexVolume.build():null;
    }

    public A withFlexVolume(FlexVolumeSource flexVolume){
            _visitables.remove(this.flexVolume);
            if (flexVolume!=null){ this.flexVolume= new FlexVolumeSourceBuilder(flexVolume); _visitables.add(this.flexVolume);} return (A) this;
    }

    public Boolean hasFlexVolume(){
            return this.flexVolume!=null;
    }

    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolume(){
            return new FlexVolumeNestedImpl();
    }

    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item){
            return new FlexVolumeNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editFlexVolume(){
            return withNewFlexVolumeLike(getFlexVolume());
    }

    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolume(){
            return withNewFlexVolumeLike(getFlexVolume() != null ? getFlexVolume(): new FlexVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editOrNewFlexVolumeLike(FlexVolumeSource item){
            return withNewFlexVolumeLike(getFlexVolume() != null ? getFlexVolume(): item);
    }

    
/**
 * This method has been deprecated, please use method buildFlocker instead.
 */
@Deprecated public FlockerVolumeSource getFlocker(){
            return this.flocker!=null?this.flocker.build():null;
    }

    public FlockerVolumeSource buildFlocker(){
            return this.flocker!=null?this.flocker.build():null;
    }

    public A withFlocker(FlockerVolumeSource flocker){
            _visitables.remove(this.flocker);
            if (flocker!=null){ this.flocker= new FlockerVolumeSourceBuilder(flocker); _visitables.add(this.flocker);} return (A) this;
    }

    public Boolean hasFlocker(){
            return this.flocker!=null;
    }

    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlocker(){
            return new FlockerNestedImpl();
    }

    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item){
            return new FlockerNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.FlockerNested<A> editFlocker(){
            return withNewFlockerLike(getFlocker());
    }

    public PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlocker(){
            return withNewFlockerLike(getFlocker() != null ? getFlocker(): new FlockerVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.FlockerNested<A> editOrNewFlockerLike(FlockerVolumeSource item){
            return withNewFlockerLike(getFlocker() != null ? getFlocker(): item);
    }

    public A withNewFlocker(String datasetName,String datasetUUID){
            return (A)withFlocker(new FlockerVolumeSource(datasetName, datasetUUID));
    }

    
/**
 * This method has been deprecated, please use method buildGcePersistentDisk instead.
 */
@Deprecated public GCEPersistentDiskVolumeSource getGcePersistentDisk(){
            return this.gcePersistentDisk!=null?this.gcePersistentDisk.build():null;
    }

    public GCEPersistentDiskVolumeSource buildGcePersistentDisk(){
            return this.gcePersistentDisk!=null?this.gcePersistentDisk.build():null;
    }

    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk){
            _visitables.remove(this.gcePersistentDisk);
            if (gcePersistentDisk!=null){ this.gcePersistentDisk= new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.add(this.gcePersistentDisk);} return (A) this;
    }

    public Boolean hasGcePersistentDisk(){
            return this.gcePersistentDisk!=null;
    }

    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk(){
            return new GcePersistentDiskNestedImpl();
    }

    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item){
            return new GcePersistentDiskNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editGcePersistentDisk(){
            return withNewGcePersistentDiskLike(getGcePersistentDisk());
    }

    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDisk(){
            return withNewGcePersistentDiskLike(getGcePersistentDisk() != null ? getGcePersistentDisk(): new GCEPersistentDiskVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item){
            return withNewGcePersistentDiskLike(getGcePersistentDisk() != null ? getGcePersistentDisk(): item);
    }

    public A withNewGcePersistentDisk(String fsType,Integer partition,String pdName,Boolean readOnly){
            return (A)withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
    }

    
/**
 * This method has been deprecated, please use method buildGlusterfs instead.
 */
@Deprecated public GlusterfsVolumeSource getGlusterfs(){
            return this.glusterfs!=null?this.glusterfs.build():null;
    }

    public GlusterfsVolumeSource buildGlusterfs(){
            return this.glusterfs!=null?this.glusterfs.build():null;
    }

    public A withGlusterfs(GlusterfsVolumeSource glusterfs){
            _visitables.remove(this.glusterfs);
            if (glusterfs!=null){ this.glusterfs= new GlusterfsVolumeSourceBuilder(glusterfs); _visitables.add(this.glusterfs);} return (A) this;
    }

    public Boolean hasGlusterfs(){
            return this.glusterfs!=null;
    }

    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfs(){
            return new GlusterfsNestedImpl();
    }

    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item){
            return new GlusterfsNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.GlusterfsNested<A> editGlusterfs(){
            return withNewGlusterfsLike(getGlusterfs());
    }

    public PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfs(){
            return withNewGlusterfsLike(getGlusterfs() != null ? getGlusterfs(): new GlusterfsVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.GlusterfsNested<A> editOrNewGlusterfsLike(GlusterfsVolumeSource item){
            return withNewGlusterfsLike(getGlusterfs() != null ? getGlusterfs(): item);
    }

    public A withNewGlusterfs(String endpoints,String path,Boolean readOnly){
            return (A)withGlusterfs(new GlusterfsVolumeSource(endpoints, path, readOnly));
    }

    
/**
 * This method has been deprecated, please use method buildHostPath instead.
 */
@Deprecated public HostPathVolumeSource getHostPath(){
            return this.hostPath!=null?this.hostPath.build():null;
    }

    public HostPathVolumeSource buildHostPath(){
            return this.hostPath!=null?this.hostPath.build():null;
    }

    public A withHostPath(HostPathVolumeSource hostPath){
            _visitables.remove(this.hostPath);
            if (hostPath!=null){ this.hostPath= new HostPathVolumeSourceBuilder(hostPath); _visitables.add(this.hostPath);} return (A) this;
    }

    public Boolean hasHostPath(){
            return this.hostPath!=null;
    }

    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPath(){
            return new HostPathNestedImpl();
    }

    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item){
            return new HostPathNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.HostPathNested<A> editHostPath(){
            return withNewHostPathLike(getHostPath());
    }

    public PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPath(){
            return withNewHostPathLike(getHostPath() != null ? getHostPath(): new HostPathVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.HostPathNested<A> editOrNewHostPathLike(HostPathVolumeSource item){
            return withNewHostPathLike(getHostPath() != null ? getHostPath(): item);
    }

    public A withNewHostPath(String path){
            return (A)withHostPath(new HostPathVolumeSource(path));
    }

    
/**
 * This method has been deprecated, please use method buildIscsi instead.
 */
@Deprecated public ISCSIVolumeSource getIscsi(){
            return this.iscsi!=null?this.iscsi.build():null;
    }

    public ISCSIVolumeSource buildIscsi(){
            return this.iscsi!=null?this.iscsi.build():null;
    }

    public A withIscsi(ISCSIVolumeSource iscsi){
            _visitables.remove(this.iscsi);
            if (iscsi!=null){ this.iscsi= new ISCSIVolumeSourceBuilder(iscsi); _visitables.add(this.iscsi);} return (A) this;
    }

    public Boolean hasIscsi(){
            return this.iscsi!=null;
    }

    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsi(){
            return new IscsiNestedImpl();
    }

    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item){
            return new IscsiNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.IscsiNested<A> editIscsi(){
            return withNewIscsiLike(getIscsi());
    }

    public PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsi(){
            return withNewIscsiLike(getIscsi() != null ? getIscsi(): new ISCSIVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.IscsiNested<A> editOrNewIscsiLike(ISCSIVolumeSource item){
            return withNewIscsiLike(getIscsi() != null ? getIscsi(): item);
    }

    
/**
 * This method has been deprecated, please use method buildNfs instead.
 */
@Deprecated public NFSVolumeSource getNfs(){
            return this.nfs!=null?this.nfs.build():null;
    }

    public NFSVolumeSource buildNfs(){
            return this.nfs!=null?this.nfs.build():null;
    }

    public A withNfs(NFSVolumeSource nfs){
            _visitables.remove(this.nfs);
            if (nfs!=null){ this.nfs= new NFSVolumeSourceBuilder(nfs); _visitables.add(this.nfs);} return (A) this;
    }

    public Boolean hasNfs(){
            return this.nfs!=null;
    }

    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfs(){
            return new NfsNestedImpl();
    }

    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item){
            return new NfsNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.NfsNested<A> editNfs(){
            return withNewNfsLike(getNfs());
    }

    public PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfs(){
            return withNewNfsLike(getNfs() != null ? getNfs(): new NFSVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.NfsNested<A> editOrNewNfsLike(NFSVolumeSource item){
            return withNewNfsLike(getNfs() != null ? getNfs(): item);
    }

    public A withNewNfs(String path,Boolean readOnly,String server){
            return (A)withNfs(new NFSVolumeSource(path, readOnly, server));
    }

    public String getPersistentVolumeReclaimPolicy(){
            return this.persistentVolumeReclaimPolicy;
    }

    public A withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy){
            this.persistentVolumeReclaimPolicy=persistentVolumeReclaimPolicy; return (A) this;
    }

    public Boolean hasPersistentVolumeReclaimPolicy(){
            return this.persistentVolumeReclaimPolicy!=null;
    }

    
/**
 * This method has been deprecated, please use method buildPhotonPersistentDisk instead.
 */
@Deprecated public PhotonPersistentDiskVolumeSource getPhotonPersistentDisk(){
            return this.photonPersistentDisk!=null?this.photonPersistentDisk.build():null;
    }

    public PhotonPersistentDiskVolumeSource buildPhotonPersistentDisk(){
            return this.photonPersistentDisk!=null?this.photonPersistentDisk.build():null;
    }

    public A withPhotonPersistentDisk(PhotonPersistentDiskVolumeSource photonPersistentDisk){
            _visitables.remove(this.photonPersistentDisk);
            if (photonPersistentDisk!=null){ this.photonPersistentDisk= new PhotonPersistentDiskVolumeSourceBuilder(photonPersistentDisk); _visitables.add(this.photonPersistentDisk);} return (A) this;
    }

    public Boolean hasPhotonPersistentDisk(){
            return this.photonPersistentDisk!=null;
    }

    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> withNewPhotonPersistentDisk(){
            return new PhotonPersistentDiskNestedImpl();
    }

    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> withNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item){
            return new PhotonPersistentDiskNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editPhotonPersistentDisk(){
            return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk());
    }

    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDisk(){
            return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk() != null ? getPhotonPersistentDisk(): new PhotonPersistentDiskVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item){
            return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk() != null ? getPhotonPersistentDisk(): item);
    }

    public A withNewPhotonPersistentDisk(String fsType,String pdID){
            return (A)withPhotonPersistentDisk(new PhotonPersistentDiskVolumeSource(fsType, pdID));
    }

    
/**
 * This method has been deprecated, please use method buildQuobyte instead.
 */
@Deprecated public QuobyteVolumeSource getQuobyte(){
            return this.quobyte!=null?this.quobyte.build():null;
    }

    public QuobyteVolumeSource buildQuobyte(){
            return this.quobyte!=null?this.quobyte.build():null;
    }

    public A withQuobyte(QuobyteVolumeSource quobyte){
            _visitables.remove(this.quobyte);
            if (quobyte!=null){ this.quobyte= new QuobyteVolumeSourceBuilder(quobyte); _visitables.add(this.quobyte);} return (A) this;
    }

    public Boolean hasQuobyte(){
            return this.quobyte!=null;
    }

    public PersistentVolumeSpecFluent.QuobyteNested<A> withNewQuobyte(){
            return new QuobyteNestedImpl();
    }

    public PersistentVolumeSpecFluent.QuobyteNested<A> withNewQuobyteLike(QuobyteVolumeSource item){
            return new QuobyteNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.QuobyteNested<A> editQuobyte(){
            return withNewQuobyteLike(getQuobyte());
    }

    public PersistentVolumeSpecFluent.QuobyteNested<A> editOrNewQuobyte(){
            return withNewQuobyteLike(getQuobyte() != null ? getQuobyte(): new QuobyteVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.QuobyteNested<A> editOrNewQuobyteLike(QuobyteVolumeSource item){
            return withNewQuobyteLike(getQuobyte() != null ? getQuobyte(): item);
    }

    public A withNewQuobyte(String group,Boolean readOnly,String registry,String user,String volume){
            return (A)withQuobyte(new QuobyteVolumeSource(group, readOnly, registry, user, volume));
    }

    
/**
 * This method has been deprecated, please use method buildRbd instead.
 */
@Deprecated public RBDVolumeSource getRbd(){
            return this.rbd!=null?this.rbd.build():null;
    }

    public RBDVolumeSource buildRbd(){
            return this.rbd!=null?this.rbd.build():null;
    }

    public A withRbd(RBDVolumeSource rbd){
            _visitables.remove(this.rbd);
            if (rbd!=null){ this.rbd= new RBDVolumeSourceBuilder(rbd); _visitables.add(this.rbd);} return (A) this;
    }

    public Boolean hasRbd(){
            return this.rbd!=null;
    }

    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbd(){
            return new RbdNestedImpl();
    }

    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item){
            return new RbdNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.RbdNested<A> editRbd(){
            return withNewRbdLike(getRbd());
    }

    public PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbd(){
            return withNewRbdLike(getRbd() != null ? getRbd(): new RBDVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.RbdNested<A> editOrNewRbdLike(RBDVolumeSource item){
            return withNewRbdLike(getRbd() != null ? getRbd(): item);
    }

    
/**
 * This method has been deprecated, please use method buildVsphereVolume instead.
 */
@Deprecated public VsphereVirtualDiskVolumeSource getVsphereVolume(){
            return this.vsphereVolume!=null?this.vsphereVolume.build():null;
    }

    public VsphereVirtualDiskVolumeSource buildVsphereVolume(){
            return this.vsphereVolume!=null?this.vsphereVolume.build():null;
    }

    public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume){
            _visitables.remove(this.vsphereVolume);
            if (vsphereVolume!=null){ this.vsphereVolume= new VsphereVirtualDiskVolumeSourceBuilder(vsphereVolume); _visitables.add(this.vsphereVolume);} return (A) this;
    }

    public Boolean hasVsphereVolume(){
            return this.vsphereVolume!=null;
    }

    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolume(){
            return new VsphereVolumeNestedImpl();
    }

    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item){
            return new VsphereVolumeNestedImpl(item);
    }

    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editVsphereVolume(){
            return withNewVsphereVolumeLike(getVsphereVolume());
    }

    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolume(){
            return withNewVsphereVolumeLike(getVsphereVolume() != null ? getVsphereVolume(): new VsphereVirtualDiskVolumeSourceBuilder().build());
    }

    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editOrNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item){
            return withNewVsphereVolumeLike(getVsphereVolume() != null ? getVsphereVolume(): item);
    }

    public A withNewVsphereVolume(String fsType,String volumePath){
            return (A)withVsphereVolume(new VsphereVirtualDiskVolumeSource(fsType, volumePath));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PersistentVolumeSpecFluentImpl that = (PersistentVolumeSpecFluentImpl) o;
            if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
            if (awsElasticBlockStore != null ? !awsElasticBlockStore.equals(that.awsElasticBlockStore) :that.awsElasticBlockStore != null) return false;
            if (azureDisk != null ? !azureDisk.equals(that.azureDisk) :that.azureDisk != null) return false;
            if (azureFile != null ? !azureFile.equals(that.azureFile) :that.azureFile != null) return false;
            if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
            if (cephfs != null ? !cephfs.equals(that.cephfs) :that.cephfs != null) return false;
            if (cinder != null ? !cinder.equals(that.cinder) :that.cinder != null) return false;
            if (claimRef != null ? !claimRef.equals(that.claimRef) :that.claimRef != null) return false;
            if (fc != null ? !fc.equals(that.fc) :that.fc != null) return false;
            if (flexVolume != null ? !flexVolume.equals(that.flexVolume) :that.flexVolume != null) return false;
            if (flocker != null ? !flocker.equals(that.flocker) :that.flocker != null) return false;
            if (gcePersistentDisk != null ? !gcePersistentDisk.equals(that.gcePersistentDisk) :that.gcePersistentDisk != null) return false;
            if (glusterfs != null ? !glusterfs.equals(that.glusterfs) :that.glusterfs != null) return false;
            if (hostPath != null ? !hostPath.equals(that.hostPath) :that.hostPath != null) return false;
            if (iscsi != null ? !iscsi.equals(that.iscsi) :that.iscsi != null) return false;
            if (nfs != null ? !nfs.equals(that.nfs) :that.nfs != null) return false;
            if (persistentVolumeReclaimPolicy != null ? !persistentVolumeReclaimPolicy.equals(that.persistentVolumeReclaimPolicy) :that.persistentVolumeReclaimPolicy != null) return false;
            if (photonPersistentDisk != null ? !photonPersistentDisk.equals(that.photonPersistentDisk) :that.photonPersistentDisk != null) return false;
            if (quobyte != null ? !quobyte.equals(that.quobyte) :that.quobyte != null) return false;
            if (rbd != null ? !rbd.equals(that.rbd) :that.rbd != null) return false;
            if (vsphereVolume != null ? !vsphereVolume.equals(that.vsphereVolume) :that.vsphereVolume != null) return false;
            return true;
    }


    public class AwsElasticBlockStoreNestedImpl<N> extends AWSElasticBlockStoreVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>> implements PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AWSElasticBlockStoreVolumeSourceBuilder builder;
    
            AwsElasticBlockStoreNestedImpl(AWSElasticBlockStoreVolumeSource item){
                    this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
            }
            AwsElasticBlockStoreNestedImpl(){
                    this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withAwsElasticBlockStore(builder.build());
    }
    public N endAwsElasticBlockStore(){
            return and();
    }

}
    public class AzureDiskNestedImpl<N> extends AzureDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AzureDiskNested<N>> implements PersistentVolumeSpecFluent.AzureDiskNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AzureDiskVolumeSourceBuilder builder;
    
            AzureDiskNestedImpl(AzureDiskVolumeSource item){
                    this.builder = new AzureDiskVolumeSourceBuilder(this, item);
            }
            AzureDiskNestedImpl(){
                    this.builder = new AzureDiskVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withAzureDisk(builder.build());
    }
    public N endAzureDisk(){
            return and();
    }

}
    public class AzureFileNestedImpl<N> extends AzureFileVolumeSourceFluentImpl<PersistentVolumeSpecFluent.AzureFileNested<N>> implements PersistentVolumeSpecFluent.AzureFileNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final AzureFileVolumeSourceBuilder builder;
    
            AzureFileNestedImpl(AzureFileVolumeSource item){
                    this.builder = new AzureFileVolumeSourceBuilder(this, item);
            }
            AzureFileNestedImpl(){
                    this.builder = new AzureFileVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withAzureFile(builder.build());
    }
    public N endAzureFile(){
            return and();
    }

}
    public class CephfsNestedImpl<N> extends CephFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CephfsNested<N>> implements PersistentVolumeSpecFluent.CephfsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CephFSVolumeSourceBuilder builder;
    
            CephfsNestedImpl(CephFSVolumeSource item){
                    this.builder = new CephFSVolumeSourceBuilder(this, item);
            }
            CephfsNestedImpl(){
                    this.builder = new CephFSVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withCephfs(builder.build());
    }
    public N endCephfs(){
            return and();
    }

}
    public class CinderNestedImpl<N> extends CinderVolumeSourceFluentImpl<PersistentVolumeSpecFluent.CinderNested<N>> implements PersistentVolumeSpecFluent.CinderNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final CinderVolumeSourceBuilder builder;
    
            CinderNestedImpl(CinderVolumeSource item){
                    this.builder = new CinderVolumeSourceBuilder(this, item);
            }
            CinderNestedImpl(){
                    this.builder = new CinderVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withCinder(builder.build());
    }
    public N endCinder(){
            return and();
    }

}
    public class ClaimRefNestedImpl<N> extends ObjectReferenceFluentImpl<PersistentVolumeSpecFluent.ClaimRefNested<N>> implements PersistentVolumeSpecFluent.ClaimRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            ClaimRefNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            ClaimRefNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withClaimRef(builder.build());
    }
    public N endClaimRef(){
            return and();
    }

}
    public class FcNestedImpl<N> extends FCVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FcNested<N>> implements PersistentVolumeSpecFluent.FcNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final FCVolumeSourceBuilder builder;
    
            FcNestedImpl(FCVolumeSource item){
                    this.builder = new FCVolumeSourceBuilder(this, item);
            }
            FcNestedImpl(){
                    this.builder = new FCVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withFc(builder.build());
    }
    public N endFc(){
            return and();
    }

}
    public class FlexVolumeNestedImpl<N> extends FlexVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlexVolumeNested<N>> implements PersistentVolumeSpecFluent.FlexVolumeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final FlexVolumeSourceBuilder builder;
    
            FlexVolumeNestedImpl(FlexVolumeSource item){
                    this.builder = new FlexVolumeSourceBuilder(this, item);
            }
            FlexVolumeNestedImpl(){
                    this.builder = new FlexVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withFlexVolume(builder.build());
    }
    public N endFlexVolume(){
            return and();
    }

}
    public class FlockerNestedImpl<N> extends FlockerVolumeSourceFluentImpl<PersistentVolumeSpecFluent.FlockerNested<N>> implements PersistentVolumeSpecFluent.FlockerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final FlockerVolumeSourceBuilder builder;
    
            FlockerNestedImpl(FlockerVolumeSource item){
                    this.builder = new FlockerVolumeSourceBuilder(this, item);
            }
            FlockerNestedImpl(){
                    this.builder = new FlockerVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withFlocker(builder.build());
    }
    public N endFlocker(){
            return and();
    }

}
    public class GcePersistentDiskNestedImpl<N> extends GCEPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GcePersistentDiskNested<N>> implements PersistentVolumeSpecFluent.GcePersistentDiskNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GCEPersistentDiskVolumeSourceBuilder builder;
    
            GcePersistentDiskNestedImpl(GCEPersistentDiskVolumeSource item){
                    this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
            }
            GcePersistentDiskNestedImpl(){
                    this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withGcePersistentDisk(builder.build());
    }
    public N endGcePersistentDisk(){
            return and();
    }

}
    public class GlusterfsNestedImpl<N> extends GlusterfsVolumeSourceFluentImpl<PersistentVolumeSpecFluent.GlusterfsNested<N>> implements PersistentVolumeSpecFluent.GlusterfsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GlusterfsVolumeSourceBuilder builder;
    
            GlusterfsNestedImpl(GlusterfsVolumeSource item){
                    this.builder = new GlusterfsVolumeSourceBuilder(this, item);
            }
            GlusterfsNestedImpl(){
                    this.builder = new GlusterfsVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withGlusterfs(builder.build());
    }
    public N endGlusterfs(){
            return and();
    }

}
    public class HostPathNestedImpl<N> extends HostPathVolumeSourceFluentImpl<PersistentVolumeSpecFluent.HostPathNested<N>> implements PersistentVolumeSpecFluent.HostPathNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HostPathVolumeSourceBuilder builder;
    
            HostPathNestedImpl(HostPathVolumeSource item){
                    this.builder = new HostPathVolumeSourceBuilder(this, item);
            }
            HostPathNestedImpl(){
                    this.builder = new HostPathVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withHostPath(builder.build());
    }
    public N endHostPath(){
            return and();
    }

}
    public class IscsiNestedImpl<N> extends ISCSIVolumeSourceFluentImpl<PersistentVolumeSpecFluent.IscsiNested<N>> implements PersistentVolumeSpecFluent.IscsiNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ISCSIVolumeSourceBuilder builder;
    
            IscsiNestedImpl(ISCSIVolumeSource item){
                    this.builder = new ISCSIVolumeSourceBuilder(this, item);
            }
            IscsiNestedImpl(){
                    this.builder = new ISCSIVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withIscsi(builder.build());
    }
    public N endIscsi(){
            return and();
    }

}
    public class NfsNestedImpl<N> extends NFSVolumeSourceFluentImpl<PersistentVolumeSpecFluent.NfsNested<N>> implements PersistentVolumeSpecFluent.NfsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NFSVolumeSourceBuilder builder;
    
            NfsNestedImpl(NFSVolumeSource item){
                    this.builder = new NFSVolumeSourceBuilder(this, item);
            }
            NfsNestedImpl(){
                    this.builder = new NFSVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withNfs(builder.build());
    }
    public N endNfs(){
            return and();
    }

}
    public class PhotonPersistentDiskNestedImpl<N> extends PhotonPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.PhotonPersistentDiskNested<N>> implements PersistentVolumeSpecFluent.PhotonPersistentDiskNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final PhotonPersistentDiskVolumeSourceBuilder builder;
    
            PhotonPersistentDiskNestedImpl(PhotonPersistentDiskVolumeSource item){
                    this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this, item);
            }
            PhotonPersistentDiskNestedImpl(){
                    this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withPhotonPersistentDisk(builder.build());
    }
    public N endPhotonPersistentDisk(){
            return and();
    }

}
    public class QuobyteNestedImpl<N> extends QuobyteVolumeSourceFluentImpl<PersistentVolumeSpecFluent.QuobyteNested<N>> implements PersistentVolumeSpecFluent.QuobyteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final QuobyteVolumeSourceBuilder builder;
    
            QuobyteNestedImpl(QuobyteVolumeSource item){
                    this.builder = new QuobyteVolumeSourceBuilder(this, item);
            }
            QuobyteNestedImpl(){
                    this.builder = new QuobyteVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withQuobyte(builder.build());
    }
    public N endQuobyte(){
            return and();
    }

}
    public class RbdNestedImpl<N> extends RBDVolumeSourceFluentImpl<PersistentVolumeSpecFluent.RbdNested<N>> implements PersistentVolumeSpecFluent.RbdNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RBDVolumeSourceBuilder builder;
    
            RbdNestedImpl(RBDVolumeSource item){
                    this.builder = new RBDVolumeSourceBuilder(this, item);
            }
            RbdNestedImpl(){
                    this.builder = new RBDVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withRbd(builder.build());
    }
    public N endRbd(){
            return and();
    }

}
    public class VsphereVolumeNestedImpl<N> extends VsphereVirtualDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluent.VsphereVolumeNested<N>> implements PersistentVolumeSpecFluent.VsphereVolumeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final VsphereVirtualDiskVolumeSourceBuilder builder;
    
            VsphereVolumeNestedImpl(VsphereVirtualDiskVolumeSource item){
                    this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
            }
            VsphereVolumeNestedImpl(){
                    this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this);
            }
    
    public N and(){
            return (N) PersistentVolumeSpecFluentImpl.this.withVsphereVolume(builder.build());
    }
    public N endVsphereVolume(){
            return and();
    }

}


}
