package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterPolicyListBuilder extends ClusterPolicyListFluentImpl<ClusterPolicyListBuilder> implements VisitableBuilder<ClusterPolicyList,ClusterPolicyListBuilder>{

    ClusterPolicyListFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterPolicyListBuilder(){
            this(true);
    }
    public ClusterPolicyListBuilder(Boolean validationEnabled){
            this(new ClusterPolicyList(), validationEnabled);
    }
    public ClusterPolicyListBuilder(ClusterPolicyListFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterPolicyListBuilder(ClusterPolicyListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterPolicyList(), validationEnabled);
    }
    public ClusterPolicyListBuilder(ClusterPolicyListFluent<?> fluent,ClusterPolicyList instance){
            this(fluent, instance, true);
    }
    public ClusterPolicyListBuilder(ClusterPolicyListFluent<?> fluent,ClusterPolicyList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterPolicyListBuilder(ClusterPolicyList instance){
            this(instance,true);
    }
    public ClusterPolicyListBuilder(ClusterPolicyList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public ClusterPolicyList build(){
            ClusterPolicyList buildable = new ClusterPolicyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterPolicyListBuilder that = (ClusterPolicyListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
