package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterPolicyBindingListFluent<A extends ClusterPolicyBindingListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,ClusterPolicyBinding item);
    public A setToItems(int index,ClusterPolicyBinding item);
    public A addToItems(ClusterPolicyBinding... items);
    public A addAllToItems(Collection<ClusterPolicyBinding> items);
    public A removeFromItems(ClusterPolicyBinding... items);
    public A removeAllFromItems(Collection<ClusterPolicyBinding> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 */
@Deprecated public List<ClusterPolicyBinding> getItems();
    public List<ClusterPolicyBinding> buildItems();
    public ClusterPolicyBinding buildItem(int index);
    public ClusterPolicyBinding buildFirstItem();
    public ClusterPolicyBinding buildLastItem();
    public ClusterPolicyBinding buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterPolicyBindingBuilder> predicate);
    public A withItems(List<ClusterPolicyBinding> items);
    public A withItems(ClusterPolicyBinding... items);
    public Boolean hasItems();
    public ClusterPolicyBindingListFluent.ItemsNested<A> addNewItem();
    public ClusterPolicyBindingListFluent.ItemsNested<A> addNewItemLike(ClusterPolicyBinding item);
    public ClusterPolicyBindingListFluent.ItemsNested<A> setNewItemLike(int index,ClusterPolicyBinding item);
    public ClusterPolicyBindingListFluent.ItemsNested<A> editItem(int index);
    public ClusterPolicyBindingListFluent.ItemsNested<A> editFirstItem();
    public ClusterPolicyBindingListFluent.ItemsNested<A> editLastItem();
    public ClusterPolicyBindingListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterPolicyBindingBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);
    public ClusterPolicyBindingListFluent.MetadataNested<A> withNewMetadata();
    public ClusterPolicyBindingListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ClusterPolicyBindingListFluent.MetadataNested<A> editMetadata();
    public ClusterPolicyBindingListFluent.MetadataNested<A> editOrNewMetadata();
    public ClusterPolicyBindingListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterPolicyBindingFluent<ClusterPolicyBindingListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<ClusterPolicyBindingListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
