package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesClusterRoleBindingListBuilder extends KubernetesClusterRoleBindingListFluentImpl<KubernetesClusterRoleBindingListBuilder> implements VisitableBuilder<KubernetesClusterRoleBindingList,KubernetesClusterRoleBindingListBuilder>{

    KubernetesClusterRoleBindingListFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesClusterRoleBindingListBuilder(){
            this(true);
    }
    public KubernetesClusterRoleBindingListBuilder(Boolean validationEnabled){
            this(new KubernetesClusterRoleBindingList(), validationEnabled);
    }
    public KubernetesClusterRoleBindingListBuilder(KubernetesClusterRoleBindingListFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesClusterRoleBindingListBuilder(KubernetesClusterRoleBindingListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesClusterRoleBindingList(), validationEnabled);
    }
    public KubernetesClusterRoleBindingListBuilder(KubernetesClusterRoleBindingListFluent<?> fluent,KubernetesClusterRoleBindingList instance){
            this(fluent, instance, true);
    }
    public KubernetesClusterRoleBindingListBuilder(KubernetesClusterRoleBindingListFluent<?> fluent,KubernetesClusterRoleBindingList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesClusterRoleBindingListBuilder(KubernetesClusterRoleBindingList instance){
            this(instance,true);
    }
    public KubernetesClusterRoleBindingListBuilder(KubernetesClusterRoleBindingList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubernetesClusterRoleBindingList build(){
            KubernetesClusterRoleBindingList buildable = new KubernetesClusterRoleBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesClusterRoleBindingListBuilder that = (KubernetesClusterRoleBindingListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
