package io.fabric8.kubernetes.api.model.apps;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;

public interface ReplicaSetFluent<A extends ReplicaSetFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ReplicaSetFluent.MetadataNested<A> withNewMetadata();
    public ReplicaSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ReplicaSetFluent.MetadataNested<A> editMetadata();
    public ReplicaSetFluent.MetadataNested<A> editOrNewMetadata();
    public ReplicaSetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 */
@Deprecated public ReplicaSetSpec getSpec();
    public ReplicaSetSpec buildSpec();
    public A withSpec(ReplicaSetSpec spec);
    public Boolean hasSpec();
    public ReplicaSetFluent.SpecNested<A> withNewSpec();
    public ReplicaSetFluent.SpecNested<A> withNewSpecLike(ReplicaSetSpec item);
    public ReplicaSetFluent.SpecNested<A> editSpec();
    public ReplicaSetFluent.SpecNested<A> editOrNewSpec();
    public ReplicaSetFluent.SpecNested<A> editOrNewSpecLike(ReplicaSetSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 */
@Deprecated public ReplicaSetStatus getStatus();
    public ReplicaSetStatus buildStatus();
    public A withStatus(ReplicaSetStatus status);
    public Boolean hasStatus();
    public ReplicaSetFluent.StatusNested<A> withNewStatus();
    public ReplicaSetFluent.StatusNested<A> withNewStatusLike(ReplicaSetStatus item);
    public ReplicaSetFluent.StatusNested<A> editStatus();
    public ReplicaSetFluent.StatusNested<A> editOrNewStatus();
    public ReplicaSetFluent.StatusNested<A> editOrNewStatusLike(ReplicaSetStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ReplicaSetFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicaSetSpecFluent<ReplicaSetFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicaSetStatusFluent<ReplicaSetFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
