package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesRoleBuilder extends KubernetesRoleFluentImpl<KubernetesRoleBuilder> implements VisitableBuilder<KubernetesRole,KubernetesRoleBuilder>{

    KubernetesRoleFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesRoleBuilder(){
            this(true);
    }
    public KubernetesRoleBuilder(Boolean validationEnabled){
            this(new KubernetesRole(), validationEnabled);
    }
    public KubernetesRoleBuilder(KubernetesRoleFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesRoleBuilder(KubernetesRoleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesRole(), validationEnabled);
    }
    public KubernetesRoleBuilder(KubernetesRoleFluent<?> fluent,KubernetesRole instance){
            this(fluent, instance, true);
    }
    public KubernetesRoleBuilder(KubernetesRoleFluent<?> fluent,KubernetesRole instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRules(instance.getRules()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesRoleBuilder(KubernetesRole instance){
            this(instance,true);
    }
    public KubernetesRoleBuilder(KubernetesRole instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRules(instance.getRules()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubernetesRole build(){
            KubernetesRole buildable = new KubernetesRole(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRules());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesRoleBuilder that = (KubernetesRoleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
