package io.fabric8.kubernetes.api.model.rbac;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KubernetesClusterRoleListFluent<A extends KubernetesClusterRoleListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,KubernetesClusterRole item);
    public A setToItems(int index,KubernetesClusterRole item);
    public A addToItems(KubernetesClusterRole... items);
    public A addAllToItems(Collection<KubernetesClusterRole> items);
    public A removeFromItems(KubernetesClusterRole... items);
    public A removeAllFromItems(Collection<KubernetesClusterRole> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 */
@Deprecated public List<KubernetesClusterRole> getItems();
    public List<KubernetesClusterRole> buildItems();
    public KubernetesClusterRole buildItem(int index);
    public KubernetesClusterRole buildFirstItem();
    public KubernetesClusterRole buildLastItem();
    public KubernetesClusterRole buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KubernetesClusterRoleBuilder> predicate);
    public A withItems(List<KubernetesClusterRole> items);
    public A withItems(KubernetesClusterRole... items);
    public Boolean hasItems();
    public KubernetesClusterRoleListFluent.ItemsNested<A> addNewItem();
    public KubernetesClusterRoleListFluent.ItemsNested<A> addNewItemLike(KubernetesClusterRole item);
    public KubernetesClusterRoleListFluent.ItemsNested<A> setNewItemLike(int index,KubernetesClusterRole item);
    public KubernetesClusterRoleListFluent.ItemsNested<A> editItem(int index);
    public KubernetesClusterRoleListFluent.ItemsNested<A> editFirstItem();
    public KubernetesClusterRoleListFluent.ItemsNested<A> editLastItem();
    public KubernetesClusterRoleListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KubernetesClusterRoleBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);
    public KubernetesClusterRoleListFluent.MetadataNested<A> withNewMetadata();
    public KubernetesClusterRoleListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public KubernetesClusterRoleListFluent.MetadataNested<A> editMetadata();
    public KubernetesClusterRoleListFluent.MetadataNested<A> editOrNewMetadata();
    public KubernetesClusterRoleListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubernetesClusterRoleFluent<KubernetesClusterRoleListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<KubernetesClusterRoleListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
