package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesClusterRoleBindingBuilder extends KubernetesClusterRoleBindingFluentImpl<KubernetesClusterRoleBindingBuilder> implements VisitableBuilder<KubernetesClusterRoleBinding,KubernetesClusterRoleBindingBuilder>{

    KubernetesClusterRoleBindingFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesClusterRoleBindingBuilder(){
            this(true);
    }
    public KubernetesClusterRoleBindingBuilder(Boolean validationEnabled){
            this(new KubernetesClusterRoleBinding(), validationEnabled);
    }
    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBindingFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesClusterRoleBinding(), validationEnabled);
    }
    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBindingFluent<?> fluent,KubernetesClusterRoleBinding instance){
            this(fluent, instance, true);
    }
    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBindingFluent<?> fluent,KubernetesClusterRoleBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRoleRef(instance.getRoleRef()); 
            fluent.withSubjects(instance.getSubjects()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBinding instance){
            this(instance,true);
    }
    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoleRef(instance.getRoleRef()); 
            this.withSubjects(instance.getSubjects()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubernetesClusterRoleBinding build(){
            KubernetesClusterRoleBinding buildable = new KubernetesClusterRoleBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRoleRef(),fluent.getSubjects());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesClusterRoleBindingBuilder that = (KubernetesClusterRoleBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
