package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface BuildStatusFluent<A extends BuildStatusFluent<A>> extends Fluent<A>{


    public Boolean isCancelled();
    public A withCancelled(Boolean cancelled);
    public Boolean hasCancelled();
    public String getCompletionTimestamp();
    public A withCompletionTimestamp(String completionTimestamp);
    public Boolean hasCompletionTimestamp();
    
/**
 * This method has been deprecated, please use method buildConfig instead.
 */
@Deprecated public ObjectReference getConfig();
    public ObjectReference buildConfig();
    public A withConfig(ObjectReference config);
    public Boolean hasConfig();
    public BuildStatusFluent.ConfigNested<A> withNewConfig();
    public BuildStatusFluent.ConfigNested<A> withNewConfigLike(ObjectReference item);
    public BuildStatusFluent.ConfigNested<A> editConfig();
    public BuildStatusFluent.ConfigNested<A> editOrNewConfig();
    public BuildStatusFluent.ConfigNested<A> editOrNewConfigLike(ObjectReference item);
    public Long getDuration();
    public A withDuration(Long duration);
    public Boolean hasDuration();
    public String getMessage();
    public A withMessage(String message);
    public Boolean hasMessage();
    
/**
 * This method has been deprecated, please use method buildOutput instead.
 */
@Deprecated public BuildStatusOutput getOutput();
    public BuildStatusOutput buildOutput();
    public A withOutput(BuildStatusOutput output);
    public Boolean hasOutput();
    public BuildStatusFluent.OutputNested<A> withNewOutput();
    public BuildStatusFluent.OutputNested<A> withNewOutputLike(BuildStatusOutput item);
    public BuildStatusFluent.OutputNested<A> editOutput();
    public BuildStatusFluent.OutputNested<A> editOrNewOutput();
    public BuildStatusFluent.OutputNested<A> editOrNewOutputLike(BuildStatusOutput item);
    public String getOutputDockerImageReference();
    public A withOutputDockerImageReference(String outputDockerImageReference);
    public Boolean hasOutputDockerImageReference();
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    public String getStartTimestamp();
    public A withStartTimestamp(String startTimestamp);
    public Boolean hasStartTimestamp();

    public interface ConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<BuildStatusFluent.ConfigNested<N>>{

        
    public N and();    public N endConfig();
}
    public interface OutputNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildStatusOutputFluent<BuildStatusFluent.OutputNested<N>>{

        
    public N and();    public N endOutput();
}


}
