package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PetSetSpecBuilder extends PetSetSpecFluentImpl<PetSetSpecBuilder> implements VisitableBuilder<PetSetSpec,PetSetSpecBuilder>{

    PetSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PetSetSpecBuilder(){
            this(true);
    }
    public PetSetSpecBuilder(Boolean validationEnabled){
            this(new PetSetSpec(), validationEnabled);
    }
    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent){
            this(fluent, true);
    }
    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PetSetSpec(), validationEnabled);
    }
    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent,PetSetSpec instance){
            this(fluent, instance, true);
    }
    public PetSetSpecBuilder(PetSetSpecFluent<?> fluent,PetSetSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplicas(instance.getReplicas()); 
            fluent.withSelector(instance.getSelector()); 
            fluent.withServiceName(instance.getServiceName()); 
            fluent.withTemplate(instance.getTemplate()); 
            fluent.withVolumeClaimTemplates(instance.getVolumeClaimTemplates()); 
            this.validationEnabled = validationEnabled; 
    }
    public PetSetSpecBuilder(PetSetSpec instance){
            this(instance,true);
    }
    public PetSetSpecBuilder(PetSetSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplicas(instance.getReplicas()); 
            this.withSelector(instance.getSelector()); 
            this.withServiceName(instance.getServiceName()); 
            this.withTemplate(instance.getTemplate()); 
            this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates()); 
            this.validationEnabled = validationEnabled; 
    }

    public PetSetSpec build(){
            PetSetSpec buildable = new PetSetSpec(fluent.getReplicas(),fluent.getSelector(),fluent.getServiceName(),fluent.getTemplate(),fluent.getVolumeClaimTemplates());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PetSetSpecBuilder that = (PetSetSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
