package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class FlockerVolumeSourceFluentImpl<A extends FlockerVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements FlockerVolumeSourceFluent<A>{

    private String datasetName;

    public FlockerVolumeSourceFluentImpl(){
    }
    public FlockerVolumeSourceFluentImpl(FlockerVolumeSource instance){
            this.withDatasetName(instance.getDatasetName()); 
    }

    public String getDatasetName(){
            return this.datasetName;
    }

    public A withDatasetName(String datasetName){
            this.datasetName=datasetName; return (A) this;
    }

    public Boolean hasDatasetName(){
            return this.datasetName!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FlockerVolumeSourceFluentImpl that = (FlockerVolumeSourceFluentImpl) o;
            if (datasetName != null ? !datasetName.equals(that.datasetName) :that.datasetName != null) return false;
            return true;
    }




}
