package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DeprecatedDownwardAPIVolumeSourceBuilder extends DeprecatedDownwardAPIVolumeSourceFluentImpl<DeprecatedDownwardAPIVolumeSourceBuilder> implements VisitableBuilder<DeprecatedDownwardAPIVolumeSource,DeprecatedDownwardAPIVolumeSourceBuilder>{

    DeprecatedDownwardAPIVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public DeprecatedDownwardAPIVolumeSourceBuilder(){
            this(true);
    }
    public DeprecatedDownwardAPIVolumeSourceBuilder(Boolean validationEnabled){
            this(new DeprecatedDownwardAPIVolumeSource(), validationEnabled);
    }
    public DeprecatedDownwardAPIVolumeSourceBuilder(DeprecatedDownwardAPIVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public DeprecatedDownwardAPIVolumeSourceBuilder(DeprecatedDownwardAPIVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DeprecatedDownwardAPIVolumeSource(), validationEnabled);
    }
    public DeprecatedDownwardAPIVolumeSourceBuilder(DeprecatedDownwardAPIVolumeSourceFluent<?> fluent,DeprecatedDownwardAPIVolumeSource instance){
            this(fluent, instance, true);
    }
    public DeprecatedDownwardAPIVolumeSourceBuilder(DeprecatedDownwardAPIVolumeSourceFluent<?> fluent,DeprecatedDownwardAPIVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDefaultMode(instance.getDefaultMode()); 
            fluent.withItems(instance.getItems()); 
            this.validationEnabled = validationEnabled; 
    }
    public DeprecatedDownwardAPIVolumeSourceBuilder(DeprecatedDownwardAPIVolumeSource instance){
            this(instance,true);
    }
    public DeprecatedDownwardAPIVolumeSourceBuilder(DeprecatedDownwardAPIVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDefaultMode(instance.getDefaultMode()); 
            this.withItems(instance.getItems()); 
            this.validationEnabled = validationEnabled; 
    }

    public DeprecatedDownwardAPIVolumeSource build(){
            DeprecatedDownwardAPIVolumeSource buildable = new DeprecatedDownwardAPIVolumeSource(fluent.getDefaultMode(),fluent.getItems());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeprecatedDownwardAPIVolumeSourceBuilder that = (DeprecatedDownwardAPIVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
