package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PetSetListFluent<A extends PetSetListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,PetSet item);
    public A setToItems(int index,PetSet item);
    public A addToItems(PetSet... items);
    public A addAllToItems(Collection<PetSet> items);
    public A removeFromItems(PetSet... items);
    public A removeAllFromItems(Collection<PetSet> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 */
@Deprecated public List<PetSet> getItems();
    public List<PetSet> buildItems();
    public PetSet buildItem(int index);
    public PetSet buildFirstItem();
    public PetSet buildLastItem();
    public PetSet buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PetSetBuilder> predicate);
    public A withItems(List<PetSet> items);
    public A withItems(PetSet... items);
    public Boolean hasItems();
    public PetSetListFluent.ItemsNested<A> addNewItem();
    public PetSetListFluent.ItemsNested<A> addNewItemLike(PetSet item);
    public PetSetListFluent.ItemsNested<A> setNewItemLike(int index,PetSet item);
    public PetSetListFluent.ItemsNested<A> editItem(int index);
    public PetSetListFluent.ItemsNested<A> editFirstItem();
    public PetSetListFluent.ItemsNested<A> editLastItem();
    public PetSetListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PetSetBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public PetSetListFluent.MetadataNested<A> withNewMetadata();
    public PetSetListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PetSetListFluent.MetadataNested<A> editMetadata();
    public PetSetListFluent.MetadataNested<A> editOrNewMetadata();
    public PetSetListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PetSetFluent<PetSetListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<PetSetListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
