package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

public interface PetSetFluent<A extends PetSetFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public PetSetFluent.MetadataNested<A> withNewMetadata();
    public PetSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PetSetFluent.MetadataNested<A> editMetadata();
    public PetSetFluent.MetadataNested<A> editOrNewMetadata();
    public PetSetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 */
@Deprecated public PetSetSpec getSpec();
    public PetSetSpec buildSpec();
    public A withSpec(PetSetSpec spec);
    public Boolean hasSpec();
    public PetSetFluent.SpecNested<A> withNewSpec();
    public PetSetFluent.SpecNested<A> withNewSpecLike(PetSetSpec item);
    public PetSetFluent.SpecNested<A> editSpec();
    public PetSetFluent.SpecNested<A> editOrNewSpec();
    public PetSetFluent.SpecNested<A> editOrNewSpecLike(PetSetSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 */
@Deprecated public PetSetStatus getStatus();
    public PetSetStatus buildStatus();
    public A withStatus(PetSetStatus status);
    public Boolean hasStatus();
    public PetSetFluent.StatusNested<A> withNewStatus();
    public PetSetFluent.StatusNested<A> withNewStatusLike(PetSetStatus item);
    public PetSetFluent.StatusNested<A> editStatus();
    public PetSetFluent.StatusNested<A> editOrNewStatus();
    public PetSetFluent.StatusNested<A> editOrNewStatusLike(PetSetStatus item);
    public A withNewStatus(Long observedGeneration,Integer replicas);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<PetSetFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PetSetSpecFluent<PetSetFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PetSetStatusFluent<PetSetFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
